package com.vrs.android.fyreon.fragments;

import android.app.Fragment;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.ui.WizardActivity;
import com.vrs.android.fyreon.utils.AppConstants;

public class TourFragment extends Fragment {
	Button btnSkip,btnGetTour;
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View rootView = inflater.inflate(R.layout.fragment_tour, container,
				false);
		final Bundle args = this.getArguments();
		btnSkip = (Button)rootView.findViewById(R.id.btnSkip);
		btnGetTour = (Button)rootView.findViewById(R.id.btnGetTour);
		btnSkip.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				replaceFragment(args);
			}
		});
		btnGetTour.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				Intent intTour = new Intent(getActivity(),WizardActivity.class);
				startActivity(intTour);				
				replaceFragment(args);
			}
		});
		return rootView;
	}
	
	private void replaceFragment(Bundle args){
		SharedPreferences mSharedPreferences = getActivity()
				.getSharedPreferences(AppConstants.PREF_NAME, 0);
		SharedPreferences.Editor editor = mSharedPreferences.edit();
		editor.putBoolean(AppConstants.PREF_IS_FIRST_LAUNCH, false).commit();
		
		Fragment fragment = new CommentFragment();
		fragment.setArguments(args);
		(getActivity()).getFragmentManager().beginTransaction()
				.add(R.id.layout_fyreon_widget_down_container, fragment).commit();
	}
}
