package com.vrs.android.fyreon.fragments;

import android.app.AlertDialog;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.ImageSlideAdapter;
import com.vrs.android.fyreon.interfaces.PageIndicator;
import com.vrs.android.fyreon.model.WizardModel;
import com.vrs.android.fyreon.widgets.CirclePageIndicator;

import java.util.ArrayList;
import java.util.List;

public class WizardFragment extends Fragment implements OnClickListener {

	public static final String ARG_ITEM_ID = "home_fragment";
	private int[] images = { R.drawable.step1, R.drawable.step2,
			R.drawable.step1, R.drawable.step2, R.drawable.step1 };

	private Button btnNext, btnPrevious, btnFinish;
	private RelativeLayout rlNavigationStrip;
	// UI References
	private ViewPager mViewPager;
	PageIndicator mIndicator;

	AlertDialog alertDialog;

	List<WizardModel> products = new ArrayList<WizardModel>();
	// RequestImgTask task;
	boolean stopSliding = false;
	String message;

	private Runnable animateViewPager;
	// private Handler handler;

	String url = "http://www.androidbegin.com/tutorial/jsonparsetutorial.txt";
	// String url = "http://www.topbusiness.in/demo/tor/demo/home_page_ws.php";
	FragmentActivity activity;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		activity = getActivity();
		for (int i = 0; i < images.length; i++) {
			WizardModel s = new WizardModel();
			s.setImageId(images[i]);
			products.add(s);

		}

	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View view = inflater
				.inflate(R.layout.wizard_fragment, container, false);
		findViewById(view);

		mIndicator.setOnPageChangeListener(new PageChangeListener());
		mViewPager.setOnPageChangeListener(new PageChangeListener());
		/*
		 * mViewPager.setOnTouchListener(new OnTouchListener() {
		 * 
		 * @Override public boolean onTouch(View v, MotionEvent event) {
		 * v.getParent().requestDisallowInterceptTouchEvent(true); switch
		 * (event.getAction()) {
		 * 
		 * case MotionEvent.ACTION_CANCEL: break;
		 * 
		 * case MotionEvent.ACTION_UP: // calls when touch release on ViewPager
		 * if (products != null && products.size() != 0) { stopSliding = false;
		 * 
		 * runnable(products.size()); handler.postDelayed(animateViewPager,
		 * ANIM_VIEWPAGER_DELAY_USER_VIEW);
		 * 
		 * } break;
		 * 
		 * case MotionEvent.ACTION_MOVE: // calls when ViewPager touch
		 * 
		 * if (handler != null && stopSliding == false) { stopSliding = true;
		 * handler.removeCallbacks(animateViewPager); }
		 * 
		 * break; } return false; } });
		 */

		return view;
	}

	private void findViewById(View view) {
		mViewPager = (ViewPager) view.findViewById(R.id.view_pager);
		mIndicator = (CirclePageIndicator) view.findViewById(R.id.indicator);
		btnNext = (Button) view.findViewById(R.id.wizard_next_button);
		btnPrevious = (Button) view.findViewById(R.id.wizard_previous_button);
		btnFinish = (Button) view.findViewById(R.id.btnWizardFinish);
		rlNavigationStrip = (RelativeLayout) view
				.findViewById(R.id.wizard_nevigation_strip);
		btnNext.setOnClickListener(this);
		btnPrevious.setOnClickListener(this);
		btnFinish.setOnClickListener(this);

	}

	/*
	 * public void runnable(final int size) { handler = new Handler();
	 * animateViewPager = new Runnable() { public void run() { if (!stopSliding)
	 * { if (mViewPager.getCurrentItem() == size - 1) {
	 * mViewPager.setCurrentItem(0); } else { mViewPager.setCurrentItem(
	 * mViewPager.getCurrentItem() + 1, true); }
	 * handler.postDelayed(animateViewPager, ANIM_VIEWPAGER_DELAY); } } }; }
	 */

	@Override
	public void onResume() {
		if (products != null && products.size() != 0) {

			mViewPager.setAdapter(new ImageSlideAdapter(activity, products,
					WizardFragment.this));

			mIndicator.setViewPager(mViewPager);
			if (mViewPager.getCurrentItem() == products.size() - 1) {
				btnNext.setVisibility(View.GONE);
				rlNavigationStrip.setVisibility(View.GONE);
				btnFinish.setVisibility(View.VISIBLE);
			} else {
				btnNext.setVisibility(View.VISIBLE);
				rlNavigationStrip.setVisibility(View.VISIBLE);
				btnFinish.setVisibility(View.GONE);
			}
			if (mViewPager.getCurrentItem() == 0) {
				btnPrevious.setVisibility(View.GONE);
			} else {
				btnPrevious.setVisibility(View.VISIBLE);
			}
			/*
			 * imgNameTxt.setText("" + ((Slider) products.get(mViewPager
			 * .getCurrentItem())).getName());
			 */
			// runnable(products.size());
			// handler.postDelayed(animateViewPager, ANIM_VIEWPAGER_DELAY);
		}
		super.onResume();
	}

	private class PageChangeListener implements OnPageChangeListener {

		@Override
		public void onPageScrollStateChanged(int state) {
			Log.d("SLIDER", "onPageScrollStateChanged : " + state);
			if (state == ViewPager.SCROLL_STATE_IDLE) {
				if (products != null) {
					/*
					 * imgNameTxt.setText("" + ((Slider) products.get(mViewPager
					 * .getCurrentItem())).getName());
					 */
					if (mViewPager.getCurrentItem() == products.size() - 1) {
						btnNext.setVisibility(View.GONE);
						rlNavigationStrip.setVisibility(View.GONE);
						btnFinish.setVisibility(View.VISIBLE);
					} else {
						btnNext.setVisibility(View.VISIBLE);
						rlNavigationStrip.setVisibility(View.VISIBLE);
						btnFinish.setVisibility(View.GONE);
					}
					if (mViewPager.getCurrentItem() == 0) {
						btnPrevious.setVisibility(View.GONE);
					} else {
						btnPrevious.setVisibility(View.VISIBLE);
					}
				}
			}
		}

		@Override
		public void onPageScrolled(int arg0, float arg1, int arg2) {
			Log.d("SLIDER", "onPageScrolled : " + arg0);
		}

		@Override
		public void onPageSelected(int arg0) {
		}
	}

	@Override
	public void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
	}

	@Override
	public void onClick(View v) {
		if (v.getId() == R.id.wizard_next_button) {
			mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
		}
		if (v.getId() == R.id.wizard_previous_button) {
			mViewPager.setCurrentItem(mViewPager.getCurrentItem() - 1);
		}
		if (v.getId() == R.id.btnWizardFinish)
		{
			getActivity().finish();
		}

	}

}