/**
 * ---------------------------------------------------------------------------------
 * File Name : CommentListModel.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */
package com.vrs.android.fyreon.model;

import java.util.ArrayList;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : CommentListModel
 * Description : Comment List model class
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 */
public class CommentListModel {

    public String comment_id;
    public String parent_id;
    public String social_id;
    public String screen_id;
    public String name;
    public String time;
    public String comment;
    public String icons;
    public String social_types;
    public String likes_count;
    public ArrayList<String> liked_by;
    public String liked_id;
    public String liked;
    public String replies;
    public String app_name;
    public String category;

    public CommentListModel(String comment_id, String parent_id, String social_id, String screen_id, String name, String time, String comment, String icons, String social_types, String likes_count, ArrayList<String> liked_by, String app_name, String replies, String category) {
        this.comment_id = comment_id;
        this.parent_id = parent_id;
        this.social_id = social_id;
        this.screen_id = screen_id;
        this.name = name;
        this.time = time;
        this.comment = comment;
        this.icons = icons;
        this.social_types = social_types;
        this.likes_count = likes_count;
        this.liked_by = liked_by;
        this.replies = replies;
        this.app_name = app_name;
        this.category = category;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getApp_name() {
        return app_name;
    }

    public void setApp_name(String app_name) {
        this.app_name = app_name;
    }

    public String getLikes_count() {
        return likes_count;
    }

    public void setLikes_count(String likes_count) {
        this.likes_count = likes_count;
    }

    public String getSocial_types() {
        return social_types;
    }

    public void setSocial_types(String social_types) {
        this.social_types = social_types;
    }

    public String getComment_id() {
        return comment_id;
    }

    public void setComment_id(String comment_id) {
        this.comment_id = comment_id;
    }

    public String getSocial_id() {
        return social_id;
    }

    public void setSocial_id(String social_id) {
        this.social_id = social_id;
    }

    public String getScreen_id() {
        return screen_id;
    }

    public void setScreen_id(String screen_id) {
        this.screen_id = screen_id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getIcons() {
        return icons;
    }

    public void setIcons(String icons) {
        this.icons = icons;
    }

    public String getParent_id() {
        return parent_id;
    }

    public void setParent_id(String parent_id) {
        this.parent_id = parent_id;
    }

    public ArrayList<String> getLiked_by() {
        return liked_by;
    }

    public void setLiked_by(ArrayList<String> liked_by) {
        this.liked_by = liked_by;
    }

    public String getLiked_id() {
        return liked_id;
    }

    public void setLiked_id(String liked_id) {
        this.liked_id = liked_id;
    }

    public String getLiked() {
        return liked;
    }

    public void setLiked(String liked) {
        this.liked = liked;
    }

    public String getReplies() {
        return replies;
    }

    public void setReplies(String replies) {
        this.replies = replies;
    }
}
