package com.vrs.android.fyreon.ui;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.fragments.WizardFragment;

public class WizardActivity extends FragmentActivity {

	private Fragment contentFragment;
	WizardFragment homeFragment;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.wizard_activity);

		FragmentManager fragmentManager = getSupportFragmentManager();

		if (savedInstanceState != null) {
			if (savedInstanceState.containsKey("content")) {
				String content = savedInstanceState.getString("content");
				
			}
			if (fragmentManager.findFragmentByTag(WizardFragment.ARG_ITEM_ID) != null) {
				homeFragment = (WizardFragment) fragmentManager
						.findFragmentByTag(WizardFragment.ARG_ITEM_ID);
				contentFragment = homeFragment;
			}
		} else {
			homeFragment = new WizardFragment();
			switchContent(homeFragment, WizardFragment.ARG_ITEM_ID);
		}
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		if (contentFragment instanceof WizardFragment) {
			outState.putString("content", WizardFragment.ARG_ITEM_ID);
		} else {
			
		}
		super.onSaveInstanceState(outState);
	}

	public void switchContent(Fragment fragment, String tag) {
		FragmentManager fragmentManager = getSupportFragmentManager();
		while (fragmentManager.popBackStackImmediate())
			;

		if (fragment != null) {
			FragmentTransaction transaction = fragmentManager
					.beginTransaction();
			transaction.replace(R.id.content_frame, fragment, tag);
			// Only ProductDetailFragment is added to the back stack.
			if (!(fragment instanceof WizardFragment)) {
				transaction.addToBackStack(tag);
			}
			transaction.commit();
			contentFragment = fragment;
		}
	}

	@Override
	public void onBackPressed() {
		FragmentManager fm = getSupportFragmentManager();
		if (fm.getBackStackEntryCount() > 0) {
			super.onBackPressed();
		} else if (contentFragment instanceof WizardFragment
				|| fm.getBackStackEntryCount() == 0) {
			finish();
		} 
	}
	
}