package com.vrs.android.fyreon.adapters;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.NotificationModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.adapters
 * Created by vrsuser on 25/6/15.
 * Time : 11:27 AM
 * Project : FyreonTest
 * Modified : 25 11 27
 */
public class NotificationAdapter extends ArrayAdapter<NotificationModel> {
    static final String LOG_TAG = NotificationAdapter.class.getSimpleName();
    private static final Logger logger = new Logger(true, LOG_TAG);
    List<NotificationModel> dataList = new ArrayList<>();
    Context mContext;
    LayoutInflater mInflater = null;
    SharedPreferences mSharedPref;
    DisplayImageOptions displayOptions;

    public NotificationAdapter(Context context, int resource, List<NotificationModel> objects) {
        super(context, resource);
        this.mContext = context;
        this.dataList = objects;
        mSharedPref = context.getSharedPreferences(AppConstants.PREF_NAME, Context.MODE_PRIVATE);
        displayOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon).showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
    }

    @Override
    public int getCount() {
        return dataList.size();
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        ViewHolder holder = new ViewHolder();
        View layoutView = convertView;
        if (layoutView == null) {
            mInflater = (LayoutInflater) mContext
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            layoutView = mInflater.inflate(R.layout.list_item_notification, null, false);
            holder.txtDate = (TextView) layoutView
                    .findViewById(R.id.txtDate);
            holder.txtNotification = (TextView) layoutView.findViewById(R.id.txtNotification);
            holder.txtUsername = (TextView) layoutView.findViewById(R.id.txtUserName);
            holder.txtAdmin = (TextView) layoutView.findViewById(R.id
                    .comment_list_item_txt_andmin_badge);
            layoutView.setTag(holder);
        } else {
            holder = (ViewHolder) layoutView.getTag();
        }

        final NotificationModel commentDataList = dataList.get(position);

        holder.txtNotification.setText(commentDataList.getMessage());
        holder.txtDate.setText(AppConstants.getTimeTwitter(Long.parseLong(commentDataList.getUpdatedTime())));
        holder.txtUsername.setText(commentDataList.getUsername());
        if (commentDataList.isAdmin()) {
            holder.txtAdmin.setVisibility(View.VISIBLE);
        } else {
            holder.txtAdmin.setVisibility(View.GONE);
        }
        return layoutView;
    }

    private class ViewHolder {
        public TextView txtNotification, txtDate, txtUsername, txtAdmin;
    }

}
