package com.vrs.android.fyreon.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Message;

import com.google.gson.JsonObject;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.vrs.android.fyreon.database.DatabaseCipherHelper;
import com.vrs.android.fyreon.model.CrashData;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.ArrayList;

public class SendData extends BroadcastReceiver {
    private static final Logger logger = new Logger(true, SendData.class.getSimpleName());
    DatabaseCipherHelper dbhelper;
    SQLiteDatabase db;
    int rowId;
    int response;
    ArrayList<CrashData> crashData;
    Cursor c;
    String data;
    ArrayList<String> dataId = new ArrayList<String>();
    private Context mContext;

    @Override
    public void onReceive(Context arg0, Intent arg1) {
        logger.debug("Message", "Receive Broadcast");
        mContext = arg0;
        PackageManager pm = arg0.getPackageManager();
        try {
            data = (String) pm.getApplicationLabel(pm.getApplicationInfo(arg0
                            .getApplicationContext().getPackageName(),
                    PackageManager.GET_META_DATA));
        } catch (NameNotFoundException e1) {
            e1.printStackTrace();
        }
        dbhelper = new DatabaseCipherHelper(arg0, data + "_INFO.db");
        if (AppConstants.isNetworkAvailable(arg0)) {
            logger.debug("message", "networkavailable");

            if (AppConstants.getData(arg0, arg0.getApplicationContext()
                    .getPackageName())) {

                logger.debug("Message", "Network Available in BroadcastReceiver");
                db = dbhelper.getReadableDatabase();
                crashData = new ArrayList<CrashData>();
                crashData = getAllData();
                // logger.debug("CrashData", ""+crashData.size());

                for (int i = 0; i < crashData.size(); i++) {
                    final CrashData data = crashData.get(i);
                    sendDataAndRemove(data);

                }

            }
        }

    }

    public void sendDataAndRemove(final CrashData data) {
        final Handler handler = new Handler() {

            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (response > 0) {

                    for (int i = 0; i < dataId.size(); i++) {
                        logger.debug("Message", "" + dataId.get(i));
                        dbhelper.deleteRecord(Integer.parseInt(dataId.get(i)));
                    }

                }
            }
        };

        final Thread thread = new Thread() {

            @Override
            public void run() {
                // TODO Auto-generated method stub
                super.run();
                try {
                    sendData(data);

                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    handler.sendEmptyMessage(0);

                }
            }

        };
        thread.start();
    }

    public void sendData(final CrashData data) {
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("stack_trace", data.getStrace());
        jsonParams.addProperty("brand", data.getBrand());
        jsonParams.addProperty("device", data.getDevice());
        jsonParams.addProperty("model", data.getModel());
        jsonParams.addProperty("manufacturer", data.getManufacturer());
        jsonParams.addProperty("os_api", data.getApi());
        jsonParams.addProperty("memory", data.getMemory());
        jsonParams.addProperty("cpu", data.getCpu());
        jsonParams.addProperty("package", data.getPackageName());
        jsonParams.addProperty("app_name", data.getAppName());
        jsonParams.addProperty("api_key", "" + data.getUserKey());
        jsonParams.addProperty("platform", "android");

        OkHttpClientUtil.getInstance().initialize(mContext);
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_SEND_CRASH_REPORT, jsonParams.toString(), new
                    Callback() {
                        @Override
                        public void onFailure(Request request, IOException e) {

                        }

                        @Override
                        public void onResponse(Response response) throws IOException {
                            if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                                response.cacheResponse();
                                dataId.add("" + data.getRowId());
                            }
                        }
                    });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Cursor getData() {
        Cursor mCur = null;

        if (db != null) {
            db = dbhelper.getWritableDatabase();
            // dbhelper.insertCrashData("Hello", "Android", "generic",
            // "generic",
            // "generic", "14", "10", "10", "com.vrs.manual", "manual",
            // "1234-5678-9876", "Android", "1234");

            logger.debug("Database", "" + db.isOpen());
            logger.debug("message", "db not null");

            String selectQuery = null;
            selectQuery = "select * from CrashData;";
            mCur = db.rawQuery(selectQuery, null);
            logger.debug("Cursor Count", "" + mCur.getCount());

            // mCur = db.query("CrashData", null, null, null,
            // null, null, null);
            return mCur;
        }
        return mCur;
    }

    public ArrayList<CrashData> getAllData() {

        c = getData();
        // logger.debug("Cursor Count", ""+c.getCount());

        if (c.moveToFirst()) {
            do {
                CrashData data = new CrashData();
                data.setApi((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_ANDROID_API_VERSION))));
                logger.debug("API",
                        ""
                                + c.getString(c
                                .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_USER_KEY)));
                data.setAppName((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_APP_NAME))));
                data.setBrand((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_BRAND))));
                data.setCpu((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_CPU_USAGE))));
                data.setDevice((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_DEVICE))));
                data.setManufacturer((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_DEVICE_MANUFACTURE))));
                data.setMemory((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_TOTAL_MEMORY))));
                data.setModel((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_MODAL))));
                data.setPackageName((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_PACKAGE_NAME))));
                data.setStrace((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_STACK_TRACE))));
                data.setUserKey((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_USER_KEY))));
                data.setRowId(c.getInt(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_ID)));

                logger.debug("Row id",
                        " id "
                                + c.getLong(c
                                .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_ID)));
                crashData.add(data);
            } while (c.moveToNext());
        }
        c.close();
        return crashData;
    }

}
