package com.vrs.android.fyreon.fragments;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.NotificationAdapter;
import com.vrs.android.fyreon.model.NotificationModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;

import java.util.ArrayList;

/**
 * Package Name : com.vrs.android.fyreon.fragments
 * Created by vrsuser on 25/6/15.
 * Time : 10:16 AM
 * Project : FyreonTest
 * Modified : 25 10 16
 */
public class NotificationFragment extends Fragment {

    private static final String LOG_TAG = NotificationFragment.class.getSimpleName();
    private static final Logger logger = new Logger(true, LOG_TAG);
    private ArrayList<NotificationModel> mNotificationList;
    private NotificationAdapter mAdapter;
    private ListView mListView;
    private LinearLayout mBackLayout;


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_notification, container, false);
        initView(rootView);
        initList();
        return rootView;
    }

    private void initView(View rootView) {
        mListView = (ListView) rootView.findViewById(R.id.fragment_notification_lv_comment);
        mBackLayout = (LinearLayout) rootView.findViewById(R.id.previous_layout);

        mBackLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FragmentManager manager = getFragmentManager();
                FragmentTransaction ft = manager.beginTransaction();
                Fragment mFragment = new CommentFragment();
                ft.setCustomAnimations(R.anim.fade_in_fragment,
                        R.anim.fade_out_fragment);
                ft.replace(R.id.layout_fyreon_widget_down_container, mFragment);
                ft.commit();
            }
        });
    }


    public void initList() {
        mNotificationList = new ArrayList<>();
        int code = getArguments().getInt(AppConstants.BUNDLE_NOTIFICATION_CODE);
        if (code == AppConstants.STATUS_CODE_SUCCESS) {
            String response = getArguments().getString(AppConstants.BUNDLE_NOTIFICATION_KEY);
            if (response != null) {
                JsonParser parser = new JsonParser();
                JsonElement commentsElement = parser.parse(response);
                JsonArray result = commentsElement.getAsJsonArray();
                for (int i = 0; i < result.size(); i++) {
                    JsonObject commentObject = result.get(i).getAsJsonObject();
                    logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                    String createdTime = commentObject.get("created").getAsString();
                    String content = commentObject.get("content").getAsString();
                    String username = commentObject.get("user_name").getAsString();
                    boolean isAdmin = commentObject.get("is_admin").getAsBoolean();

                    NotificationModel model = new NotificationModel(content, createdTime,
                            username, isAdmin);
                    mNotificationList.add(model);

                }
                if (mNotificationList.size() > 0) {
                    mAdapter = new NotificationAdapter(getActivity(), R.layout
                            .list_item_notification, mNotificationList);
                    mListView.setAdapter(mAdapter);
                }
            }
        }
    }
}
