package com.vrs.android.fyreon.ui;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.widget.ListView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.CommentUserDetailListAdapter;
import com.vrs.android.fyreon.handlers.ExceptionHandler;
import com.vrs.android.fyreon.model.UserDetail;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.ArrayList;

/**
 * Package Name : com.vrs.android.fyreon.ui
 * Created by vrsuser on 21/4/15.
 * Time : 11:52 AM
 * Project : fyreon-library-android
 * Modified : 21 11 52
 */
public class CommentUserDetails extends AppCompatActivity {

    private static final String LOG_TAG = CommentUserDetails.class.getSimpleName();
    private static final Logger logger = new Logger(true, LOG_TAG);
    private static SharedPreferences mSharedPreferences;
    boolean isFavorite;
    private Toolbar mToolbar;
    private ListView lvUserList;
    private CommentUserDetailListAdapter mAdapter;
    private ArrayList<UserDetail> mUserDetail;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_user_details_comments);

        mToolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolbar);
    }

    @Override
    protected void onResume() {
        super.onResume();
        mSharedPreferences = getApplicationContext().getSharedPreferences(AppConstants.PREF_NAME, 0);
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(
                getApplicationContext()));
        AppConstants.isCreateDatabase = true;
        AppConstants.setData(getApplicationContext(), true, this.getApplicationContext().getPackageName());


        initView();
        setupView();
    }

    private void initView() {
        lvUserList = (ListView) findViewById(R.id.activity_lv_detail_list);
        mUserDetail = new ArrayList<UserDetail>();
    }

    private void setupView() {
        isFavorite = getIntent().getBooleanExtra("favorite", true);
        if (isFavorite)
            getSupportActionBar().setTitle("Favorited By");
        else
            getSupportActionBar().setTitle("Comments By");

        getSupportActionBar().setHomeButtonEnabled(true);
        addComment();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        int i = item.getItemId();
        if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    private void addComment() {
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("comment_id", getIntent().getStringExtra("comment_id"));
        logger.debug(LOG_TAG, "Add Comment json Body : " + jsonParams.toString());
        String URL;
        if (isFavorite)
            URL = AppConstants.URL_GET_LIKED_COMMENT_DETAIL;
        else
            URL = AppConstants.URL_GET_REPLIED_COMMENT_DETAIL;

        OkHttpClientUtil.getInstance().initialize(getApplicationContext());
        try {
            OkHttpClientUtil.doPostRequest(URL, jsonParams.toString(), new Callback() {
                @Override
                public void onFailure(Request request, IOException e) {

                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                        response.cacheResponse();

                        final String resBody = response.body().string();
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(resBody);
                                JsonArray result = commentsElement.getAsJsonArray();
                                mUserDetail.clear();
                                for (int i = 0; i < result.size(); i++) {
                                    JsonObject commentObject = result.get(i).getAsJsonObject();
                                    String icon = commentObject.get("user_image").getAsString();
                                    String name = commentObject.get("user_name").getAsString();
                                    String socialType = commentObject.get("social_type").getAsString();
                                    UserDetail model = new UserDetail(icon, name, socialType);
                                    mUserDetail.add(model);
                                }
                                mAdapter = new CommentUserDetailListAdapter(getApplicationContext(), R.layout.list_user_detail_cell, mUserDetail);
                                lvUserList.setAdapter(mAdapter);
                            }
                        });
                    } else {
                        logger.error(LOG_TAG, "Unidentifed Response Code : " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
