/**
 * ---------------------------------------------------------------------------------
 * File Name : SocialLoginActivity.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */

package com.vrs.android.fyreon.ui;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.StrictMode;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.UiLifecycleHelper;
import com.facebook.model.GraphUser;
import com.facebook.widget.LoginButton;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.plus.Plus;
import com.google.android.gms.plus.model.people.Person;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.squareup.okhttp.Callback;
import com.vrs.android.fyreon.FyreonWidget;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.SetupFacebook;
import com.vrs.android.fyreon.model.SetupTwitter;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.List;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : SocialLoginActivity
 * Description : SocialLoginActivity class user login module.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         30/3/15    Bhadresh    Add Login Interface.
 *         -----------------------------------------------------------------------------------
 * @see android.app.Activity
 * @see android.view.View.OnClickListener
 * @see com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks
 * @see com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener
 */
public class SocialLoginActivity extends AppCompatActivity implements View.OnClickListener, GoogleApiClient
        .ConnectionCallbacks, GoogleApiClient.OnConnectionFailedListener {

    //
    private static final int TWITTER_REQ_CODE = 10;
    private static final int GOOGLE_PLUS_REQ_CODE = 0;
    private static final String LOG_TAG = SocialLoginActivity.class.getSimpleName();
    private static final Logger logger = new Logger(true, LOG_TAG);
    // Twitter CONSTANTS
    private static final String VERIFIER = "verifier";
    private static final String PREF_KEY_OAUTH_TOKEN = "oauth_token";
    private static final String PREF_KEY_OAUTH_SECRET = "oauth_token_secret";
    private static final String PREF_KEY_TWITTER_LOGIN = "is_twitter_loggedin";
    //  private static final String PREF_USER_NAME = "twitter_user_name";
    // Twitter APIs member declaration
    //  private static final String PREF_USER_EMAIL = "gplus_user_email";
    private static Twitter mTwitter;
    // Facebook APIs member declaration
    private static RequestToken mTwitterRequestToken;
    private static List<String> FB_PERMISSIONS;
    private static UiLifecycleHelper mUiHelper;
    // Google Plus APIs member declaration and flags
    private static boolean isPermissionRead = false;
    private static SetupTwitter setupTwitter;
    private static SetupFacebook setupFacebook;
    private static SharedPreferences mSharedPreferences;
    // Social Login setup member declaration and flags
    private static boolean mIsLoginSuccess;
    private FyreonWidget mFyreonWidgetListener;
    /**
     * ---------------------------------------------------------------------------------
     * Method Name : statusCallback
     * Description : Facebook Session status callback
     * Date of Creation : 25/02/15
     *
     * @return StatusCallback
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public Session.StatusCallback statusCallback = new Session.StatusCallback() {
        @Override
        public void call(final Session session, SessionState state,
                         Exception exception) {
            if (state.isOpened()) {
                onSessionStateChange(session, state, exception);
                // Here we will reset the UI.
                logger.debug(LOG_TAG, "Facebook session opened");
                final SharedPreferences.Editor e = mSharedPreferences.edit();
                Request request = Request.newMeRequest(session, new Request.GraphUserCallback() {
                    @Override
                    public void onCompleted(GraphUser user, Response response) {
                        // If the response is successful
                        if (session == Session.getActiveSession()) {
                            if (user != null) {
                                //                                ProfilePictureView profilePictureView = (ProfilePictureView) findViewById(R.id.comment_list_item_fb_profile_image);
                                //                                profilePictureView.setCropped(true);
                                //                                profilePictureView.setProfileId(user.getId());
                                //logger.debug(LOG_TAG, user.getId());
                                // e.putString(AppConstants.PREF_SOCIAL_ID, user.getId());
                                saveUserProfileInfo(user.getId(), user.getName(), AppConstants.SOCIAL_TYPES_FACEBOOK, "https://graph.facebook.com/" + user.getId() + "/picture?type=large", user.getBirthday(), "");
                                e.commit();
                                if (mFyreonWidgetListener != null) {
                                    mFyreonWidgetListener.onLoginSuccess(user.getId(), user.getName(), user.getId());
                                }
                            }
                        }
                    }
                });
                Request.executeBatchAsync(request);
                // e.putString(AppConstants.PREF_SOCIAL_TYPE, "f");
                // e.putBoolean(AppConstants.PREF_IS_LOGIN, true);
                // e.commit();
                finish();


            } else if (state.isClosed()) {
                onSessionStateChange(session, state, exception);
                logger.debug(LOG_TAG, "Facebook session closed");
                SharedPreferences.Editor e = mSharedPreferences.edit();
                e.putBoolean(AppConstants.PREF_IS_LOGIN, false);
                e.commit();
                if (mFyreonWidgetListener != null) {
                    mFyreonWidgetListener.onLoginFailure();
                }
                Toast.makeText(getApplicationContext(), getString(R.string.fb_login_request), Toast.LENGTH_LONG).show();
            }
        }
    };
    private Button btnFyreonLogin;
    private MaterialEditText etUserName, etPassword;
    private TextView txtRegister;
    private Toolbar mToolBar;
    private GoogleApiClient mGoogleApiClient;

    // SharedPreferences and user login stat members
    private ConnectionResult mConnectionResult;
    private boolean mIntentInProgress;

    // Widgets Referances
    private boolean mSignInClicked;
    private LinearLayout llMessageLayout;
    private ImageButton btnTwitterLogin;
    private LoginButton btnFacebookLogin;
    private ImageButton btnGooglePlusLogin;

    // Parent Class methods Overriding

    public SocialLoginActivity() {
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : setupFacebookWithReadPermissions
     * Description : Setup Facebook with read permission
     * Date of Creation : 25/02/15
     *
     * @param mPermission -------------------------------------------------------------------------------------
     *                    Update Log:
     *                    Date:		By:		Details:
     *                    <p/>
     *                    25/2/15    Rajan       Create full class
     *                    24/3/15    Bhadresh    Refactor code as per coding standard.
     *                    -----------------------------------------------------------------------------------
     */
    public static void setupFacebookWithReadPermissions(List<String> mPermission, Context mContext) {
        mSharedPreferences = mContext.getSharedPreferences(AppConstants.PREF_NAME, 0);
        SharedPreferences.Editor e = mSharedPreferences.edit();
        e.putBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, true).commit();
        setupFacebook = new SetupFacebook();
        setupFacebook.setReadPermissions(mPermission);
        FB_PERMISSIONS = setupFacebook.getReadPermissions();
        isPermissionRead = true;
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy(policy);
    }

    public static void setupGplus(Context mContext) {
        mSharedPreferences = mContext.getSharedPreferences(AppConstants.PREF_NAME, 0);
        SharedPreferences.Editor e = mSharedPreferences.edit();
        e.putBoolean(AppConstants.IS_GPLUS_INTEGRATED, true).commit();
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : setupFacebookWithPublishPermissions
     * Description : Setup Facebook with publish permission
     * Date of Creation : 25/02/15
     *
     * @param mPermission -------------------------------------------------------------------------------------
     *                    Update Log:
     *                    Date:		By:		Details:
     *                    <p/>
     *                    25/2/15    Rajan
     *                    24/3/15    Bhadresh    Refactor code as per coding standard.
     *                    -----------------------------------------------------------------------------------
     */
    public static void setupFacebookWithPublishPermissions(List<String> mPermission) {
        setupFacebook = new SetupFacebook();
        setupFacebook.setPublishPermissions(mPermission);
        FB_PERMISSIONS = setupFacebook.getPublishPermissions();
        isPermissionRead = false;
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy(policy);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : onSessionStateChange
     * Description : Facebook status change callback
     * Date of Creation : 25/02/15
     *
     * @param session
     * @param state
     * @param exception -------------------------------------------------------------------------------------
     *                  Update Log:
     *                  Date:		By:		Details:
     *                  <p/>
     *                  25/2/15    Rajan
     *                  24/3/15    Bhadresh    Refactor code as per coding standard.
     *                  -----------------------------------------------------------------------------------
     */
    private static void onSessionStateChange(Session session, SessionState state, Exception exception) {
        if (state.isOpened()) {
            logger.info(LOG_TAG, "Logged in...");
        } else if (state.isClosed()) {
            logger.info(LOG_TAG, "Logged out...");
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : checkPermissions
     * Description : Check required permissions for Facebook.
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public static boolean checkPermissions() {
        Session s = Session.getActiveSession();
        if (s != null) {
            return s.getPermissions().contains("publish_actions");
        } else
            return false;
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : setupTwitter
     * Description : Setup twitter login with all required resources like kye,secret
     * Date of Creation : 25/02/15
     *
     * @param consumerKey
     * @param consumerSecret
     * @param callbackUrl
     * @param oAuthVerifier
     * @param mContext       -------------------------------------------------------------------------------------
     *                       Update Log:
     *                       Date:		By:		Details:
     *                       <p/>
     *                       25/2/15    Rajan
     *                       24/3/15    Bhadresh    Refactor code as per coding standard.
     *                       -----------------------------------------------------------------------------------
     */
    public static void setupTwitter(String consumerKey, String consumerSecret,
                                    String callbackUrl, String oAuthVerifier, Context mContext) {
        mSharedPreferences = mContext.getSharedPreferences(AppConstants.PREF_NAME, 0);
        SharedPreferences.Editor e = mSharedPreferences.edit();
        e.putBoolean(AppConstants.IS_TWITTER_INTEGRATED, true);
        e.putString(AppConstants.TWITTER_CONSUMER_KEY, consumerKey);
        e.putString(AppConstants.TWITTER_CONSUMER_SECRET, consumerSecret);
        e.commit();

        setupTwitter = new SetupTwitter();
        setupTwitter.setConsumerKey(consumerKey);
        setupTwitter.setConsumerSecret(consumerSecret);
        setupTwitter.setCallbackUrl(callbackUrl);
        setupTwitter.setoAuthVerifier(oAuthVerifier);
        logger.debug(LOG_TAG, "Key : " + setupTwitter.getConsumerKey());
        logger.debug(LOG_TAG, "Secret : " + setupTwitter.getConsumerSecret());
        logger.debug(LOG_TAG, "Call Back : " + setupTwitter.getCallbackUrl());
        logger.debug(LOG_TAG, "Auth : " + setupTwitter.getoAuthVerifier());
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy(policy);


    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);
        mToolBar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolBar);
        mSharedPreferences = getApplicationContext().getSharedPreferences(AppConstants.PREF_NAME, 0);
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {
            mUiHelper = new UiLifecycleHelper(this, statusCallback);
            mUiHelper.onCreate(savedInstanceState);

        }
        mFyreonWidgetListener = new FyreonWidget(SocialLoginActivity.this);
        initViews();
        setupGooglePlus();

        getSupportActionBar().setTitle(getString(R.string.fyreon_connect));
    }

    @Override
    public void onResume() {
        super.onResume();
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false))
            mUiHelper.onResume();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false))
            mUiHelper.onPause();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (mGoogleApiClient.isConnected()) {
            mGoogleApiClient.disconnect();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false))
            mUiHelper.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        int i = item.getItemId();
        if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false))
            mUiHelper.onSaveInstanceState(outState);
    }

    @Override
    public void onConnected(Bundle bundle) {
        mSignInClicked = false;
        Toast.makeText(this, "User is connected!", Toast.LENGTH_LONG).show();
        getProfileInformation();
    }

    @Override
    public void onConnectionSuspended(int i) {
        mGoogleApiClient.connect();
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        if (!result.hasResolution()) {
            GooglePlayServicesUtil.getErrorDialog(result.getErrorCode(), this,
                    0).show();
            return;
        }

        if (!mIntentInProgress) {
            // Store the ConnectionResult for later usage
            mConnectionResult = result;

            if (mSignInClicked) {
                // The user has already clicked 'sign-in' so we attempt to
                // resolve all
                // errors until the user is signed in, or they cancel.
                resolveSignInError();
            }
        }
    }

    public void requestPermissions() {
        Session s = Session.getActiveSession();
        if (s != null) {
            s.requestNewPublishPermissions(new Session.NewPermissionsRequest(this, FB_PERMISSIONS));
        }

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        logger.debug(LOG_TAG, "Result Code :" + requestCode);
        if (requestCode == GOOGLE_PLUS_REQ_CODE) {
            if (resultCode != RESULT_OK) {
                mSignInClicked = false;
            }

            mIntentInProgress = false;

            if (!mGoogleApiClient.isConnecting()) {
                mGoogleApiClient.connect();
            }
        }
        if (requestCode == TWITTER_REQ_CODE) {
            if (resultCode == Activity.RESULT_OK) {
                String verifier = data.getExtras().getString(setupTwitter.getoAuthVerifier());
                if (!verifier.equals("")) {
                    try {
                        AccessToken accessToken = mTwitter.getOAuthAccessToken(mTwitterRequestToken, verifier);
                        mIsLoginSuccess = true;
                        long userID = accessToken.getUserId();
                        final User user = mTwitter.showUser(userID);
                        String username = user.getName();
                        saveTwitterInfo(accessToken);


                    } catch (Exception e) {
                        logger.error(LOG_TAG, e.getMessage());
                    }
                }


            }

        } else {
            mUiHelper.onActivityResult(requestCode, resultCode, data);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onClick(View view) {

        if (view == btnTwitterLogin) {
//            if (mIsLoginSuccess) {
//                // changeUI();
//            } else {
//                loginToTwitter();
//            }
            if (AppConstants.isNetworkAvailable(getApplicationContext())) {
                loginToTwitter();
            } else {
                Toast.makeText(getApplicationContext(), getString(R.string.network_error),
                        Toast.LENGTH_LONG).show();
            }

        }
        if (view == btnGooglePlusLogin) {
            if (AppConstants.isNetworkAvailable(getApplicationContext())) {
                signInWithGplus();
            } else {
                Toast.makeText(getApplicationContext(), getString(R.string.network_error),
                        Toast.LENGTH_LONG).show();
            }
        }
        if (view == btnFyreonLogin) {
            if (!AppConstants.isNetworkAvailable(getApplicationContext())) {
                Toast.makeText(getApplicationContext(), R.string.network_error,
                        Toast.LENGTH_LONG).show();
            } else {
                if (!(etUserName.getText().toString().equalsIgnoreCase("") || etPassword
                        .getText().toString().equalsIgnoreCase(""))) {
                    loginWithFyreon(etUserName.getText().toString(),
                            etPassword.getText().toString());
                } else {
                    Toast.makeText(getApplicationContext(),
                            getString(R.string.error_username_password),
                            Toast.LENGTH_LONG).show();
                }

            }
        }
    }

    private void loginWithFyreon(String userName, String password) {
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("username", userName);
        jsonParams.addProperty("password", password);
        final ProgressDialog p = new ProgressDialog(this);
        p.setMessage("Please wait");
        p.show();
        OkHttpClientUtil.getInstance().initialize(getApplicationContext());
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_LOGIN_WITH_FYREON,
                    jsonParams.toString(), new Callback() {

                        @Override
                        public void onResponse(
                                com.squareup.okhttp.Response response)
                                throws IOException {
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    p.dismiss();
                                }
                            });
                            if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                                final String resBody = response.body().string();
                                logger.error(LOG_TAG,
                                        "Success : " + response.code() + " : "
                                                + resBody);
                                JsonParser parser = new JsonParser();
                                JsonElement userElement = parser.parse(resBody);
                                JsonObject userObject = userElement
                                        .getAsJsonObject();
                                final String name = userObject.get("user_name")
                                        .getAsString();
                                final String social_id = userObject.get(
                                        "social_id").getAsString();
                                final String social_types = userObject.get(
                                        "social_type").getAsString();
                                final String image = userObject
                                        .get("image_url").getAsString();
                                final String bdate = userObject.get(
                                        "birth_date").getAsString();
                                final String email = userObject.get("email")
                                        .getAsString();

                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        saveUserProfileInfo(social_id, name,
                                                social_types, image, bdate,
                                                email);
                                    }
                                });

                            } else if (response.code() == AppConstants.STATUS_CODE_FAILURE_AUTH) {
                                final String resBody = response.body().string();
                                JsonParser parser = new JsonParser();
                                JsonElement userElement = parser.parse(resBody);
                                final JsonObject userObject = userElement
                                        .getAsJsonObject();
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        Toast.makeText(
                                                getApplicationContext(),
                                                userObject.get("msg")
                                                        .getAsString(),
                                                Toast.LENGTH_LONG).show();
                                    }
                                });

                                logger.error(LOG_TAG,
                                        "Success : " + response.code() + " : "
                                                + resBody);
                            } else {
                                logger.error(LOG_TAG,
                                        "Unidentified Response code : "
                                                + response.code() + " : "
                                                + response.body().string());
                            }
                        }

                        @Override
                        public void onFailure(com.squareup.okhttp.Request arg0,
                                              IOException arg1) {
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    p.dismiss();
                                }
                            });
                            logger.error(LOG_TAG, "Failed to login");
                        }
                    });
        } catch (IOException e) {
        }

    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : setupGooglePlus
     * Description : Setup Google Plus Login resources
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private void setupGooglePlus() {
        // Initializing google plus api client
        mGoogleApiClient = new GoogleApiClient.Builder(this)
                .addConnectionCallbacks(this)
                .addOnConnectionFailedListener(this).addApi(Plus.API)
                .addScope(Plus.SCOPE_PLUS_LOGIN).build();
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : initViews
     * Description : Initialize UI elements.
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private void initViews() {
        // mLoginLayout = (RelativeLayout) this.findViewById(R.id.login_layout);
        llMessageLayout = (LinearLayout) this.findViewById(R.id.fragment_comment_ll_mesaage);
        btnTwitterLogin = (ImageButton) this.findViewById(R.id.activity_login_btn_twitter_login);
        btnFacebookLogin = (LoginButton) this.findViewById(R.id.activity_login_btn_fb_login);
        btnGooglePlusLogin = (ImageButton) this.findViewById(R.id.activity_login_btn_gplus_login);
        btnFyreonLogin = (Button) this.findViewById(R.id.activity_login_btn_fyreon_login);
        etUserName = (MaterialEditText) this.findViewById(R.id.activity_fyreon_username);
        etPassword = (MaterialEditText) this.findViewById(R.id.activity_fyreon_password);
        txtRegister = (TextView) findViewById(R.id.activity_login_txt_registration);
        txtRegister.setText(Html.fromHtml("Not a member? " +
                "<a href='http://www.google.com'>Sign up now</a>"));
        txtRegister.setClickable(true);
        txtRegister.setMovementMethod(LinkMovementMethod.getInstance());

        btnGooglePlusLogin.setOnClickListener(this);

        btnTwitterLogin.setOnClickListener(this);
        btnFyreonLogin.setOnClickListener(this);
        btnFacebookLogin.setOnClickListener(this);

        if (!mSharedPreferences.getBoolean(AppConstants.IS_TWITTER_INTEGRATED, false)) {
            btnTwitterLogin.setVisibility(View.GONE);
        }
        if (!mSharedPreferences.getBoolean(AppConstants.IS_GPLUS_INTEGRATED, false)) {
            btnGooglePlusLogin.setVisibility(View.GONE);
        }
        if (!mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {
            btnFacebookLogin.setVisibility(View.GONE);
        } else {
            if (isPermissionRead) {
                if (setupFacebook.getReadPermissions() != null) {
                    btnFacebookLogin.setReadPermissions(setupFacebook.getReadPermissions());
                }

            } else {
                if (setupFacebook.getPublishPermissions() != null) {
                    btnFacebookLogin.setPublishPermissions(setupFacebook.getPublishPermissions());
                }


            }
        }

    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : isLoggedIn
     * Description : Check users login status for .
     * Date of Creation : 25/02/15
     *
     * @return boolean
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private boolean isLogin() {
        boolean isLoggedIn = mSharedPreferences.getBoolean(PREF_KEY_TWITTER_LOGIN, false);

        return isLoggedIn;
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : loginToTwitter
     * Description : Twitter Login method
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private void loginToTwitter() {
        boolean isLoggedIn = mSharedPreferences.getBoolean(PREF_KEY_TWITTER_LOGIN, false);

        if (!isLoggedIn) {
            final ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.setOAuthConsumerKey(setupTwitter.getConsumerKey());
            builder.setOAuthConsumerSecret(setupTwitter.getConsumerSecret());

            final Configuration configuration = builder.build();
            final TwitterFactory factory = new TwitterFactory(configuration);
            mTwitter = factory.getInstance();

            try {
                mTwitterRequestToken = mTwitter.getOAuthRequestToken(setupTwitter.getCallbackUrl());
                TwitterLoginActivity.mSetupTwitter = setupTwitter;
                final Intent intent = new Intent(getApplicationContext(), TwitterLoginActivity.class);
                intent.putExtra(TwitterLoginActivity.EXTRA_URL, mTwitterRequestToken.getAuthenticationURL());
                startActivityForResult(intent, TWITTER_REQ_CODE);

            } catch (TwitterException e) {
                e.printStackTrace();
            }
        } else {
            logger.debug(LOG_TAG, "Message Send Successfully");
            // Toast.makeText(getApplicationContext(), "Message Send Successfully", Toast.LENGTH_LONG).show();
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : saveUserProfileInfo
     * Description : Save google plus and facebook user information into shared preferences.
     * Date of Creation : 25/02/15
     *
     * @param email
     * @param name
     * @param socialId -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan
     *                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                 -----------------------------------------------------------------------------------
     */
    private void saveUserProfileInfo(String socialId, String name, String socialTypes, String imageURL, String birthDate, String email) {

        addProfileInformation(socialId, name, socialTypes, imageURL, birthDate, email);
            /* Storing oAuth tokens to shared preferences */
        SharedPreferences.Editor e = mSharedPreferences.edit();
        e.putBoolean(AppConstants.PREF_IS_LOGIN, true);
        e.putString(AppConstants.PREF_SOCIAL_ID, socialId);
        e.putString(AppConstants.PREF_USER_NAME, name);
        e.putString(AppConstants.PREF_SOCIAL_TYPE, socialTypes);
        e.putString(AppConstants.PREF_USER_PROFILE_IMAGE, imageURL);
//        if(!birthDate.equals(null))
        e.putString(AppConstants.PREF_USER_BDATE, "" + birthDate);
//        else
//            e.putString(AppConstants.PREF_USER_BDATE, "");
        e.putString(AppConstants.PREF_USER_EMAIL, email);
        e.commit();
        finish();
        if (mFyreonWidgetListener != null) {
            mFyreonWidgetListener.onLoginSuccess(socialId, name, imageURL);
        }

    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : saveUserProfileInfo
     * Description : Save Twitter user information into shared preferences.
     * Date of Creation : 25/02/15
     *
     * @param accessToken ---------------------------------------------------------------
     *                    Update Log:
     *                    Date:		By:		Details:
     *                    <p/>
     *                    25/2/15    Rajan
     *                    24/3/15    Bhadresh    Refactor code as per coding standard.
     *                    -----------------------------------------------------------------------------------
     */
    private void saveTwitterInfo(AccessToken accessToken) {
        long userID = accessToken.getUserId();
        User user;
        try {
            user = mTwitter.showUser(userID);
            String username = user.getName();
            /* Storing oAuth tokens to shared preferences */
            SharedPreferences.Editor e = mSharedPreferences.edit();
            e.putBoolean(AppConstants.PREF_IS_LOGIN, true);
            e.putString(AppConstants.PREF_SOCIAL_ID, String.valueOf(userID));
            e.putString(AppConstants.PREF_USER_NAME, username);
            e.putString(AppConstants.PREF_SOCIAL_TYPE, AppConstants.SOCIAL_TYPES_TWITTER);
            e.putString(AppConstants.PREF_USER_PROFILE_IMAGE, user.getProfileImageURL());
            e.putString(AppConstants.PREF_USER_BDATE, "");
            e.putString(AppConstants.PREF_USER_EMAIL, "");
            e.putString(PREF_KEY_OAUTH_TOKEN, accessToken.getToken());
            e.putString(PREF_KEY_OAUTH_SECRET, accessToken.getTokenSecret());
            addProfileInformation(String.valueOf(userID), username, AppConstants.SOCIAL_TYPES_TWITTER, user.getProfileImageURL(), "", "");
            e.commit();
            finish();
            if (mFyreonWidgetListener != null) {
                mFyreonWidgetListener.onLoginSuccess(String.valueOf(userID), username, user.getProfileImageURL());
            }


        } catch (TwitterException e1) {
            e1.printStackTrace();
        }
    }

    private void addProfileInformation(String socialId, String name, String socialTypes, String imageURL, String birthDate, String email) {
        logger.debug(LOG_TAG, "Social ID :" + socialId);

        try {
            ApplicationInfo ai = getApplicationContext().getPackageManager().getApplicationInfo(getApplicationContext().getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = ai.metaData;
            String apiKey = bundle.getString("com.vrs.android.fyreon.FyreonWidget.API_KEY");
            JsonObject jsonParams = new JsonObject();
            jsonParams.addProperty("social_id", socialId);
            jsonParams.addProperty("social_type", socialTypes);
            jsonParams.addProperty("name", name);
            jsonParams.addProperty("email", email);
            jsonParams.addProperty("image_path", imageURL);
            jsonParams.addProperty("birth_date", "" + birthDate);
            jsonParams.addProperty("api_key", apiKey);
            logger.debug(LOG_TAG, "Json Body : " + jsonParams.toString());

            OkHttpClientUtil.getInstance().initialize(getApplicationContext());

            try {
                OkHttpClientUtil.doPostRequest(AppConstants.URL_ADD_USER_PROFILE, jsonParams.toString
                        (), new Callback() {
                    @Override
                    public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                        logger.debug(LOG_TAG, "Exception : " + e.getMessage());
                    }

                    @Override
                    public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                        if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                            response.cacheResponse();
                            logger.debug(LOG_TAG, "Success : " + response.body().string());

                        } else {
                            logger.info(LOG_TAG, "Unidentified Response Code : " + response.code());
                        }
                    }
                });
            } catch (IOException e) {
                e.printStackTrace();
            }

        } catch (PackageManager.NameNotFoundException e) {
            logger.error(LOG_TAG, "Exeption : " + e.getMessage());
        }


    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : getProfileInformation
     * Description : Get Google Pluse users profile information.
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private void getProfileInformation() {
        try {
            if (Plus.PeopleApi.getCurrentPerson(mGoogleApiClient) != null) {
                Person currentPerson = Plus.PeopleApi
                        .getCurrentPerson(mGoogleApiClient);
                String personID = currentPerson.getId();
                String personName = currentPerson.getDisplayName();
                String socilaTypes = AppConstants.SOCIAL_TYPES_GPLUS;
                String personPhotoUrl = currentPerson.getImage().getUrl();
                String birthDate = currentPerson.getBirthday();
                String email = Plus.AccountApi.getAccountName(mGoogleApiClient);

                currentPerson.getGender();
                currentPerson.getBirthday();


                logger.error(LOG_TAG, "Name: " + personName + ", email: " + email
                        + ", Image: " + personPhotoUrl);
                saveUserProfileInfo(personID, personName, socilaTypes, personPhotoUrl, birthDate, email);
            } else {
                Toast.makeText(getApplicationContext(),
                        "Person information is null", Toast.LENGTH_LONG).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void signInWithGplus() {
        if (!mGoogleApiClient.isConnecting()) {
            mSignInClicked = true;
            mGoogleApiClient.connect();
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : resolveSignInError
     * Description : Resolve Google Plus Signin error when expiry of tokens
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private void resolveSignInError() {
        if (mConnectionResult.hasResolution()) {
            try {
                mIntentInProgress = true;
                mConnectionResult.startResolutionForResult(this, GOOGLE_PLUS_REQ_CODE);
            } catch (IntentSender.SendIntentException e) {
                mIntentInProgress = false;
                mGoogleApiClient.connect();
            }
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Interface Name : LoginInterface
     * Description : LoginInterface is listen when login.
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 30/3/15    Bhadresh    Create new interface
     * -----------------------------------------------------------------------------------
     */
    public interface LoginInterface {
        void onLoginSuccess(String id, String name, String imageURL);

        void onLoginFailure();
    }
}
