/**
 * ---------------------------------------------------------------------------------
 * File Name : AppConstants.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */
package com.vrs.android.fyreon.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Seconds;
import org.joda.time.Years;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : AppConstants
 * Description : Contains all required constants for application.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 */
public class AppConstants {
    // Twitter Constants
    public static final String TWITTER_CONSUMER_KEY = "twitter_consumer_key";
    public static final String TWITTER_CONSUMER_SECRET = "twitter_consumer_secrete";
    public static final String IS_TWITTER_INTEGRATED = "is_twitter_integrated";
    public static final String IS_FACEBOOK_INTEGRATED = "is_facebook_integrated";
    public static final String IS_GPLUS_INTEGRATED = "is_gplus_integrated";
    public static final String PREF_KEY_OAUTH_TOKEN = "oauth_token";
    public static final String PREF_KEY_OAUTH_SECRET = "oauth_token_secret";
    public static final String PREFS_NAME_CATEGORY = "CrashData";
    public static final String PREFS_VALUE_CATEGORY = "isDatabase";
    public static final String BUNDLE_NOTIFICATION_KEY = "notification";
    // Web Service Constants

    public static final String BASE_URL = "https://fyreon.herokuapp.com/api/";
    //    public static final String BASE_URL = "http://192.168.1.14:8000/api/";
    public static final String URL_DATA = BASE_URL + "get_comments/";
    public static final String URL_KEY_VERIFICATION = BASE_URL + "get_screen_key/";
    public static final String URL_ADD_COMMENT = BASE_URL + "add_comment/";
    public static final String URL_COMMENT_COUNT = BASE_URL + "get_comments_meta/";
    public static final String URL_COMMENT_LIKE = BASE_URL + "set_comment_like/";
    public static final String URL_GET_USER_PROFILE = BASE_URL + "get_user_profile/";
    public static final String URL_GET_USER_COMMENTS = BASE_URL + "get_user_comments/";
    public static final String URL_GET_USER_LIKES = BASE_URL + "get_user_likes/";
    public static final String URL_GET_USER_APPS = BASE_URL + "get_user_apps/";
    public static final String URL_ADD_USER_PROFILE = BASE_URL + "add_profile/";
    public static final String URL_UPDATE_USER_PROFILE = BASE_URL + "edit_profile/";
    public static final String URL_GET_APP_DETAIL = BASE_URL + "get_app_details/";
    public static final String URL_GET_LIKED_COMMENT_DETAIL = BASE_URL + "get_comment_likes/";
    public static final String URL_GET_REPLIED_COMMENT_DETAIL = BASE_URL + "get_comment_replies/";
    public static final String URL_SEND_CRASH_REPORT = BASE_URL + "submit_crash_report/";
    public static final String URL_LOGIN_WITH_FYREON = BASE_URL + "fyreon_login/";
    public static final String URL_ADMIN_NOTFICATION_COUNTER = BASE_URL + "get_broadcast_message/";

    public static final int STATUS_CODE_SUCCESS = 200;
    public static final int STATUS_CODE_FAILURE = 400;
    public static final int STATUS_CODE_FAILURE_AUTH = 401;
    public static final String APPID = "appid";

    // SharedPreferences Constants
    public static final String PREF_APP_FIRST_LAUNCH = "is_first_launch";
    public static final String PREF_NAME = "FireOnPrefs";
    public static final String PREF_IS_LOGIN = "is_login";
    public static final String PREF_SOCIAL_ID = "social_id";
    public static final String PREF_SOCIAL_TYPE = "social_type";
    public static final String PREF_USER_NAME = "user_name";
    public static final String PREF_USER_PROFILE_IMAGE = "user_profile_image";
    public static final String PREF_USER_BDATE = "user_bdate";
    public static final String PREF_USER_EMAIL = "user_email";
    public static final String PREF_HAS_APP_ICON_SENDED = "has_app_icon_sended";

    public static final int MAX_COUNT = 140;
    public static final String COMMENT_ID = "id";
    public static final String COMMENT_PARENT_ID = "parent_id";
    public static final String COMMENT_SCREEN_KEY = "screen_key";

    // Intent Data from List to Composer Activity.
    public static final String COMMENT_SOCIAL_ID = "social_id";
    public static final String COMMENT_SOCIAL_TYPE = "social_type";
    public static final String COMMENT_CREATED = "created";
    public static final String COMMENT_CONTENT = "content";
    public static final String COMMENT_LIKES = "likes";
    public static final String COMMENT_USER_NAME = "user_name";
    public static final String COMMENT_USER_IMAGE = "user_image";
    public static final String COMMENT_COMMENT_LIKES = "comment_likes";
    public static final String COMMENT_REPLIES = "replies";
    public static final String COMMENT_APP_NAME = "app_name";
    public static final String WIDGET_CATEGORY = "widget_category";
    public static final String SCREEN_NAME = "screen_name";
    public static final String SOCIAL_TYPES_FACEBOOK = "facebook"; //facebook
    public static final String SOCIAL_TYPES_TWITTER = "twitter";  //twitter
    public static final String SOCIAL_TYPES_GPLUS = "google";      //google
    public static final String PREF_IS_FIRST_LAUNCH = "is_first_launch";

    public static boolean isCreateDatabase = true;
    public static String dataBaseName;
    public static String APP_KEY = "";
    public static String BUNDLE_NOTIFICATION_CODE = "code";
    public static String PREF_NOTIFICATION_READ_KEY = "n_read";

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getDateCurrentTimeZone
     * Description : This method will accept time stamp and it will return date in format
     * "MM/dd/yyyy HH:mm:ss"
     * Date of Creation : 25/02/15
     *
     * @param timestamp
     * @return String currentTimeZone
     * @throws Exception -------------------------------------------------------------------------------------
     *                   Update Log:
     *                   Date:		By:		Details:
     *                   <p/>
     *                   25/2/15    Rajan       Create full class
     *                   24/3/15    Bhadresh    Refactor code as per coding standard.
     *                   -----------------------------------------------------------------------------------
     */
    @SuppressLint("SimpleDateFormat")
    public static String getDateCurrentTimeZone(long timestamp) {
        Date timeDate = new Date(timestamp);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm a dd-MMM-yyyy");
        return formatter.format(timeDate);
    }

    public static void setData(Context context, Boolean storeData, String packageName) {
        SharedPreferences.Editor editor = context.getSharedPreferences(
                PREFS_NAME_CATEGORY + packageName,
                Context.MODE_PRIVATE).edit();
        editor.putBoolean(PREFS_VALUE_CATEGORY + packageName,
                storeData);
        editor.apply();
    }

    public static Boolean getData(Context context, String packageName) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(
                PREFS_NAME_CATEGORY + packageName,
                Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(PREFS_VALUE_CATEGORY + packageName, false);
    }

    // For Checking the Internet
    public static boolean isNetworkAvailable(Context context) {
        // Get Connectivity Manager class object from Systems Service
        ConnectivityManager cm = (ConnectivityManager) context
                .getSystemService(Context.CONNECTIVITY_SERVICE);

        // Get Network Info from connectivity Manager
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        return networkInfo != null && networkInfo.isConnected();
    }

    public static String getTimeTwitter(long timestamp) {
        DateTimeZone.setDefault(DateTimeZone.forID("GMT"));
        DateTime myBirthDate = new DateTime(timestamp);
        DateTime now = new DateTime();

        Duration duration = new Duration(myBirthDate, now);

        int year = Years.yearsBetween(myBirthDate, now).getYears();
        int months = Months.monthsBetween(myBirthDate, now).getMonths();
        int days = Days.daysBetween(myBirthDate, now).getDays();
        int hours = Hours.hoursBetween(myBirthDate, now).getHours();
        int minutes = Minutes.minutesBetween(myBirthDate, now).getMinutes();
        int seconds = Seconds.secondsBetween(myBirthDate, now).getSeconds();


        if (String.valueOf(year).startsWith("-") || String.valueOf(months).startsWith("-") || String
                .valueOf(days).startsWith("-") || String.valueOf(hours).startsWith("-") || String
                .valueOf(minutes).startsWith("-") || String.valueOf(seconds).startsWith("-")) {
            return "now";
        }


        if (year != 0) {
            String elapsed = year + " y";
            return elapsed;
        } else if (months != 0) {
            String elapsed = months + " m";
            return elapsed;
        } else if (days != 0) {
            String elapsed = days + " d";
            return elapsed;
        } else if (hours != 0) {
            String elapsed = hours + " h";
            return elapsed;
        } else if (minutes != 0) {
            String elapsed = minutes + " min";
            return elapsed;
        } else if (seconds != 0) {
            String elapsed = seconds + " s";
            return elapsed;
        } else if (duration.getMillis() != 0) {
            String elapsed = "now";
            return elapsed;
        } else {
            return null;
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : Save network Response to file
     * Description : Save network Response to file
     * Date of Creation : 25/02/15
     *
     * @param mFile
     * @param mContent -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Create full class
     *                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                 -----------------------------------------------------------------------------------
     */
    public static void saveResponse(File mFile, String mContent) throws Exception {
        FileUtils.fileWrite(mFile.getAbsolutePath(), mContent);
    }

    public static String identifyCodes(int code) {
        String result = null;
        if (code == ErrorViewStatusCodes.CODE_111) {
            result = "Connection Failed";
        } else if (code == ErrorViewStatusCodes.CODE_400) {
            result = "Bad Request";
        } else if (code == ErrorViewStatusCodes.CODE_401) {
            result = "Unauthorized";
        } else if (code == ErrorViewStatusCodes.CODE_402) {
            result = "Payment Required";
        } else if (code == ErrorViewStatusCodes.CODE_403) {
            result = "Forbidden";
        } else if (code == ErrorViewStatusCodes.CODE_404) {
            result = "Not Found";
        } else if (code == ErrorViewStatusCodes.CODE_405) {
            result = "Method Not Allowed";
        } else if (code == ErrorViewStatusCodes.CODE_406) {
            result = "Not Acceptable";
        } else if (code == ErrorViewStatusCodes.CODE_407) {
            result = "Proxy Authentication Required";
        } else if (code == ErrorViewStatusCodes.CODE_408) {
            result = "Request Timeout";
        } else if (code == ErrorViewStatusCodes.CODE_409) {
            result = "Conflict";
        } else if (code == ErrorViewStatusCodes.CODE_410) {
            result = "Gone";
        } else if (code == ErrorViewStatusCodes.CODE_411) {
            result = "Length Required";
        } else if (code == ErrorViewStatusCodes.CODE_412) {
            result = "Precondition Failed";
        } else if (code == ErrorViewStatusCodes.CODE_413) {
            result = "Request Entity Too Large";
        } else if (code == ErrorViewStatusCodes.CODE_414) {
            result = "Request-URI Too Long";
        } else if (code == ErrorViewStatusCodes.CODE_415) {
            result = "Unsupported Media Type";
        } else if (code == ErrorViewStatusCodes.CODE_416) {
            result = "Requested Range Not Satisfiable";
        } else if (code == ErrorViewStatusCodes.CODE_417) {
            result = "Expectation Failed";
        } else if (code == ErrorViewStatusCodes.CODE_500) {
            result = "Internal Server Error";
        } else if (code == ErrorViewStatusCodes.CODE_501) {
            result = "Not Implemented";
        } else if (code == ErrorViewStatusCodes.CODE_502) {
            result = "Bad Gateway";
        } else if (code == ErrorViewStatusCodes.CODE_503) {
            result = "Service Unavailable";
        } else if (code == ErrorViewStatusCodes.CODE_504) {
            result = "Gateway Timeout";
        } else if (code == ErrorViewStatusCodes.CODE_505) {
            result = "HTTP Version Not Supported";
        }
        return result;
    }
}