package com.vrs.android.fyreon.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

/**
 * Package Name : com.vrs.android.fyreon.widgets
 * Created by vrsuser on 8/5/15.
 * Time : 10:35 AM
 * Project : FyreonTest
 * Modified : 08 10 35
 */
public class CustomView extends RelativeLayout {

    final static String MATERIALDESIGNXML = "http://schemas.android.com/apk/res-auto";
    final static String ANDROIDXML = "http://schemas.android.com/apk/res/android";
    final int disabledBackgroundColor = Color.parseColor("#E2E2E2");
    // Indicate if user touched this view the last time
    public boolean isLastTouch = false;
    int beforeBackground;
    boolean animation = false;

    public CustomView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled)
            setBackgroundColor(beforeBackground);
        else
            setBackgroundColor(disabledBackgroundColor);
        invalidate();
    }

    @Override
    protected void onAnimationStart() {
        super.onAnimationStart();
        animation = true;
    }

    @Override
    protected void onAnimationEnd() {
        super.onAnimationEnd();
        animation = false;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (animation)
            invalidate();
    }
}
