package com.vrs.android.fyreon.adapters;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.adapters
 * Created by vrsuser on 15/4/15.
 * Time : 12:34 PM
 * Project : fyreon-library-android
 * Modified : 15 12 34
 */
public class CommentListAdapter extends PagingBaseAdapter<CommentListModel> {

    static final String LOG_TAG = CommentListAdapter.class.getSimpleName();
    private static final Logger logger = new Logger(AppConstants.isDebug, LOG_TAG);
    List<CommentListModel> dataList = new ArrayList<>();
    Context mContext;
    LayoutInflater mInflater = null;
    SharedPreferences mSharedPref;
    DisplayImageOptions displayOptions;

    public CommentListAdapter(Context context, int resource, List<CommentListModel> objects) {
        this.mContext = context;
        this.dataList = objects;
        mSharedPref = context.getSharedPreferences(AppConstants.PREF_NAME, Context.MODE_PRIVATE);
        displayOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon).showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
    }

    @Override
    public int getCount() {
        return items.size();
    }

    @Override
    public Object getItem(int position) {
        return items.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        ViewHolder holder = new ViewHolder();
        View layoutView = convertView;
        if (layoutView == null) {
            mInflater = (LayoutInflater) mContext
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            layoutView = mInflater.inflate(R.layout.list_item_activity_comment, null, false);
            holder.ivProfileIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_profile);
            holder.txtName = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_name);
            holder.txtDate = (TextView) layoutView
                    .findViewById(R.id.comment_list_item_txt_date);
            holder.txtComment = (TextView) layoutView
                    .findViewById(R.id.comment_list_item_txt_comment);
            holder.ivFavoriteItem = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_favorite);
            holder.llFavoriteLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_favorite);
            holder.llCommentLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_comment);
            holder.txtFavoriteCount = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_favorite_count);
            holder.txtCommentCount = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_comment_count);
            holder.ivSocialIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_social_icon);
            holder.txtAdminBadge = (TextView) layoutView.findViewById(R.id
                    .comment_list_item_txt_admin_badge);
            layoutView.setTag(holder);
        } else {
            holder = (ViewHolder) layoutView.getTag();
        }

        final CommentListModel commentDataList = items.get(position);
        holder.txtName.setText(commentDataList.getName());
        holder.llFavoriteLayout.setTag(holder);

        if (commentDataList.isAdmin()) {
            holder.txtAdminBadge.setVisibility(View.VISIBLE);
        } else {
            holder.txtAdminBadge.setVisibility(View.GONE);
        }


        if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
//            Picasso.with(mContext)
//                    .load("https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large")
//                    .placeholder(R.drawable.default_user_icon)
//                    .into(holder.ivProfileIcon);
            holder.ivSocialIcon.setImageResource(R.drawable.facebook);
            ImageLoader.getInstance().displayImage("https://graph.facebook.com/" +
                            commentDataList.getSocial_id() + "/picture?type=large", holder.ivProfileIcon,
                    displayOptions);

            logger.debug(LOG_TAG, "profile Image URL : " + "https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large");
        } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_TWITTER)) {
            holder.ivSocialIcon.setImageResource(R.drawable.twitter_social_ic);
            if (commentDataList.getIcons().equalsIgnoreCase("")) {
            } else {
                logger.debug("Picasso", "Image Path " + commentDataList.getIcons());

//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                        .ivProfileIcon, displayOptions);
                logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
            }
        } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_GPLUS)) {
            holder.ivSocialIcon.setImageResource(R.drawable.google_social_ic);
            if (commentDataList.getIcons().equalsIgnoreCase("")) {
            } else {
                logger.debug("Picasso", "Image Path " + commentDataList.getIcons());

//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                        .ivProfileIcon, displayOptions);
                logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
            }
        } else {
            holder.ivSocialIcon.setImageResource(R.drawable.ic_fyreon_icon);
            if (commentDataList.getIcons().equalsIgnoreCase("")) {
            } else {
                logger.debug("Picasso", "Image Path " + commentDataList.getIcons());

//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                        .ivProfileIcon, displayOptions);
                logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
            }
        }

        logger.debug(LOG_TAG, "Date :" + commentDataList.getTime());

        holder.txtDate.setText(AppConstants.getTimeTwitter(Long.parseLong(commentDataList.getTime())));

        // This will set Comments in listview
        holder.txtComment.setText(commentDataList.getComment());
        if (commentDataList.getLiked_by() != null) {
            holder.txtFavoriteCount.setText(String.valueOf(commentDataList.getLiked_by().size()));
        } else {
            holder.txtFavoriteCount.setText(commentDataList.getLikes_count());
        }
        if (commentDataList.getReplies() != null) {
            holder.txtCommentCount.setText(String.valueOf(commentDataList.getReplies()));
        } else {
            holder.txtCommentCount.setText("0");
        }


        if (commentDataList.getLiked_id() != null) {
            if (commentDataList.getLiked_id().equalsIgnoreCase(mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, ""))) {
                if (commentDataList.getLiked().equalsIgnoreCase("1")) {
                    holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                    holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                } else {
                    holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                    holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                }
            } else {
                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
            }
        }

        logger.debug(LOG_TAG, "Social id Size is less then < 0 " + position);
        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));

        if (commentDataList.getLiked_by() != null) {
            if (commentDataList.getLiked_by().size() > 0) {
                for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                    logger.debug(LOG_TAG, "Current Checking ID :" + commentDataList.getLiked_by().get(j));
                    logger.debug(LOG_TAG, "Pref Social ID :" + mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, ""));
                    if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                        logger.debug(LOG_TAG, "Social id Matched on " + position);
                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                    } else {
                        logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                    }
                }
            }
        }

        holder.llFavoriteLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isLogin()) {
                    int liked = 0;
                    ViewHolder holder = (ViewHolder) v.getTag();
                    if (v.getId() == holder.llFavoriteLayout.getId()) {
                        CommentListModel feedItem = dataList.get(position);
                        logger.debug(LOG_TAG, position + "");
                        logger.debug(LOG_TAG, feedItem.getComment() + "");

                        if (commentDataList.getLiked_by() != null) {
                            if (commentDataList.getLiked_by().size() > 0) {
                                for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                                    if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                                        logger.debug(LOG_TAG, "Social id Matched on " + position);
                                        liked = 0;
                                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                                    } else {
                                        liked = 1;
                                        logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                                    }
                                }
                            } else {
                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                                liked = 1;
                            }
                        } else {
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                            liked = 1;
                        }
                        logger.debug(LOG_TAG, "Liked : " + liked);
                        postLike(mSharedPref.getString(
                                        AppConstants.PREF_PROFILE_ID, ""), feedItem.getComment_id(),
                                mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, ""), mSharedPref.getString(AppConstants.PREF_SOCIAL_TYPE, ""), liked, position, v);
                    }
                } else {
                    Toast.makeText(mContext, "You need to be logged in order to favorite the comment!", Toast.LENGTH_LONG).show();
                }
            }
        });

        return layoutView;
    }

    private void postLike(String profileId, String CommentID, final String SocialID, String
            Social_Type, final int like, final int position, View holderView) {

        final CommentListModel model = items.get(position);
        final ViewHolder holder = (ViewHolder) holderView.getTag();
        if (like == 1) {
            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
        } else {
            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
        }
        final JsonObject commentRequestObject = new JsonObject();
        commentRequestObject.addProperty("comment_id", CommentID);
        commentRequestObject.addProperty("social_id", SocialID);
        commentRequestObject.addProperty("social_type", Social_Type);
        commentRequestObject.addProperty("like", like);
        commentRequestObject.addProperty("profile_id", profileId);
        logger.debug(LOG_TAG, "Json Request Body : " + commentRequestObject.toString());

        OkHttpClientUtil.getInstance().initialize(mContext);
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_COMMENT_LIKE, commentRequestObject
                    .toString(), new Callback() {
                Handler mainHandler = new Handler(mContext.getMainLooper());

                @Override
                public void onFailure(Request request, IOException e) {
                    logger.error(LOG_TAG, "Failed to like Comment!");
                    mainHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(mContext, mContext.getString(R.string
                                    .network_error), Toast.LENGTH_LONG).show();
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                        }
                    });

                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                        response.cacheResponse();

                        final String resBody = response.body().string();
                        mainHandler.post(new Runnable() {
                            @Override
                            public void run() {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(resBody);
                                JsonObject result = commentsElement.getAsJsonObject();
                                model.setLiked_id(result.get("comment_id").getAsString());
                                model.setLiked(result.get("like").getAsString());
                                holder.txtFavoriteCount.setText(String.valueOf(result.get("like_count").getAsInt()));

                                if (like == 1) {
                                    ArrayList<String> comment = model.getLiked_by();
                                    comment.add(SocialID);
                                    model.setLiked_by(comment);
                                } else {
                                    ArrayList<String> comment = model.getLiked_by();
                                    comment.remove(SocialID);
                                    model.setLiked_by(comment);
                                }
                            }
                        });
                    } else {
                        logger.error(LOG_TAG, "Unidentified Response Code " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : isLogin
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @return boolean isLoggedIn
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private boolean isLogin() {
        return mSharedPref.getBoolean(AppConstants.PREF_IS_LOGIN, false);
    }

    private class ViewHolder {
        public TextView txtName, txtDate, txtComment, txtFavoriteCount, txtCommentCount,
                txtAdminBadge;
        public ImageView ivProfileIcon, ivFavoriteItem, ivSocialIcon;
        public LinearLayout llFavoriteLayout, llCommentLayout;
    }
}
