/**---------------------------------------------------------------------------------
 File Name : AnnimationUtils.java
 Version Information : Version 1.1
 Date of Creation : 25/2/15
 Copyright Notice : This class is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/
package com.vrs.android.fyreon.animations;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.LinearLayout;

import com.vrs.android.fyreon.events.EventsBridge;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : AnimationUtils
 * Description : Define various animations which used in applications.
 * Date of Creation : 25/2/15
 * Author : VRS
 * -------------------------------------------------------------------------------------
 * Update Log:
 * Date:		By:		    Details:
 * 25/2/15    Rajan       Create full class
 * 24/3/15    Bhadresh    Refactor code as per coding standard.
 * 07/04/15    Bhadresh    add expand and collapse method of animation.
 * -----------------------------------------------------------------------------------
 */

public class AnimationUtils {

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : animateAlphaViews
     * Description :
     * Date of Creation : 25/02/15
     *
     * @param Duration     :
     * @param objectAppear :
     * @param objectGone   :
     *                     -------------------------------------------------------------------------------------
     *                     Update Log:
     *                     Date:		By:		Details:
     *                     <p/>
     *                     25/2/15    Rajan       Create full class
     *                     24/3/15    Bhadresh    Refactor code as per coding standard.
     *                     -----------------------------------------------------------------------------------
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    static public void animateAlphaViews(final View objectGone,
                                         final View objectAppear, int Duration) {
        final ObjectAnimator fadeOut = ObjectAnimator.ofFloat(objectGone,
                "alpha", 1f, 0f);
        fadeOut.setDuration(Duration);
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat(objectAppear, "alpha",
                0f, 1f);
        fadeIn.setDuration(Duration);

        final AnimatorSet mAnimationSet = new AnimatorSet();

        mAnimationSet.play(fadeIn).after(fadeOut);

        mAnimationSet.addListener(new AnimatorListenerAdapter() {

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                objectGone.setVisibility(View.GONE);
                objectAppear.setVisibility(View.VISIBLE);

            }
        });
        mAnimationSet.start();
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : animateAlphaViews
     * Description :
     * Date of Creation : 25/02/15
     *
     * @param viewToAnimate :
     * @param scaleType     :
     * @param Duration      :
     * @param scale         :
     * @param listener      :
     *                      -------------------------------------------------------------------------------------
     *                      Update Log:
     *                      Date:		By:		Details:
     *                      <p/>
     *                      25/2/15    Rajan       Create full class
     *                      24/3/15    Bhadresh    Refactor code as per coding standard.
     *                      -----------------------------------------------------------------------------------
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    static public void animateScaleViews(final View viewToAnimate,
                                         String scaleType, int Duration, float scale,
                                         final EventsBridge.onAnimationComplete listener) {
        ObjectAnimator scaleXAnimator;
        ObjectAnimator scaleYAnimator;

        if (scaleType.equals("x")) {
            scaleXAnimator = ObjectAnimator.ofFloat(viewToAnimate, "scaleX",
                    scale);
            scaleXAnimator.setRepeatMode(ValueAnimator.REVERSE);
            scaleXAnimator.setRepeatCount(1);
            scaleXAnimator.setDuration(Duration);
            scaleXAnimator.start();
            scaleXAnimator.addListener(new Animator.AnimatorListener() {

                @Override
                public void onAnimationStart(Animator arg0) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onAnimationRepeat(Animator arg0) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onAnimationEnd(Animator arg0) {
                    // TODO Auto-generated method stub
                    listener.onAnimationCompleteListener();
                }

                @Override
                public void onAnimationCancel(Animator arg0) {
                    // TODO Auto-generated method stub

                }
            });
        } else if (scaleType.equals("y")) {

            scaleYAnimator = ObjectAnimator.ofFloat(viewToAnimate, "scaleY",
                    scale);
            scaleYAnimator.setRepeatMode(ValueAnimator.REVERSE);
            scaleYAnimator.setRepeatCount(1);
            scaleYAnimator.setDuration(Duration);
            scaleYAnimator.start();
            scaleYAnimator.addListener(new Animator.AnimatorListener() {

                @Override
                public void onAnimationStart(Animator arg0) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onAnimationRepeat(Animator arg0) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onAnimationEnd(Animator arg0) {
                    // TODO Auto-generated method stub
                    listener.onAnimationCompleteListener();
                }

                @Override
                public void onAnimationCancel(Animator arg0) {
                    // TODO Auto-generated method stub

                }
            });
        } else {
            scaleXAnimator = ObjectAnimator.ofFloat(viewToAnimate, "scaleX",
                    scale);
            scaleXAnimator.setRepeatMode(ValueAnimator.REVERSE);
            scaleXAnimator.setRepeatCount(1);
            scaleXAnimator.setDuration(Duration);
            scaleXAnimator.start();

            scaleYAnimator = ObjectAnimator.ofFloat(viewToAnimate, "scaleY",
                    scale);
            scaleYAnimator.setRepeatMode(ValueAnimator.REVERSE);
            scaleYAnimator.setRepeatCount(1);
            scaleYAnimator.setDuration(Duration);
            scaleYAnimator.start();

            scaleYAnimator.addListener(new Animator.AnimatorListener() {

                @Override
                public void onAnimationStart(Animator arg0) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onAnimationRepeat(Animator arg0) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onAnimationEnd(Animator arg0) {
                    // TODO Auto-generated method stub
                    listener.onAnimationCompleteListener();
                }

                @Override
                public void onAnimationCancel(Animator arg0) {
                    // TODO Auto-generated method stub

                }
            });
        }

    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : expand
     * Description :Expand view with animation
     * Date of Creation : 07-04-15
     *
     * @param v :  view
     *          -------------------------------------------------------------------------------------
     *          Update Log:
     *          Date:		By:		Details:
     *          24/3/15    Bhadresh    Create method
     *          -----------------------------------------------------------------------------------
     */
    public static void expand(final View v) {
        v.measure(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        final int targetHeight = v.getMeasuredHeight();

        v.getLayoutParams().height = 0;
        v.setVisibility(View.VISIBLE);
        Animation a = new Animation() {
            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                v.getLayoutParams().height = interpolatedTime == 1 ? LinearLayout.LayoutParams.WRAP_CONTENT : (int) (targetHeight * interpolatedTime);
                v.requestLayout();
            }

            @Override
            public boolean willChangeBounds() {
                return true;
            }
        };

        // 1dp/ms
        a.setDuration(500);//((int)(targetHeight / v.getContext().getResources().getDisplayMetrics().density));
        v.startAnimation(a);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : collapse
     * Description :collapse view with animation
     * Date of Creation : 07-04-15
     *
     * @param v :  view
     *          -------------------------------------------------------------------------------------
     *          Update Log:
     *          Date:		By:		Details:
     *          24/3/15    Bhadresh    Create method
     *          -----------------------------------------------------------------------------------
     */
    public static void collapse(final View v) {
        final int initialHeight = v.getMeasuredHeight();

        Animation a = new Animation() {
            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                if (interpolatedTime == 1) {
                    v.setVisibility(View.GONE);
                } else {
                    v.getLayoutParams().height = initialHeight - (int) (initialHeight * interpolatedTime);
                    v.requestLayout();
                }
            }

            @Override
            public boolean willChangeBounds() {
                return true;
            }
        };

        // 1dp/ms
        a.setDuration(500);//((int)(initialHeight / v.getContext().getResources().getDisplayMetrics().density));
        v.startAnimation(a);
    }
}
