/**
 * ---------------------------------------------------------------------------------
 * File Name : FyreonWidget.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */
package com.vrs.android.fyreon;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.CookieSyncManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nostra13.universalimageloader.cache.disc.naming.Md5FileNameGenerator;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.core.download.BaseImageDownloader;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.utils.StorageUtils;
import com.squareup.okhttp.Callback;
import com.vrs.android.fyreon.animations.SupportAnimator;
import com.vrs.android.fyreon.animations.ViewAnimationUtils;
import com.vrs.android.fyreon.database.DatabaseResult;
import com.vrs.android.fyreon.fragments.CommentFragment;
import com.vrs.android.fyreon.fragments.NotificationFragment;
import com.vrs.android.fyreon.handlers.ExceptionHandler;
import com.vrs.android.fyreon.interfaces.RetryListener;
import com.vrs.android.fyreon.model.ResultModel;
import com.vrs.android.fyreon.ui.SocialLoginActivity;
import com.vrs.android.fyreon.ui.UserProfileActivity;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;
import com.vrs.android.fyreon.widgets.BadgeView;
import com.vrs.android.fyreon.widgets.CircularImageView;
import com.vrs.android.fyreon.widgets.ErrorView;
import com.vrs.android.fyreon.widgets.ProgressBarCircularIndeterminate;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.conf.ConfigurationBuilder;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : FyreonWidget
 * Description : This is main class custom widget file for FyreON Library.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         30/3/15    Bhadresh    Implement animation for warningview and up-down button
 *         30/3/15    Bhadresh    Implement LoginInterface [SocialLoginActivity].
 *         1/4/15     Bhadresh    Refresh top strip after login.
 *         2/4/15     Bhadresh    Implemnt Logout and user profile functionality.
 *         07/04/15   Bhadresh    Fix animation issue when layout gravity at top of the screeen
 *         -----------------------------------------------------------------------------------
 */
public class FyreonWidget extends LinearLayout implements View.OnClickListener, SocialLoginActivity.LoginInterface, UserProfileActivity.LogoutInterface {

    // exist
    // Constant Variables
    private static final String LOG_TAG = FyreonWidget.class.getSimpleName();
    private static final Logger logger = new Logger(AppConstants.isDebug, LOG_TAG);
    private static String mWidgetCategory = "";
    //Facebook
    private static SharedPreferences mSharedPreferences;
    private static Context mContext;
    private static Activity mActivity;
    private DisplayImageOptions displayImageOptions;
    private int ANIMATION_COUNTER = 0;
    // Global member declaration
    private int mBackGroundColor;
    private int mFontColor;
    private boolean mColor;
    private boolean isAnimationUp = true;
    // View Declaration
    private CircularImageView btnUp;
    private LinearLayout llPermissionWarning;
    private LinearLayout llTopStrip;
    private TextView txtWarningText;
    private LinearLayout llFrameLayout;
    private LinearLayout llBackGround;
    //   private VRSRobotoTextView txtParticipants;
//    private VRSRobotoTextView txtLikes;
//    private VRSRobotoTextView txtComments;
    private TextView txtUserProfileName;
    private CircularImageView imgUserProfileImage;
    private RelativeLayout llUserProfileStrip;
    private LinearLayout llCountTopStrip;
    //    private ImageButton llTopStripLogo;
    private DatabaseResult mDatabaseCipherTable;
    private Animation animUpDownButton;
    private Animation animShowView;
    private Animation animHideView;
    private ImageButton btnLogout;
    private ProgressBarCircularIndeterminate progressBarCircularIndeterminate;
    private LinearLayout llErrorLayout;
    private ErrorView mErrorView;
    private TextView txtHintText;
    private TextView txtTopHint;
    private ImageView imgNotification;
    // private LinearLayout llRevealLayout;
    private String strRes = null;
    private int resCode;
    private BadgeView badge;

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : FyreonWidget
     * Description : Constructor initialize instance with context.
     * Date of Creation : 25/02/15
     *
     * @param context -----------------------------------------------------------------------------------
     *                Update Log:
     *                Date:		By:		Details:
     *                <p/>
     *                25/2/15    Rajan       Create full class
     *                24/3/15    Bhadresh    Refactor code as per coding standard.
     *                -----------------------------------------------------------------------------------
     */
    public FyreonWidget(Context context) {
        super(context);

    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : FyreonWidget
     * Description : Constructor initialize instance with context and flag.
     * Date of Creation : 25/02/15
     *
     * @param activity ----------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Create full class
     *                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                 -----------------------------------------------------------------------------------
     */
    public FyreonWidget(Activity activity, String category) {
        super(activity.getApplicationContext());
        logger.debug(LOG_TAG, "" + activity.getLocalClassName());
        mActivity = activity;
        mContext = activity.getApplicationContext();
        mWidgetCategory = category;
        logger.debug(LOG_TAG, "Category : " + mWidgetCategory);
        displayImageOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon)
                .showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
        initializeImageLoader(activity.getApplicationContext());
        FacebookSdk.sdkInitialize(activity.getApplicationContext());
    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : FyreonWidget
     * Description : Constructor initialize instance with context and custom attributes.
     * Date of Creation : 25/02/15
     *
     * @param context
     * @param attrs   -----------------------------------------------------------------------------------
     *                Update Log:
     *                Date:		By:		Details:
     *                <p/>
     *                25/2/15    Rajan       Create full class
     *                24/3/15    Bhadresh    Refactor code as per coding standard.
     *                -----------------------------------------------------------------------------------
     */
    public FyreonWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        /**
         * Important: Must call this function before calling any SQLCipher functions
         */
        init(attrs, 0);
    }

    private void initializeImageLoader(Context mCtx) {
        File cacheDir = StorageUtils.getCacheDirectory(mCtx);
        ImageLoaderConfiguration.Builder configuration = new ImageLoaderConfiguration.Builder(mCtx);
        configuration.threadPriority(Thread.NORM_PRIORITY - 2);
        configuration.denyCacheImageMultipleSizesInMemory();
//        configuration.diskCache(new UnlimitedDiscCache(cacheDir));
        configuration.imageDownloader(new BaseImageDownloader(mCtx));
        configuration.diskCacheFileNameGenerator(new Md5FileNameGenerator());
        configuration.diskCacheSize(200 * 1024 * 1024); // 50 MiB
        configuration.tasksProcessingOrder(QueueProcessingType.LIFO);
        ImageLoader.getInstance().init(configuration.build());
    }


    @Override
    public void onClick(View view) {
        if (view == btnUp) {
            if (isAnimationUp) {
                if (ANIMATION_COUNTER == 0) {
                    Animation bottomUp;
                    if (isAnimationUp) {
                        bottomUp = AnimationUtils.loadAnimation(getContext(),
                                R.anim.bottom_up);

                    } else {
                        bottomUp = AnimationUtils.loadAnimation(getContext(),
                                R.anim.bottom_down);

                    }
                    llBackGround.startAnimation(bottomUp);
                    bottomUp.setAnimationListener(new Animation.AnimationListener() {
                        @Override
                        public void onAnimationStart(Animation animation) {
                            llTopStrip.setBackgroundColor(getResources().getColor(R.color.profile_theme_color));
//                            txtLikes.setTextColor(getResources().getColor(R.color.icons));
//                            txtComments.setTextColor(getResources().getColor(R.color.icons));
                        }

                        @Override
                        public void onAnimationEnd(Animation animation) {

                        }

                        @Override
                        public void onAnimationRepeat(Animation animation) {

                        }
                    });
                    llFrameLayout.setVisibility(View.VISIBLE);
                    if (isAnimationUp) {
                        btnUp.setTag("GO DOWN");
                        btnUp.startAnimation(animUpDownButton);
                        //btnUp.setImageDrawable(getResources().getDrawable(R.drawable.down));
                    } else {
                        btnUp.setTag("GO UP");
                        btnUp.startAnimation(animUpDownButton);
                        //btnUp.setImageDrawable(getResources().getDrawable(R.drawable.up));
                    }
                    ANIMATION_COUNTER++;

                } else {
                    Animation bottomDown = null;

                    if (isAnimationUp) {
                        bottomDown = AnimationUtils.loadAnimation(getContext(),
                                R.anim.bottom_down);
                    } else {
                        bottomDown = AnimationUtils.loadAnimation(getContext(),
                                R.anim.bottom_up);
                    }
                    llBackGround.startAnimation(bottomDown);
                    bottomDown.setAnimationListener(new Animation.AnimationListener() {
                        @Override
                        public void onAnimationStart(Animation animation) {
                            // Called when the Animation starts

                        }

                        @Override
                        public void onAnimationEnd(Animation animation) {
                            // Called when the Animation ended
                            // Since we are fading a View out we set the visibility
                            // to GONE once the Animation is finished
                            llFrameLayout.setVisibility(View.GONE);
                            llTopStrip.setBackgroundColor(getResources().getColor(R.color.icons));
//                            txtLikes.setTextColor(getResources().getColor(R.color.primary_text));
//                            txtComments.setTextColor(getResources().getColor(R.color.primary_text));
                        }

                        @Override
                        public void onAnimationRepeat(Animation animation) {
                            // This is called each time the Animation repeats
                        }
                    });
                    if (isAnimationUp) {
                        btnUp.setTag("GO UP");
                        btnUp.startAnimation(animUpDownButton);
                        //btnUp.setImageDrawable(getResources().getDrawable(R.drawable.up));
                    } else {
                        btnUp.setTag("GO DOWN");
                        btnUp.startAnimation(animUpDownButton);
                        //btnUp.setImageDrawable(getResources().getDrawable(R.drawable.down));

                    }
                    ANIMATION_COUNTER--;
                }
            } else {


                if (ANIMATION_COUNTER == 0) {
                    btnUp.setTag("GO UP");
                    com.vrs.android.fyreon.animations.AnimationUtils.expand(llFrameLayout);
                    btnUp.startAnimation(animUpDownButton);
                    ANIMATION_COUNTER++;

                } else {
                    btnUp.setTag("GO DOWN");
                    com.vrs.android.fyreon.animations.AnimationUtils.collapse(llFrameLayout);
                    btnUp.startAnimation(animUpDownButton);
                    ANIMATION_COUNTER--;
                }
            }
        }


    }

    @Override
    public void onLoginSuccess(String id, String name, String imageUrl) {
        logger.debug(LOG_TAG, "On Login Success");
        SharedPreferences s = mActivity.getSharedPreferences(AppConstants.PREF_NAME, 0);
        logger.debug(LOG_TAG, "Login Status : " + s.getBoolean(AppConstants.PREF_IS_LOGIN, false));
        logger.debug(LOG_TAG, "Social Type : " + s.getString(AppConstants.PREF_SOCIAL_TYPE, ""));
        logger.debug(LOG_TAG, "Social ID : " + s.getString(AppConstants.PREF_SOCIAL_ID, ""));
        RelativeLayout llUPS = (RelativeLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_user_profile_strip);
        LinearLayout llCTS = (LinearLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_count_strip);
        TextView txtUserName = (TextView) mActivity.findViewById(R.id.layout_fyreon_widget_up_txt_user_profile_name);
        CircularImageView imgUserImage = (CircularImageView) mActivity.findViewById(R.id.layout_fyreon_widget_up_btn_user_profile_image);
        logger.debug(LOG_TAG, "USER ID : " + id);
        logger.debug(LOG_TAG, "USER NAME : " + name);
        logger.debug(LOG_TAG, "USER IMAGE URL  : " + imageUrl);
        if (mSharedPreferences.getBoolean(AppConstants.PREF_IS_LOGIN, false)) {
            llCTS.setVisibility(View.GONE);
            llUPS.setVisibility(View.VISIBLE);
            if (s.getString(AppConstants.PREF_SOCIAL_TYPE, "").equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                txtUserName.setText(name);
//                Session session = Session.getActiveSession();
//                if (session != null) {
//
//                } else {
//                    session = Session.openActiveSessionFromCache(mContext);
//                }
                ImageLoader.getInstance().displayImage(imageUrl, imgUserImage, displayImageOptions);
            } else if (s.getString(AppConstants.PREF_SOCIAL_TYPE, "").equals(AppConstants.SOCIAL_TYPES_GPLUS)) {

                txtUserName.setText(name);
                ImageLoader.getInstance().displayImage(imageUrl, imgUserImage, displayImageOptions);

            } else {
                txtUserName.setText(name);
                ImageLoader.getInstance().displayImage(imageUrl, imgUserImage, displayImageOptions);
            }

        } else {
            llCTS.setVisibility(View.VISIBLE);
            llUPS.setVisibility(View.GONE);
        }
    }

    @Override
    public void onLoginFailure() {
        logger.debug(LOG_TAG, "On Login Failure");
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : init
     * Description : This is init method that will be called when activity with widget appears on screen.
     * Date of Creation : 25/02/15
     *
     * @param attrs
     * @param defStyle -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Create full class
     *                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                 -----------------------------------------------------------------------------------
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void init(AttributeSet attrs, int defStyle) {


        // Enable global Ion logging
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(
                getContext()));
        AppConstants.isCreateDatabase = true;
        AppConstants.setData(getContext(), true, this.getContext().getPackageName());

        // Will add more Attributes
        mSharedPreferences = mContext.getSharedPreferences(AppConstants.PREF_NAME, 0);
        TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.TestStyle, 0, 0);
        final int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.TestStyle_backgroundColor) {
                logger.info(LOG_TAG, a.getColor(attr, 0) + "");
                mBackGroundColor = a.getColor(attr, 0);
                if (mBackGroundColor != 0) {
                    setBackgroundColor(mBackGroundColor);
                }
            } else if (attr == R.styleable.TestStyle_font_color) {
                logger.info(LOG_TAG, a.getColor(attr, 0) + "");
                mFontColor = a.getColor(attr, 0);
                if (mFontColor != 0) {
                    mColor = true;
                }
            } else if (attr == R.styleable.TestStyle_animation) {
                logger.debug(LOG_TAG, a.getString(attr));
                if (a.getString(attr).trim().equalsIgnoreCase("up")) {
                    isAnimationUp = true;
                } else isAnimationUp = !a.getString(attr).trim().equalsIgnoreCase("down");
            }
        }

        a.recycle();
        setOrientation(LinearLayout.VERTICAL);
        setGravity(Gravity.NO_GRAVITY);

        LayoutInflater mInflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        if (isAnimationUp) {
            mInflater.inflate(R.layout.layout_fyreon_widget_up, this, true);
        } else {
            mInflater.inflate(R.layout.layout_fyreon_widget_down, this, true);
        }

        /***
         * Render UI Widgets
         */
        progressBarCircularIndeterminate = (ProgressBarCircularIndeterminate) this.findViewById(R
                .id.progressBarCircularIndeterminate);
        llFrameLayout = (LinearLayout) this.findViewById(R.id.fragment_comment_ll_bottom);
        btnUp = (CircularImageView) this.findViewById(R.id.layout_fyreon_widget_down_btn_up);
        llBackGround = (LinearLayout) this.findViewById(R.id.mainLayout);

        llPermissionWarning = (LinearLayout) this.findViewById(R.id.layout_fyreon_widget_down_ll_permission_warning);
        llTopStrip = (LinearLayout) this.findViewById(R.id.layout_fyreon_widget_up_ll_top_strip);
        llUserProfileStrip = (RelativeLayout) this.findViewById(R.id.layout_fyreon_widget_up_ll_user_profile_strip);
        llCountTopStrip = (LinearLayout) this.findViewById(R.id.layout_fyreon_widget_up_ll_count_strip);
        txtWarningText = (TextView) this.findViewById(R.id.layout_fyreon_widget_down_txt_warning);
        txtUserProfileName = (TextView) this.findViewById(R.id.layout_fyreon_widget_up_txt_user_profile_name);
        imgUserProfileImage = (CircularImageView) this.findViewById(R.id.layout_fyreon_widget_up_btn_user_profile_image);
        mErrorView = (ErrorView) this.findViewById(R.id.error_view);
        llErrorLayout = (LinearLayout) this.findViewById(R.id.ll_main_error_layout);
        txtTopHint = (TextView) this.findViewById(R.id.hint_top_title);
        imgUserProfileImage.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intProfile = new Intent(mActivity, UserProfileActivity.class);
                mActivity.startActivity(intProfile);
            }
        });
        animShowView = AnimationUtils.loadAnimation(mContext, R.anim.left_to_right);
        animHideView = AnimationUtils.loadAnimation(mContext, R.anim.right_to_left);
        animUpDownButton = AnimationUtils.loadAnimation(mContext, R.anim.button_animation);
        btnLogout = (ImageButton) findViewById(R.id.layout_fyreon_widget_down_btn_logout);
        imgNotification = (ImageView) findViewById(R.id.notification_normal_view);

        imgNotification.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (badge != null)
                    badge.hide();
                Bundle bundle = new Bundle();
                bundle.putString(AppConstants.BUNDLE_NOTIFICATION_KEY, strRes);
                bundle.putInt(AppConstants.BUNDLE_NOTIFICATION_CODE, resCode);
                FragmentManager manager = mActivity.getFragmentManager();
                FragmentTransaction ft = manager.beginTransaction();
                Fragment mFragment = new NotificationFragment();
                mFragment.setArguments(bundle);
                ft.setCustomAnimations(R.anim.fade_in_fragment,
                        R.anim.fade_out_fragment);
                ft.replace(R.id.layout_fyreon_widget_down_container, mFragment);
                ft.commit();
                llFrameLayout.setVisibility(View.VISIBLE);
                ANIMATION_COUNTER++;
            }
        });

        btnLogout.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                logout();
            }
        });
        Integer colorFrom = getResources().getColor(R.color.icons);
        Integer colorTo = getResources().getColor(R.color.profile_theme_color);
        final ValueAnimator colorAnimation = ValueAnimator.ofObject(new ArgbEvaluator(), colorFrom, colorTo);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {

            @Override
            public void onAnimationUpdate(ValueAnimator animator) {
                llTopStrip.setBackgroundColor((Integer) animator.getAnimatedValue());
            }

        });

//        if (mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "").equals("facebook")) {
//            getFacebookUserID();
//        }
        animUpDownButton.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
                colorAnimation.start();
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                if (btnUp.getTag().equals("GO DOWN")) {
                    btnUp.setImageDrawable(getResources().getDrawable(R.drawable.fyreon_inverse));
                    txtTopHint.setTextColor(getResources().getColor(R.color.icons));
                    imgNotification.setImageDrawable(getResources().getDrawable(R.drawable.ic_title_notifications_default));
                    txtUserProfileName.setTextColor(getResources().getColor(R.color.icons));
                } else {
                    btnUp.setImageDrawable(getResources().getDrawable(R.drawable.fyreon_normal));
                    txtTopHint.setTextColor(getResources().getColor(R.color.secondary_text));
                    txtUserProfileName.setTextColor(getResources().getColor(R.color.primary_text));
                    imgNotification.setImageDrawable(getResources().getDrawable(R.drawable.ic_title_notifications_profile));
                }

            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

        llCountTopStrip.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent myIntent = new Intent(getContext(), SocialLoginActivity.class);
                getContext().startActivity(myIntent);
            }
        });


        // Add code to print out the key hash
        try {
            PackageInfo info = getContext().getPackageManager().getPackageInfo(getContext().getPackageName(), PackageManager.GET_SIGNATURES);
            for (Signature signature : info.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                AppConstants.APP_KEY = Base64.encodeToString(md.digest(), Base64.DEFAULT);
                logger.error(LOG_TAG, "MY KEY HASH:" + Base64.encodeToString(md.digest(), Base64.DEFAULT));
            }
        } catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException ignored) {

        } finally {
            mDatabaseCipherTable = new DatabaseResult(getContext());
            mDatabaseCipherTable.open();
            mDatabaseCipherTable.close();
        }
        btnUp.setOnClickListener(this);

        llBackGround.getChildAt(1);

        checkAppConfig();
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : setBackgroundColor
     * Description : To set background Color of view
     * Date of Creation : 25/02/15
     *
     * @param color --------------------------------------------------------------------
     *              Update Log:
     *              Date:		By:		Details:
     *              <p/>
     *              25/2/15    Rajan       Create full class
     *              24/3/15    Bhadresh    Refactor code as per coding standard.
     *              -----------------------------------------------------------------------------------
     */
    public void setBackGroundColor(int color) {
        llBackGround.setBackgroundColor(color);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : checkAppConfig
     * Description : This method will check for permissions given in manifest and if manifest
     * is declared then it will render the widget. after checking for widget
     * permissions it will fetch new app key that will be based on our given app key.
     * That also needs to be declared in manifest of <meta-data></meta-data> tags.
     * Date of Creation : 25/02/15
     *
     * @throws <no-internet-permissions></no-internet-permissions>
     * @throws org.json.JSONObject
     * @throws NullPointerException
     * @throws android.content.pm.PackageManager.NameNotFoundException -------------------------------------------------------------------------------------
     *                                                                 Update Log:
     *                                                                 Date:		By:		Details:
     *                                                                 <p/>
     *                                                                 25/2/15    Rajan       Create full class
     *                                                                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                                                                 -----------------------------------------------------------------------------------
     */
    public void checkAppConfig() {

        String[] PERMISSION_LIST = new String[]{Manifest.permission.INTERNET, Manifest.permission.ACCESS_NETWORK_STATE, Manifest.permission.GET_ACCOUNTS, Manifest.permission.USE_CREDENTIALS};//, //Manifest.permission.WRITE_APN_SETTINGS, Manifest.permission.ACCESS_MOCK_LOCATION, Manifest.permission.SUBSCRIBED_FEEDS_WRITE};
        String UPL = "";
        ArrayList<String> UNDECLARED_PERMISSION_LIST = new ArrayList<>();
        for (String listItem : PERMISSION_LIST) {
            int result = mContext.checkCallingOrSelfPermission(listItem);
            logger.debug(LOG_TAG, "Name : " + listItem);
            if (result == PackageManager.PERMISSION_GRANTED) {
                logger.debug(LOG_TAG, "Permission Result : " + result + " True");
            } else {
                UNDECLARED_PERMISSION_LIST.add(listItem);
                logger.debug(LOG_TAG, "Permission Result : " + result + " False");
            }
        }
        for (String listItem : UNDECLARED_PERMISSION_LIST) {
            logger.debug(LOG_TAG, "Name : " + listItem);
            UPL += listItem + " ";
        }
        if (UNDECLARED_PERMISSION_LIST.size() > 0) {
            llPermissionWarning.setVisibility(View.VISIBLE);
            llPermissionWarning.startAnimation(animShowView);
            llTopStrip.startAnimation(animHideView);
            llTopStrip.setVisibility(View.GONE);
            //  btnUp.setVisibility(View.GONE);

            txtWarningText.setText("Before using this widget please define all required permissions  in your Manifest.");
        } else {
            enterRevealFab(btnUp);
            try {
                ApplicationInfo ai = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                String myApiKey = bundle.getString("com.vrs.android.fyreon.FyreonWidget.API_KEY");
                logger.error("TAG", "Key : " + myApiKey);
                if (myApiKey != null) {
                    String screenKey = null;
                    ResultModel resultModel = new ResultModel();
                    mDatabaseCipherTable.open();
                    List<ResultModel> mResult = mDatabaseCipherTable.getResults(resultModel
                            .mAppKey, new String[]{mContext.getClass().getSimpleName()}, null);
                    mDatabaseCipherTable.close();
                    if (mResult.size() > 0) {
                        screenKey = mResult.get(mResult.size() - 1).mScreenName;
                    }
                    if (screenKey == null || screenKey.equalsIgnoreCase("")) {
                        parseApiKey(myApiKey);
                    } else {
                        String screen_key = null;
                        if (mResult.size() > 0) {
                            screen_key = mResult.get(mResult.size() - 1).mAppKey;
                        }
                        getNotifications(screen_key);
                        logger.info(LOG_TAG, "We have id.");

                        Bundle bundle2 = new Bundle();
                        bundle2.putString(AppConstants.WIDGET_CATEGORY, mWidgetCategory);
                        Fragment commentFragment = new CommentFragment();
                        commentFragment.setArguments(bundle2);
                        mActivity.getFragmentManager().beginTransaction().add(R.id
                                .layout_fyreon_widget_down_container, commentFragment).commit();
                    }
                } else {
                    llPermissionWarning
                            .setVisibility(View.VISIBLE);
                    llPermissionWarning.startAnimation(animShowView);
                    llTopStrip.startAnimation(animHideView);
                    llTopStrip.setVisibility(View.GONE);
                    txtWarningText.setText("Define API_KEY metadata in your manifest");
                    logger.error("TAG", "Failed to load meta-data, NameNotFound: ");
                }
                if (mSharedPreferences.getBoolean(AppConstants.PREF_IS_LOGIN, false)) {
                    llCountTopStrip.setVisibility(View.GONE);
                    llUserProfileStrip.setVisibility(View.VISIBLE);

                    txtUserProfileName.setText(mSharedPreferences.getString(AppConstants.PREF_USER_NAME, ""));
                    ImageLoader.getInstance().displayImage(mSharedPreferences.getString(AppConstants
                            .PREF_USER_PROFILE_IMAGE, ""), imgUserProfileImage);
                    if (mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "").equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {
                            getFacebookUserInformation();
                        }
                    } else {
                        try {
                            getProfileDetail(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""), mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, ""));
                        } catch (UnsupportedEncodingException | TwitterException e) {
                            e.printStackTrace();
                        }
                    }

                } else {
                    llCountTopStrip.setVisibility(View.VISIBLE);
                    llUserProfileStrip.setVisibility(View.GONE);
                }

            } catch (PackageManager.NameNotFoundException e) {
                llPermissionWarning.setVisibility(View.VISIBLE);
                llPermissionWarning.startAnimation(animShowView);
                llTopStrip.startAnimation(animHideView);
                llTopStrip.setVisibility(View.GONE);
                txtWarningText.setText("Define API_KEY metadata in your manifest");
                logger.error("TAG", "Failed to load meta-data, NameNotFound: " + e.getMessage());
            } catch (NullPointerException e) {
                llPermissionWarning.setVisibility(View.VISIBLE);
                llPermissionWarning.startAnimation(animShowView);
                llTopStrip.startAnimation(animHideView);
                llTopStrip.setVisibility(View.GONE);
                txtWarningText.setText("Define API_KEY metadata in your manifest");
                logger.error("TAG", "Failed to load meta-data, NullPointer: " + e.getMessage());
            }
        }
    }

    private void getNotifications(String myApiKey) {
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("screen_key", myApiKey);
        OkHttpClientUtil.getInstance().initialize(mContext);

        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_ADMIN_NOTFICATION_COUNTER,
                    jsonParams.toString(), new
                            Callback() {
                                @Override
                                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                    logger.error(LOG_TAG, "Failed to Fetch Notifications " + e
                                            .getLocalizedMessage
                                                    ());
                                }

                                @Override
                                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                                    resCode = response.code();
                                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                                        response.cacheResponse();
                                        final String res = response.body().string();
                                        strRes = res;
                                        JsonParser parser = new JsonParser();
                                        JsonElement commentsElement = parser.parse(res);
                                        final JsonArray result = commentsElement.getAsJsonArray();

                                        mActivity.runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {

                                                if (result.size() > 0) {
                                                    if (mSharedPreferences.getInt(AppConstants
                                                            .PREF_NOTIFICATION_READ_KEY, -1) == -1) {
                                                        SharedPreferences.Editor editor =
                                                                mSharedPreferences.edit();
                                                        editor.putInt(AppConstants
                                                                .PREF_NOTIFICATION_READ_KEY, result
                                                                .size());
                                                        editor.apply();
                                                        if (result.size() > 0) {
                                                            int ans = result.size();
                                                            badge = new BadgeView(mActivity,
                                                                    imgNotification);
                                                            badge.setText(String.valueOf(ans));
                                                            badge.setTextSize(8);
                                                            badge.toggle();
                                                        }
                                                    } else {
                                                        int size = mSharedPreferences.getInt(AppConstants
                                                                .PREF_NOTIFICATION_READ_KEY, -1);
                                                        if (result.size() > size) {
                                                            int ans = result.size() - size;
                                                            badge = new BadgeView(mActivity,
                                                                    imgNotification);
                                                            badge.setText(String.valueOf(ans));
                                                            badge.setTextSize(8);
                                                            badge.toggle();
                                                        }
                                                    }
                                                }
                                            }
                                        });
                                    } else if (response.code() == AppConstants.STATUS_CODE_FAILURE_AUTH) {
                                    } else {

                                    }
                                }
                            }

            );
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * *
     * <p/>
     * This method will create Circular Reveal Animation for Passed view.
     *
     * @param view Takes a view that you would want to give a circular reveal animations.
     */
    void enterRevealFab(View view) {
        final View myView = view;

        myView.postDelayed(new Runnable() {

            @Override
            public void run() {
                // get the center for the clipping circle
                int cx = (myView.getLeft() + myView.getRight()) / 2;
                int cy = (myView.getTop() + myView.getBottom()) / 2;

                // get the final radius for the clipping circle
                int finalRadius = Math.max(myView.getWidth(), myView.getHeight());

                SupportAnimator animator =
                        ViewAnimationUtils.createCircularReveal(myView, cx, cy, 0, finalRadius);
                animator.addListener(new SupportAnimator.AnimatorListener() {
                    @Override
                    public void onAnimationStart() {
                        btnUp.setVisibility(View.VISIBLE);
                    }

                    @Override
                    public void onAnimationEnd() {
                    }

                    @Override
                    public void onAnimationCancel() {

                    }

                    @Override
                    public void onAnimationRepeat() {

                    }
                });
                animator.setInterpolator(new AccelerateDecelerateInterpolator());
                animator.setDuration(1500);
                animator.start();

            }
        }, 100);
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getFacebookUserInformation
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     * <p/>
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Bhadresh       Created full Method
     * <p/>
     * -----------------------------------------------------------------------------------
     */
    private void getFacebookUserInformation() {
        // **************************
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        if (accessToken != null) {
            GraphRequest request = GraphRequest.newMeRequest(accessToken,
                    new GraphRequest.GraphJSONObjectCallback() {
                        @Override
                        public void onCompleted(JSONObject object,
                                                GraphResponse response) {
                            Log.d(LOG_TAG, "Json Object : " + object.toString());

                            try {

                                String userName = object.getString("name");
                                JSONObject pictureObject = object
                                        .getJSONObject("picture");
                                JSONObject pictureDataObject = pictureObject
                                        .getJSONObject("data");
                                final String userProfilePic = pictureDataObject
                                        .getString("url");
                                updateUserProfile(userName, userProfilePic);
                                if (mActivity != null
                                        && mActivity.isFinishing() != true) {
                                    mActivity.runOnUiThread(new Runnable() {

                                        @Override
                                        public void run() {

                                            ImageLoader
                                                    .getInstance()
                                                    .displayImage(
                                                            userProfilePic,
                                                            imgUserProfileImage,
                                                            displayImageOptions,
                                                            new ImageLoadingListener() {

                                                                @Override
                                                                public void onLoadingStarted(
                                                                        String imageUri,
                                                                        View view) {

                                                                }

                                                                @Override
                                                                public void onLoadingFailed(
                                                                        String imageUri,
                                                                        View view,
                                                                        FailReason failReason) {

                                                                }

                                                                @Override
                                                                public void onLoadingComplete(
                                                                        String imageUri,
                                                                        View view,
                                                                        Bitmap loadedImage) {

                                                                }

                                                                @Override
                                                                public void onLoadingCancelled(
                                                                        String imageUri,
                                                                        View view) {

                                                                }
                                                            });
                                        }
                                    });
                                }
                                Log.d(LOG_TAG, "User Profile : " + userName
                                        + " : " + userProfilePic);
                            } catch (JSONException e) {
                                // TODO Auto-generated catch block
                                e.printStackTrace();
                            }

                        }
                    });
            Bundle parameters = new Bundle();
            parameters.putString("fields", "name,picture");
            request.setParameters(parameters);
            request.executeAsync();

        } else {
            Log.e(LOG_TAG, "Exception == > Facebook Token haas Expired");
        }

    }


    /**
     * ----------------------------------------------------------------------------------
     * Method Name : parseResponseFaceBook
     * Description : Parsing response that we get from GraphObject.
     * Date of Creation : 25/02/15
     *
     * @param response pass facebook graph api response.
     *                 <p/>
     *                 -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Bhadresh       Created full Method
     *                 <p/>
     *                 -----------------------------------------------------------------------------------
     */


//    private void parseResponseFaceBook(Response response, String facebookID) {
//
//        GraphObject graphObject = response.getGraphObject();
//        if (graphObject != null) {
//            String name = String.format("%s", graphObject.getProperty("name"));
//            logger.debug("Test", "Name : " + name);
//            txtUserProfileName.setText(name);
////            Picasso.with(mContext).load("https://graph.facebook.com/" + facebookID + "/picture?type=large").into(imgUserProfileImage);
//            ImageLoader.getInstance().displayImage("https://graph.facebook.com/" + facebookID +
//                    "/picture?type=large", imgUserProfileImage, displayImageOptions);
//            Session session = Session.getActiveSession();
//            if (session != null) {
//
//            } else {
//                session = Session.openActiveSessionFromCache(mContext);
//            }
//
//
//            updateUserProfile(name, "https://graph.facebook.com/" + facebookID +
//                    "/picture?type=large&method=GET&access_token=" + session.getAccessToken());
//        }
//    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : updateUserProfile
     * Description : Update user profile on server when user data has been changed in social.
     * Date of Creation : 15/04/15
     *
     * @param userName
     * @param userImage -------------------------------------------------------------------------------------
     *                  Update Log:
     *                  Date:		By:		Details:
     *                  15/04/15    Bhadresh       Created full Method
     *                  -----------------------------------------------------------------------------------
     */
    private void updateUserProfile(final String userName, final String userImage) {
        logger.debug(LOG_TAG,
                "Social ID :"
                        + mSharedPreferences.getString(
                        AppConstants.PREF_SOCIAL_ID, ""));
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("profile_id", mSharedPreferences.getString(AppConstants.PREF_PROFILE_ID, ""));
//        jsonParams.addProperty("social_id",
//                mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""));
//        jsonParams
//                .addProperty("social_type", mSharedPreferences.getString(
//                        AppConstants.PREF_SOCIAL_TYPE, ""));
//        jsonParams.addProperty("email", mSharedPreferences.getString(AppConstants.PREF_USER_EMAIL, ""));

        if (AppConstants.isNetworkAvailable(mActivity)) {
            OkHttpClientUtil.getInstance().initialize(mActivity);
            try {
                OkHttpClientUtil.doPostRequest(
                        AppConstants.URL_GET_USER_PROFILE,
                        jsonParams.toString(), new Callback() {

                            @Override
                            public void onResponse(
                                    com.squareup.okhttp.Response response)
                                    throws IOException {

                                if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                                    final String resBody = response.body()
                                            .string();
                                    JsonParser parser = new JsonParser();
                                    JsonElement profileElement = parser
                                            .parse(resBody);
                                    JsonObject profileObject = profileElement
                                            .getAsJsonObject();

                                    String userNameParams = profileObject.get(
                                            "user_name").getAsString();
                                    String userImageParams = profileObject.get(
                                            "user_image").getAsString();
                                    if (!(userName
                                            .equalsIgnoreCase(userNameParams))) {
                                        logger.debug(LOG_TAG, "Update : "
                                                + userImage + " : "
                                                + userImageParams);
                                        logger.debug(LOG_TAG, "Update : "
                                                + userName + " : "
                                                + userNameParams);
                                        // logger.debug(LOG_TAG,"Degrate : " +
                                        // userName + " : " +
                                        // mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE,""));
                                        JsonObject jsonParams = new JsonObject();
                                        jsonParams
                                                .addProperty(
                                                        "profile_id",
                                                        mSharedPreferences
                                                                .getString(
                                                                        AppConstants.PREF_PROFILE_ID,
                                                                        ""));
                                        jsonParams.addProperty("user_image",
                                                userImage);
                                        jsonParams.addProperty("user_name",
                                                userName);

                                        OkHttpClientUtil.getInstance()
                                                .initialize(getContext());
                                        try {
                                            OkHttpClientUtil
                                                    .doPostRequest(
                                                            AppConstants.URL_UPDATE_USER_PROFILE,
                                                            jsonParams
                                                                    .toString(),
                                                            new Callback() {
                                                                @Override
                                                                public void onFailure(
                                                                        com.squareup.okhttp.Request request,
                                                                        IOException e) {
                                                                    logger.error(
                                                                            LOG_TAG,
                                                                            "Update user profile Failed!");
                                                                }

                                                                @Override
                                                                public void onResponse(
                                                                        com.squareup.okhttp.Response response)
                                                                        throws IOException {
                                                                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                                                                        response.cacheResponse();
                                                                        logger.debug(
                                                                                LOG_TAG,
                                                                                "User Profile Update Successful!");
                                                                    }
                                                                }
                                                            });
                                        } catch (IOException e) {
                                            e.printStackTrace();
                                        }

                                        SharedPreferences.Editor e2 = mSharedPreferences
                                                .edit();
                                        e2.putString(
                                                AppConstants.PREF_USER_NAME,
                                                userName).apply();
                                        e2.putString(
                                                AppConstants.PREF_USER_PROFILE_IMAGE,
                                                userImage).apply();

                                    } else if (!(userImage
                                            .equalsIgnoreCase(userImageParams))) {
                                        logger.debug(LOG_TAG, "Update : "
                                                + userImage + " : "
                                                + userImageParams);
                                        logger.debug(LOG_TAG, "Update : "
                                                + userName + " : "
                                                + userNameParams);
                                        JsonObject jsonParams = new JsonObject();
                                        jsonParams
                                                .addProperty(
                                                        "social_id",
                                                        mSharedPreferences
                                                                .getString(
                                                                        AppConstants.PREF_SOCIAL_ID,
                                                                        ""));
                                        jsonParams
                                                .addProperty(
                                                        "social_type",
                                                        mSharedPreferences
                                                                .getString(
                                                                        AppConstants.PREF_SOCIAL_TYPE,
                                                                        ""));
                                        jsonParams.addProperty("email", mSharedPreferences.getString(AppConstants.PREF_USER_EMAIL, ""));
                                        jsonParams.addProperty("user_image",
                                                userImage);
                                        jsonParams.addProperty("user_name",
                                                userName);
                                        OkHttpClientUtil.getInstance()
                                                .initialize(getContext());
                                        try {
                                            OkHttpClientUtil
                                                    .doPostRequest(
                                                            AppConstants.URL_UPDATE_USER_PROFILE,
                                                            jsonParams
                                                                    .toString(),
                                                            new Callback() {
                                                                @Override
                                                                public void onFailure(
                                                                        com.squareup.okhttp.Request request,
                                                                        IOException e) {
                                                                    logger.error(
                                                                            LOG_TAG,
                                                                            "User update profile Failed!");
                                                                }

                                                                @Override
                                                                public void onResponse(
                                                                        com.squareup.okhttp.Response response)
                                                                        throws IOException {
                                                                    if (response.code() ==
                                                                            AppConstants.STATUS_CODE_SUCCESS) {
                                                                        response.cacheResponse();
                                                                        logger.debug(
                                                                                LOG_TAG,
                                                                                "User updated Successfully!");

                                                                    }
                                                                }
                                                            });
                                        } catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        SharedPreferences.Editor e2 = mSharedPreferences
                                                .edit();
                                        e2.putString(
                                                AppConstants.PREF_USER_NAME,
                                                userName).apply();
                                        e2.putString(
                                                AppConstants.PREF_USER_PROFILE_IMAGE,
                                                userImage).apply();
                                    } else {
                                        logger.debug(LOG_TAG, "Not Update : "
                                                + userImage + " : "
                                                + userImageParams);
                                    }

                                } else {
                                    logger.error(LOG_TAG,
                                            "Unidentified Response Code : "
                                                    + response.code());
                                }
                            }

                            @Override
                            public void onFailure(
                                    com.squareup.okhttp.Request arg0,
                                    IOException arg1) {

                            }
                        });
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : parseApiKey
     * Description : This class is used to fetch all comment from web server in background
     * thread.
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */
    private void parseApiKey(String API_KEY) {
        progressBarCircularIndeterminate.setVisibility(VISIBLE);
        logger.debug(LOG_TAG, "API_KEY :" + API_KEY);
        final String screenName = mContext.getClass().getSimpleName();
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("api_key", API_KEY);
        jsonParams.addProperty("screen_name", screenName);
        jsonParams.addProperty("package_name", mContext.getPackageName());
        String pkg = mActivity.getApplicationContext().getPackageName();
        String encodedData = "";
        byte[] bitmapdata;
        try {
            Drawable icon = mActivity.getPackageManager().getApplicationIcon(pkg);
            Bitmap bitmap = ((BitmapDrawable) icon).getBitmap();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
            bitmapdata = stream.toByteArray();
            encodedData = Base64.encodeToString(bitmapdata, Base64
                    .DEFAULT);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (mSharedPreferences.getBoolean(AppConstants.PREF_HAS_APP_ICON_SENDED, false)) {
            jsonParams.addProperty("app_image", "");
        } else {
            jsonParams.addProperty("app_image", encodedData);
        }
        OkHttpClientUtil.getInstance().initialize(mContext);

        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_KEY_VERIFICATION,
                    jsonParams.toString(), new
                            Callback() {
                                @Override
                                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                    logger.error(LOG_TAG, "Failed to Fetch API KEY " + e.getLocalizedMessage());


                                    if (mActivity != null) {
                                        mActivity.runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                progressBarCircularIndeterminate.setVisibility(GONE);
                                            }
                                        });
                                        Bundle bundle = new Bundle();
                                        bundle.putString(AppConstants.WIDGET_CATEGORY, mWidgetCategory);
                                        Fragment commentFragment = new CommentFragment();
                                        commentFragment.setArguments(bundle);
                                        mActivity.getFragmentManager().beginTransaction().add(R.id
                                                .layout_fyreon_widget_down_container, commentFragment).commit();
                                    }
                                }

                                @Override
                                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                                        response.cacheResponse();
                                        String res = response.body().string();
                                        if (res != null) {
                                            logger.debug(LOG_TAG, "Verify Key :" + res);
                                            JsonParser parser = new JsonParser();
                                            JsonElement commentsElement = parser.parse(res);
                                            JsonArray array = commentsElement.getAsJsonArray();
                                            JsonObject result = array.get(0).getAsJsonObject();
                                            logger.debug(LOG_TAG, "JSON ARRAY : " + result.toString());
                                            logger.debug(LOG_TAG, "Screen Key [get_screen_key] : " + result.get("screen_key").getAsString());
                                            logger.debug(LOG_TAG, "Screen Name : " + screenName);
                                            mDatabaseCipherTable.open();
                                            ResultModel resultModelObj = new ResultModel(0, screenName, mContext.getPackageName(), result.get("screen_key").getAsString());
                                            mDatabaseCipherTable.addResult(resultModelObj);
                                            mDatabaseCipherTable.close();

                                            SharedPreferences.Editor e2 = mSharedPreferences.edit();
                                            e2.putString(AppConstants.APPID, "1");
                                            e2.putBoolean(AppConstants.PREF_HAS_APP_ICON_SENDED, true);
                                            e2.apply();
                                            if (mActivity != null && !mActivity.isFinishing()) {
                                                mActivity.runOnUiThread(new Runnable() {
                                                    @Override
                                                    public void run() {
                                                        progressBarCircularIndeterminate.setVisibility(GONE);
                                                    }
                                                });
                                                Bundle bundle = new Bundle();
                                                bundle.putString(AppConstants.WIDGET_CATEGORY, mWidgetCategory);
                                                Fragment commentFragment = new CommentFragment();
                                                commentFragment.setArguments(bundle);
//                                                    mMainFragment = new MainFragment((FragmentActivity) mActivity);
                                                mActivity
                                                        .getFragmentManager()
                                                        .beginTransaction().add(R.id.layout_fyreon_widget_down_container, commentFragment).commit();
                                            }
                                            getNotifications(result.get("screen_key").getAsString());
                                        } else if (response.code() == AppConstants.STATUS_CODE_FAILURE_AUTH) {
                                            llPermissionWarning.setVisibility(View.VISIBLE);
                                            llPermissionWarning.startAnimation(animShowView);
                                            llTopStrip.startAnimation(animHideView);
                                            llTopStrip.setVisibility(View.GONE);
                                            btnUp.setVisibility(View.GONE);
                                            progressBarCircularIndeterminate.setVisibility(GONE);
                                            if (res != null) {
                                                JsonParser parser = new JsonParser();
                                                JsonElement commentsElement = parser.parse(res);
                                                JsonObject result = commentsElement.getAsJsonObject();
                                                logger.debug(LOG_TAG, "JSON ARRAY : " + result.toString());
                                                txtWarningText.setText("" + result.get("msg").getAsString());
                                            }

                                        }
                                    } else {
                                        logger.error(LOG_TAG, "Unidentified Response Code : " + response.code());
                                        mErrorView.setError(response.code());
                                        mErrorView.setErrorTitle(AppConstants.identifyCodes
                                                (response.code()));
                                        mErrorView.setOnRetryListener(new RetryListener() {
                                            @Override
                                            public void onRetry() {
                                                checkAppConfig();
                                            }
                                        });

                                    }
                                }
                            }

            );
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : fetchCommentCount
     * Description : This class is used to fetch all comment from web server in background
     * thread.
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 1/4/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */

    @Deprecated
    private void fetchCommentCount() {
        // recycleCommentList.setVisibility(View.GONE);
        String API_KEY = null;
        ResultModel resultModel = new ResultModel();
        mDatabaseCipherTable.open();
        //List<ResultModel> mResult = mDatabaseCipherTable.getResults(resultModel.mAppKey, null, null);
        List<ResultModel> mResult = mDatabaseCipherTable.getResults(resultModel.mAppKey, new String[]{mActivity.getClass().getSimpleName()}, null);
        mDatabaseCipherTable.close();
        logger.debug(LOG_TAG, "Result Size: " + mResult.size());
        if (mResult.size() > 0) {
            API_KEY = mResult.get(mResult.size() - 1).mAppKey;
        }
        logger.debug(LOG_TAG, "API KEY :" + API_KEY);

        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("screen_key", API_KEY);
        jsonParams.addProperty("category", mWidgetCategory);
        logger.debug(LOG_TAG, "Json Body : " + jsonParams.toString());
        OkHttpClientUtil.getInstance().initialize(getContext());
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_COMMENT_COUNT, jsonParams.toString(), new Callback() {
                @Override
                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                    logger.error(LOG_TAG, "Failed to Fetch Comment Count");
                }

                @Override
                public void onResponse(final com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                        response.cacheResponse();
                        final String res = response.body().string();
                        mActivity.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                if (res != null) {
                                    logger.debug(LOG_TAG, "Comment Count :" + res);
                                    JsonParser parser = new JsonParser();
                                    JsonElement commentsElement = parser.parse(res);
                                    JsonObject result = commentsElement.getAsJsonObject();
//                                    txtComments.setText(result.get("comments").getAsString());
//                                    txtLikes.setText(result.get("likes").getAsString());
                                }
                            }


                        });
                    } else if (response.code() == AppConstants.STATUS_CODE_FAILURE) {
                        logger.error(LOG_TAG, "Exception to fetch metadata");
                    } else {
                        logger.error(LOG_TAG, "Unidentified Response Code : " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : getProfileDetail
     * Description : This class is used to fetch users social profile information.
     * Like : Profile Name, Profile Image
     * Date of Creation : 1/4/15
     *
     * @param social_types
     * @param socialID     <p/>
     *                     -------------------------------------------------------------------------------------
     *                     Update Log:
     *                     Date:		By:		    Details:
     *                     1/4/15    Rajan       Create full class
     *                     <p/>
     *                     -----------------------------------------------------------------------------------
     * @author Virtual Reality systems
     * @see com.squareup.okhttp
     */

    private void getProfileDetail(final String socialID, String social_types) throws UnsupportedEncodingException, TwitterException {
        String userSocialId = socialID;
        String socialTypes = social_types;
        if (socialTypes.equals(AppConstants.SOCIAL_TYPES_TWITTER)) {
            //result = getTwitterStream(userSocialId);
            //final String TWITTER_TOKEN_URL = "https://api.twitter.com/oauth2/token";
            //final String TWITTER_STREAM_URL = "https://api.twitter.com/1

            // .1/users/show.json?user_id=";
            String twitterConsumerKey = mSharedPreferences.getString(AppConstants.TWITTER_CONSUMER_KEY, "");
            String twitterConsumerSecret = mSharedPreferences.getString(AppConstants.TWITTER_CONSUMER_SECRET, "");
            String twitteroAuthAccessToken = mSharedPreferences.getString(AppConstants
                    .TWITTER_OAUTH_TOKEN, "");
            String twitteroAuthTokenSecret = mSharedPreferences.getString(AppConstants
                    .TWITTER_OAUTH_TOKEN_SECRET, "");


            // Twitter Conf.
            ConfigurationBuilder cb = new ConfigurationBuilder();
            cb.setDebugEnabled(true).setOAuthConsumerKey(twitterConsumerKey).setOAuthConsumerSecret
                    (twitterConsumerSecret)
                    .setOAuthAccessToken(twitteroAuthAccessToken).setOAuthAccessTokenSecret
                    (twitteroAuthTokenSecret);
            TwitterFactory tf = new TwitterFactory(cb.build());
            Twitter twitter = tf.getInstance();
            User user = twitter.showUser(Long.parseLong(socialID));

            txtUserProfileName.setText(user.getName());
            ImageLoader.getInstance().displayImage(user.getOriginalProfileImageURL(),
                    imgUserProfileImage, displayImageOptions);
            updateUserProfile(user.getName(), user.getOriginalProfileImageURL());

//            String urlApiKey = URLEncoder.encode(twitterConsumerKey, "UTF-8");
//            String urlApiSecret = URLEncoder.encode(twitterConsumerSecret, "UTF-8");
//
//            // Concatenate the encoded consumer key, a colon character, and the
//            // encoded consumer secret
//            String combined = urlApiKey + ":" + urlApiSecret;
//
//            // Base64 encode the string
//            String base64Encoded = Base64.encodeToString(combined.getBytes(), Base64.NO_WRAP);
//            JsonObject jsonParams = new JsonObject();
//            jsonParams.addProperty("grant_type", "client_credentials");
//            OkHttpClientUtil.getInstance().initialize(getContext());
//            try {
//                OkHttpClientUtil.doPostRequest(TWITTER_TOKEN_URL, new String[]{"Authorization",
//                        "Content-Type"}, new String[]{"Basic " + base64Encoded,
//                        "application/x-www-form-urlencoded;charset=UTF-8"}, jsonParams.toString(), new
//                        Callback() {
//                            @Override
//                            public void onFailure(com.squareup.okhttp.Request request, IOException e) {
//                                logger.debug(LOG_TAG, "Client Response Failure Twitter");
//                            }
//
//                            @Override
//                            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
//                                if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
//                                    response.cacheResponse();
//                                    String res = response.body().string();
//                                    if (res != null) {
//                                        JsonParser parser = new JsonParser();
//                                        JsonElement commentsElement = parser.parse(res);
//                                        JsonObject result = commentsElement.getAsJsonObject();
//                                        loadTwitterData(result, socialID, TWITTER_STREAM_URL);
//                                    }
//                                }
//                            }
//                        });
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
        } else {
            //result = getGPlusStream(userSocialId);
            OkHttpClientUtil.getInstance().initialize(getContext());
            try {
                OkHttpClientUtil.doPostRequest("http://picasaweb.google.com/data/entry/api/user/" +
                        userSocialId + "?alt=json", new Callback() {
                    @Override
                    public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                        logger.error(LOG_TAG, "Failed to load Google+ Data");
                    }

                    @Override
                    public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                        if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                            response.cacheResponse();
                            String res = response.body().string();
                            if (res != null) {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(res);
                                JsonObject result = commentsElement.getAsJsonObject();
                                JsonObject entry = result.getAsJsonObject("entry");
                                JsonObject urlJsonObject = entry.getAsJsonObject("gphoto$thumbnail");
                                JsonObject nameJsonObject = entry.getAsJsonObject("gphoto$nickname");
                                final String profileUrl = urlJsonObject.get("$t").getAsString();
                                final String profileName = nameJsonObject.get("$t").getAsString();

                                mActivity.runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        txtUserProfileName.setText(profileName);
                                        ImageLoader.getInstance().displayImage(profileUrl,
                                                imgUserProfileImage, displayImageOptions);
                                    }
                                });
                                updateUserProfile(profileName, profileUrl);
                            }
                        }
                    }
                });
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : logout
     * Description : In this method implement logout functionality.
     * Date of Creation : 2/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Bhadresh      Create full method
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */
    private void logout() {

        SharedPreferences.Editor e = mSharedPreferences.edit();
        e.putBoolean(AppConstants.PREF_IS_LOGIN, false);
        e.commit();
        final RelativeLayout llUPS = (RelativeLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_user_profile_strip);
        final LinearLayout llCTS = (LinearLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_count_strip);
//        ImageButton llTSL = (ImageButton) mActivity.findViewById(R.id.layout_fyreon_widget_down_btn_logo);
        //   LinearLayout llTSL = (LinearLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_top_strip_logo);
        Animation animationShowView = AnimationUtils.loadAnimation(mContext, R.anim.left_to_right);
        Animation animationHideView = AnimationUtils.loadAnimation(mContext, R.anim.right_to_left);
        animationHideView.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                llCTS.setVisibility(View.VISIBLE);
                llUPS.setVisibility(View.GONE);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        //llCTS.startAnimation(animationHideView);
        llUPS.startAnimation(animationHideView);
        //  llTSL.setBackgroundResource(R.drawable.shape_logo_red);
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {
//            callFacebookLogout(mActivity);
        }
        if (mSharedPreferences.getBoolean(AppConstants.IS_TWITTER_INTEGRATED, false)) {
            CookieSyncManager.createInstance(mContext);
            android.webkit.CookieManager cookieManager = android.webkit.CookieManager.getInstance();
            cookieManager.removeSessionCookie();
        }


    }

    @Override
    public void onLogoutSuccess() {
        logger.debug(LOG_TAG, "Logout");
        RelativeLayout llUPS = (RelativeLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_user_profile_strip);
        LinearLayout llCTS = (LinearLayout) mActivity.findViewById(R.id.layout_fyreon_widget_up_ll_count_strip);
        llUPS.setVisibility(View.GONE);
        llCTS.setVisibility(View.VISIBLE);
    }

    @Override
    public void onLogoutFailure() {

    }

}
