package com.vrs.android.fyreon.adapters;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.ui.CommentUserDetails;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.adapters
 * Created by vrsuser on 16/4/15.
 * Time : 5:57 PM
 * Project : fyreon-library-android
 * Modified : 16 17 57
 */
public class CommentDetailListAdapter extends ArrayAdapter<CommentListModel> {

    static final String LOG_TAG = CommentListAdapter.class.getSimpleName();
    private static final Logger logger = new Logger(AppConstants.isDebug, LOG_TAG);
    private static final int VIEW_TYPE_COUNT = 2;
    private static final int VIEW_TYPE_MAIN_POST = 0;
    private static final int VIEW_TYPE_REPLIES = 1;
    private static final String APP_BADGE = " Via FyreOn";
    List<CommentListModel> dataList = new ArrayList<>();
    Context mContext;
    LayoutInflater mInflater = null;
    SharedPreferences mSharedPreferences;
    DisplayImageOptions displayOptions;
    private boolean mUseMainLayout = true;
    private adapterInterfaceBridge mBridge;


    public CommentDetailListAdapter(Context context, int resource, List<CommentListModel> objects, adapterInterfaceBridge mBridge) {
        super(context, resource, objects);
        this.mContext = context;
        this.dataList = objects;
        mSharedPreferences = context.getSharedPreferences(AppConstants.PREF_NAME, Context.MODE_PRIVATE);
        this.mBridge = mBridge;
        displayOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon).showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = new ViewHolder();
        View layoutView = convertView;

        mInflater = (LayoutInflater) mContext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        int viewType = getItemViewType(position);
        int layoutId = -1;
        switch (viewType) {
            case VIEW_TYPE_MAIN_POST: {
                layoutId = R.layout.list_item_big_main_comment;
                if (layoutView == null) {

                    layoutView = mInflater.inflate(layoutId, null, false);
                    holder.ivProfileIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_profile);
                    holder.txtName = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_name);
                    holder.txtDate = (TextView) layoutView
                            .findViewById(R.id.comment_list_item_txt_date);
                    holder.txtComment = (TextView) layoutView
                            .findViewById(R.id.comment_list_item_txt_comment);
                    holder.ivFavoriteItem = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_favorite);
                    holder.llFavoriteLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_favorite);
                    holder.llCommentLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_comment);
                    holder.txtFavoriteCount = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_favorite_count);
                    holder.txtCommentCount = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_comment_count);
                    holder.llReplyLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_reply);
                    holder.llShareLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_share_post);
                    holder.llFavoriteTextLayout = (LinearLayout) layoutView.findViewById(R.id.ll_favorite_txt_layout);
                    holder.llCommentTextLayout = (LinearLayout) layoutView.findViewById(R.id.ll_comment_txt_layout);
                    holder.txtAdminBadge = (TextView) layoutView.findViewById(R.id
                            .comment_list_item_txt_admin_badge);
                    layoutView.setTag(holder);
                } else {
                    holder = (ViewHolder) layoutView.getTag();
                }

                final CommentListModel commentDataList = dataList.get(position);
                holder.txtName.setText(commentDataList.getName());
                holder.llFavoriteLayout.setTag(holder);

                if (commentDataList.isAdmin()) {
                    holder.txtAdminBadge.setVisibility(View.VISIBLE);
                } else {
                    holder.txtAdminBadge.setVisibility(View.GONE);
                }
                if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
//                    Picasso.with(mContext)
//                            .load("https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large")
//                            .placeholder(R.drawable.default_user_icon)
//                            .into(holder.ivProfileIcon);
                    ImageLoader.getInstance().displayImage("https://graph.facebook.com/" +
                            commentDataList.getSocial_id() + "/picture?type=large", holder
                            .ivProfileIcon, displayOptions);
                    logger.debug(LOG_TAG, "profile Image URL : " + "https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large");
                } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_TWITTER) || commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_GPLUS)) {
                    if (commentDataList.getIcons().equalsIgnoreCase("")) {
                    } else {
                        logger.debug("Picasso", "Image Path " + commentDataList.getIcons());
//                        Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                        ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                                .ivProfileIcon, displayOptions);
                        logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
                    }
                }

                logger.debug(LOG_TAG, "Date :" + commentDataList.getTime());

                holder.txtDate.setText(AppConstants.getDateCurrentTimeZone(Long.parseLong(commentDataList.getTime())));

                // This will set Comments in listview
                holder.txtComment.setText(commentDataList.getComment());
                if (commentDataList.getLiked_by() != null) {
                    holder.txtFavoriteCount.setText(String.valueOf(commentDataList.getLiked_by().size()));
                } else {
                    holder.txtFavoriteCount.setText(commentDataList.getLikes_count());
                }
                if (commentDataList.getReplies() != null) {
                    holder.txtCommentCount.setText(String.valueOf(commentDataList.getReplies()));
                } else {
                    holder.txtCommentCount.setText("0");
                }


                if (commentDataList.getLiked_id() != null) {
                    if (commentDataList.getLiked_id().equalsIgnoreCase(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""))) {
                        if (commentDataList.getLiked().equalsIgnoreCase("1")) {
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                        } else {
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                        }
                    } else {
                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                    }
                }

                logger.debug(LOG_TAG, "Social id Size is less then < 0 " + position);
                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));

                if (commentDataList.getLiked_by() != null) {
                    if (commentDataList.getLiked_by().size() > 0) {
                        for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                            logger.debug(LOG_TAG, "Current Checking ID :" + commentDataList.getLiked_by().get(j));
                            logger.debug(LOG_TAG, "Pref Social ID :" + mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""));
                            if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                                logger.debug(LOG_TAG, "Social id Matched on " + position);
                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                            } else {
                                logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                            }
                        }
                    }
                }

                holder.llFavoriteLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (isLogin()) {
                            int liked = 0;
                            ViewHolder holder = (ViewHolder) v.getTag();
                            if (v.getId() == holder.llFavoriteLayout.getId()) {
                                CommentListModel feedItem = dataList.get(position);
                                logger.debug(LOG_TAG, position + "");
                                logger.debug(LOG_TAG, feedItem.getComment() + "");

                                if (commentDataList.getLiked_by() != null) {
                                    if (commentDataList.getLiked_by().size() > 0) {
                                        for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                                            if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                                                logger.debug(LOG_TAG, "Social id Matched on " + position);
                                                liked = 0;
                                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                            } else {
                                                liked = 1;
                                                logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                                            }
                                        }
                                    } else {
                                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                        liked = 1;
                                    }
                                } else {
                                    holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                    liked = 1;
                                }
                                logger.debug(LOG_TAG, "Liked : " + liked);
                                postLike(mSharedPreferences.getString(AppConstants
                                                .PREF_PROFILE_ID, ""), feedItem.getComment_id(),
                                        mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""), mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, ""), liked, position, v);
                            }
                        } else {
                            Toast.makeText(mContext, "You need to be logged in order to favorite the comment!", Toast.LENGTH_LONG).show();
                        }
                    }
                });

                holder.llReplyLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        mBridge.onClicked();
                    }
                });


                holder.llShareLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent sharingIntent = new Intent(android.content.Intent.ACTION_SEND);
                        sharingIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        sharingIntent.setType("text/plain");
                        sharingIntent.putExtra(android.content.Intent.EXTRA_TEXT, commentDataList.getComment() + APP_BADGE);
                        Intent newIntent = Intent.createChooser(sharingIntent, "Share via");
                        newIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        getContext().startActivity(newIntent);
                    }
                });

                holder.llFavoriteTextLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent mIntent = new Intent(getContext(), CommentUserDetails.class);
                        mIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        mIntent.putExtra("comment_id", commentDataList.getComment_id());
                        mIntent.putExtra("favorite", true);
                        getContext().startActivity(mIntent);
                    }
                });

                holder.llCommentTextLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent mIntent = new Intent(getContext(), CommentUserDetails.class);
                        mIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        mIntent.putExtra("comment_id", commentDataList.getComment_id());
                        mIntent.putExtra("favorite", false);
                        getContext().startActivity(mIntent);
                    }
                });

                return layoutView;
            }
            case VIEW_TYPE_REPLIES: {
                layoutId = R.layout.list_item_activity_comment;
                if (layoutView == null) {

                    layoutView = mInflater.inflate(layoutId, null, false);
                    holder.ivProfileIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_profile);
                    holder.txtName = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_name);
                    holder.txtDate = (TextView) layoutView
                            .findViewById(R.id.comment_list_item_txt_date);
                    holder.txtComment = (TextView) layoutView
                            .findViewById(R.id.comment_list_item_txt_comment);
                    holder.ivFavoriteItem = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_favorite);
                    holder.llFavoriteLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_favorite);
                    holder.llCommentLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_comment);
                    holder.txtFavoriteCount = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_favorite_count);
                    holder.txtCommentCount = (TextView) layoutView.findViewById(R.id.comment_list_item_txt_comment_count);
                    holder.ivSocialIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_social_icon);
                    holder.txtAdminBadge = (TextView) layoutView.findViewById(R.id
                            .comment_list_item_txt_admin_badge);
                    holder.llShareLayout = (LinearLayout) layoutView.findViewById(R.id
                            .fragment_comment_ll_share);
                    layoutView.setTag(holder);
                } else {
                    holder = (ViewHolder) layoutView.getTag();
                }

                final CommentListModel commentDataList = dataList.get(position);
                holder.txtName.setText(commentDataList.getName());
                holder.llFavoriteLayout.setTag(holder);

                if (commentDataList.isAdmin()) {
                    holder.txtAdminBadge.setVisibility(View.VISIBLE);
                } else {
                    holder.txtAdminBadge.setVisibility(View.GONE);
                }

                if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
//                    Picasso.with(mContext)
//                            .load("https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large")
//                            .placeholder(R.drawable.default_user_icon)
//                            .into(holder.ivProfileIcon);
                    holder.ivSocialIcon.setImageResource(R.drawable.facebook);
                    ImageLoader.getInstance().displayImage("https://graph.facebook.com/" +
                            commentDataList.getSocial_id() + "/picture?type=large", holder
                            .ivProfileIcon, displayOptions);
                    logger.debug(LOG_TAG, "profile Image URL : " + "https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large");
                } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_TWITTER)) {
                    holder.ivSocialIcon.setImageResource(R.drawable.twitter_social_ic);
                    if (commentDataList.getIcons().equalsIgnoreCase("")) {
                    } else {
                        logger.debug("Picasso", "Image Path " + commentDataList.getIcons());

//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                        ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                                .ivProfileIcon, displayOptions);
                        logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
                    }
                } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_GPLUS)) {
                    holder.ivSocialIcon.setImageResource(R.drawable.google_social_ic);
                    if (commentDataList.getIcons().equalsIgnoreCase("")) {
                    } else {
                        logger.debug("Picasso", "Image Path " + commentDataList.getIcons());

//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                        ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                                .ivProfileIcon, displayOptions);
                        logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
                    }
                } else {
                    holder.ivSocialIcon.setImageResource(R.drawable.ic_fyreon_icon);
                    if (commentDataList.getIcons().equalsIgnoreCase("")) {
                    } else {
                        logger.debug("Picasso", "Image Path " + commentDataList.getIcons());

//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                        ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                                .ivProfileIcon, displayOptions);
                        logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
                    }
                }

                logger.debug(LOG_TAG, "Date :" + commentDataList.getTime());

                holder.txtDate.setText(AppConstants.getTimeTwitter(Long.parseLong(commentDataList.getTime())));


                // This will set Comments in listview
                holder.txtComment.setText(commentDataList.getComment());
                if (commentDataList.getLiked_by() != null) {
                    holder.txtFavoriteCount.setText(String.valueOf(commentDataList.getLiked_by().size()));
                } else {
                    holder.txtFavoriteCount.setText(commentDataList.getLikes_count());
                }
                if (commentDataList.getReplies() != null) {
                    holder.txtCommentCount.setText(String.valueOf(commentDataList.getReplies()));
                } else {
                    holder.txtCommentCount.setText("0");
                }


                if (commentDataList.getLiked_id() != null) {
                    if (commentDataList.getLiked_id().equalsIgnoreCase(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""))) {
                        if (commentDataList.getLiked().equalsIgnoreCase("1")) {
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                        } else {
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                        }
                    } else {
                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                    }
                }

//        logger.debug(LOG_TAG, "Json Comment Like ID :" +)
                logger.debug(LOG_TAG, "Social id Size is less then < 0 " + position);
                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));

                if (commentDataList.getLiked_by() != null) {
                    if (commentDataList.getLiked_by().size() > 0) {
                        for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                            logger.debug(LOG_TAG, "Current Checking ID :" + commentDataList.getLiked_by().get(j));
                            logger.debug(LOG_TAG, "Pref Social ID :" + mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, ""));
                            if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                                logger.debug(LOG_TAG, "Social id Matched on " + position);
                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                            } else {
                                logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                            }
                        }
                    }
                }

                holder.llFavoriteLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (isLogin()) {
                            int liked = 0;
                            ViewHolder holder = (ViewHolder) v.getTag();
                            if (v.getId() == holder.llFavoriteLayout.getId()) {
                                CommentListModel feedItem = dataList.get(position);
                                logger.debug(LOG_TAG, position + "");
                                logger.debug(LOG_TAG, feedItem.getComment() + "");

                                if (commentDataList.getLiked_by() != null) {
                                    if (commentDataList.getLiked_by().size() > 0) {
                                        for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                                            if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                                                logger.debug(LOG_TAG, "Social id Matched on " + position);
                                                liked = 0;
                                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                            } else {
                                                liked = 1;
                                                logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                                            }
                                        }
                                    } else {
                                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                        liked = 1;
                                    }
                                } else {
                                    holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                    liked = 1;
                                }
                                logger.debug(LOG_TAG, "Liked : " + liked);
                                postLike(mSharedPreferences.getString(AppConstants
                                                .PREF_PROFILE_ID, ""), feedItem.getComment_id(),
                                        mSharedPreferences
                                                .getString(AppConstants.PREF_SOCIAL_ID, ""), mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, ""), liked, position, v);
                            }
                        } else {
                            Toast.makeText(mContext, "You need to be logged in order to favorite the comment!", Toast.LENGTH_LONG).show();
                        }
                    }
                });

                holder.llShareLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        Intent sharingIntent = new Intent(android.content.Intent.ACTION_SEND);
                        sharingIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        sharingIntent.setType("text/plain");
                        sharingIntent.putExtra(android.content.Intent.EXTRA_TEXT, commentDataList.getComment() + APP_BADGE);
                        Intent newIntent = Intent.createChooser(sharingIntent, "Share via");
                        newIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        getContext().startActivity(newIntent);
                    }
                });

                return layoutView;
            }
        }
        return null;

    }

    public void setUseMainLayout(boolean mUseMainLayout) {
        this.mUseMainLayout = mUseMainLayout;
    }

    private void postLike(String profileId, String CommentID, final String SocialID, String
            Social_Type, int like, final int position, View holderView) {

        final CommentListModel model = dataList.get(position);
        final ViewHolder holder = (ViewHolder) holderView.getTag();
        if (like == 1) {
            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
        } else {
            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
        }
        final JsonObject commentRequestObject = new JsonObject();
        commentRequestObject.addProperty("comment_id", CommentID);
        commentRequestObject.addProperty("social_id", SocialID);
        commentRequestObject.addProperty("social_type", Social_Type);
        commentRequestObject.addProperty("profile_id", profileId);
        commentRequestObject.addProperty("like", like);

        OkHttpClientUtil.getInstance().initialize(getContext());
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_COMMENT_LIKE, commentRequestObject
                    .toString(), new Callback() {
                Handler mainHandler = new Handler(mContext.getMainLooper());

                @Override
                public void onFailure(Request request, IOException e) {
                    logger.error(LOG_TAG, "Failed to favorite comment!");
                    mainHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(getContext(), getContext().getString(R.string
                                    .network_error), Toast.LENGTH_LONG).show();
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                        }
                    });

                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                        response.cacheResponse();

                        final String resBody = response.body().string();
                        mainHandler.post(new Runnable() {
                            @Override
                            public void run() {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(resBody);
                                JsonObject result = commentsElement.getAsJsonObject();
                                model.setLiked_id(result.get("comment_id").getAsString());
                                model.setLiked(result.get("like").getAsString());
                                holder.txtFavoriteCount.setText(String.valueOf(result.get("like_count").getAsInt()));

                                ArrayList<String> comment = model.getLiked_by();
                                if (comment != null) {
                                    comment.add(SocialID);
                                }
                                model.setLiked_by(comment);
                            }
                        });
                    } else {
                        logger.error(LOG_TAG, "Unidentified Response code " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemViewType(int position) {
        return (position == 0 && mUseMainLayout) ? VIEW_TYPE_MAIN_POST : VIEW_TYPE_REPLIES;
    }

    @Override
    public int getViewTypeCount() {
        return VIEW_TYPE_COUNT;
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : isLogin
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @return boolean isLoggedIn
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private boolean isLogin() {
        boolean isLoggedIn = mSharedPreferences.getBoolean(AppConstants.PREF_IS_LOGIN, false);

        return isLoggedIn;
    }

    public interface adapterInterfaceBridge {
        void onClicked();
    }

    private class ViewHolder {
        public TextView txtName, txtDate, txtComment, txtFavoriteCount, txtCommentCount, txtAdminBadge;
        public ImageView ivProfileIcon, ivFavoriteItem, ivSocialIcon;
        public LinearLayout llFavoriteLayout, llCommentLayout, llReplyLayout, llShareLayout, llFavoriteTextLayout, llCommentTextLayout;
    }


}
