package com.vrs.android.fyreon.adapters;

import android.widget.BaseAdapter;

import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.adapters
 * Created by vrsuser on 18/6/15.
 * Time : 2:44 PM
 * Project : FyreonTest
 * Modified : 18 14 44
 */
public abstract class PagingBaseAdapter<T> extends BaseAdapter {
    protected List<T> items;

    public PagingBaseAdapter() {
        this.items = new ArrayList<>();
    }

    public PagingBaseAdapter(List<T> items) {
        this.items = items;
    }

    public void addMoreItems(List<T> newItems) {
        this.items.addAll(newItems);
        notifyDataSetChanged();
    }

    public void addMoreItems(int location, List<T> newItems) {
        this.items.addAll(location, newItems);
        notifyDataSetChanged();
    }

    public void removeAllItems() {
        this.items.clear();
        notifyDataSetChanged();
    }
}
