package com.vrs.android.fyreon.adapters;
/**---------------------------------------------------------------------------------
 File Name : ProfilePagerAdapter.java
 Version Information : Version 1.1
 Date of Creation : 08/04/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;

import java.util.List;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : ProfilePagerAdapter
 * Description : This is adapter for pager used in Profile Activity
 * Date of Creation : 08/04/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         08/04/15   Bhadresh      Create full class
 *         -----------------------------------------------------------------------------------
 */
public class ProfilePagerAdapter extends FragmentPagerAdapter {
    private List<Fragment> fragments;

    public ProfilePagerAdapter(FragmentManager fm, List<Fragment> fragments) {
        super(fm);
        this.fragments = fragments;
    }

    @Override
    public Fragment getItem(int position) {
        return this.fragments.get(position);
    }

    @Override
    public int getCount() {
        return this.fragments.size();
    }
}