/**
 * ---------------------------------------------------------------------------------
 * File Name : DatabaseCipherHelper.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */
package com.vrs.android.fyreon.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.vrs.android.fyreon.model.CrashData;

import java.util.ArrayList;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : DatabaseCipherHelper
 * Description : Secure database helper class.
 * Date of Creation : 25/2/15
 * Extends : SQLiteOpenHelper
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 * @see android.database.sqlite.SQLiteOpenHelper
 */
public class DatabaseCipherHelper extends SQLiteOpenHelper {

    // Declaration of table and it's column name.
    public static final String TABLE_TARGET = "table_app_key";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_SCREEN_NAME = "screen_name";
    public static final String COLUMN_PACKAGE_NAME = "package_name";
    public static final String COLUMN_APP_KEY = "app_key";
    public static final String CRASH_REPORT_STACK_TRACE = "StackTrace";
    public static final String CRASH_REPORT_BRAND = "Brand";
    public static final String CRASH_REPORT_DEVICE = "Device";
    public static final String CRASH_REPORT_DEVICE_MANUFACTURE = "Manufacturer";
    // Exception Tables
    public static final String CRASH_REPORT_MODAL = "Modal";
    public static final String CRASH_REPORT_ANDROID_API_VERSION = "AndroidVersion";
    public static final String CRASH_REPORT_USER_KEY = "UserKey";
    public static final String CRASH_REPORT_TOTAL_MEMORY = "TotalMemory";
    public static final String CRASH_REPORT_CPU_USAGE = "CPUUsage";
    public static final String CRASH_REPORT_PACKAGE_NAME = "PackageName";
    public static final String CRASH_REPORT_APP_NAME = "AppName";
    public static final String CRASH_REPORT_TYPE = "Type";
    public static final String CRASH_REPORT_DATE_TIME = "Date";
    public static final String CRASH_REPORT_ID = "_id";
    // Database creation sql statement
    private static final String DATABASE_CREATE = "create table "
            + TABLE_TARGET + "(" + COLUMN_ID
            + " integer primary key autoincrement, "
            + COLUMN_SCREEN_NAME + " text, "
            + COLUMN_PACKAGE_NAME + " text, "
            + COLUMN_APP_KEY + " text);";
    // Declaration of database name and it's version.
    private static final String DATABASE_NAME = "test_widget.db";
    private static final int DATABASE_VERSION = 1;
    private static final String LOG_TAG = DatabaseCipherHelper.class.getSimpleName();
    private static final String TABLE_NAME = "CrashData";
    private static final String CREATE_TABLE_CRASHDATA = "CREATE TABLE "
            + TABLE_NAME + "(" + CRASH_REPORT_ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
            + CRASH_REPORT_STACK_TRACE + " TEXT," + CRASH_REPORT_BRAND
            + " TEXT," + CRASH_REPORT_DEVICE + " TEXT," + CRASH_REPORT_MODAL
            + " TEXT," + CRASH_REPORT_DEVICE_MANUFACTURE + " TEXT,"
            + CRASH_REPORT_ANDROID_API_VERSION + " TEXT,"
            + CRASH_REPORT_CPU_USAGE + " TEXT," + CRASH_REPORT_TOTAL_MEMORY
            + " TEXT," + CRASH_REPORT_PACKAGE_NAME + " TEXT,"
            + CRASH_REPORT_APP_NAME + " TEXT," + CRASH_REPORT_USER_KEY
            + " TEXT," + CRASH_REPORT_TYPE + " TEXT," + CRASH_REPORT_DATE_TIME
            + " Text" + ")";


    public DatabaseCipherHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    public DatabaseCipherHelper(Context context, String Database_name) {
        super(context, Database_name, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        sqLiteDatabase.execSQL(DATABASE_CREATE);
        sqLiteDatabase.execSQL(CREATE_TABLE_CRASHDATA);
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        Log.v(LOG_TAG,
                "Upgrading database from version " + oldVersion + " to "
                        + newVersion + ", which will destroy all old data");
        sqLiteDatabase.execSQL("DROP TABLE IF EXISTS " + TABLE_TARGET);
        sqLiteDatabase.execSQL("DROP TABLE IF EXISTS " + TABLE_NAME);
        onCreate(sqLiteDatabase);
    }

    public void insertCrashData(String strace, String brand, String device,
                                String modal, String manufacturer, String api, String memory,
                                String cpu, String packageName, String appName, String userKey,
                                String type, String dateTime) {

        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(CRASH_REPORT_STACK_TRACE, strace);
        values.put(CRASH_REPORT_BRAND, brand);
        values.put(CRASH_REPORT_DEVICE, device);
        values.put(CRASH_REPORT_DEVICE_MANUFACTURE, manufacturer);
        values.put(CRASH_REPORT_ANDROID_API_VERSION, api);
        values.put(CRASH_REPORT_TOTAL_MEMORY, memory);
        values.put(CRASH_REPORT_CPU_USAGE, cpu);
        values.put(CRASH_REPORT_PACKAGE_NAME, packageName);
        values.put(CRASH_REPORT_APP_NAME, api);
        values.put(CRASH_REPORT_USER_KEY, userKey);
        values.put(CRASH_REPORT_TYPE, type);
        values.put(CRASH_REPORT_DATE_TIME, dateTime);

        long rowid = db.insert(TABLE_NAME, null, values);

        db.close();
    }

    public void deleteRecord(int id) {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("delete from CrashData where _id=" + id);
        db.close();
    }

    public void deleteData() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("delete from CrashData");
        db.close();
    }

    public ArrayList<CrashData> getAllData() {
        String selectQuery = null;
        selectQuery = "SELECT  * FROM " + TABLE_NAME;
        ArrayList<CrashData> crashData = new ArrayList<CrashData>();
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor c = db.rawQuery(selectQuery, null);
        if (c.moveToFirst()) {
            do {

                CrashData data = new CrashData();
                data.setApi((c.getString(c
                        .getColumnIndex(CRASH_REPORT_ANDROID_API_VERSION))));
                Log.d("API",
                        ""
                                + c.getString(c
                                .getColumnIndex(CRASH_REPORT_USER_KEY)));
                data.setAppName((c.getString(c
                        .getColumnIndex(CRASH_REPORT_APP_NAME))));
                data.setBrand((c.getString(c.getColumnIndex(CRASH_REPORT_BRAND))));
                data.setCpu((c.getString(c
                        .getColumnIndex(CRASH_REPORT_CPU_USAGE))));
                data.setDevice((c.getString(c
                        .getColumnIndex(CRASH_REPORT_DEVICE))));
                data.setManufacturer((c.getString(c
                        .getColumnIndex(CRASH_REPORT_DEVICE_MANUFACTURE))));
                data.setMemory((c.getString(c
                        .getColumnIndex(CRASH_REPORT_TOTAL_MEMORY))));
                data.setModel((c.getString(c.getColumnIndex(CRASH_REPORT_MODAL))));
                data.setPackageName((c.getString(c
                        .getColumnIndex(CRASH_REPORT_PACKAGE_NAME))));
                data.setStrace((c.getString(c
                        .getColumnIndex(CRASH_REPORT_STACK_TRACE))));
                data.setUserKey((c.getString(c
                        .getColumnIndex(CRASH_REPORT_USER_KEY))));

                data.setRowId((c.getInt(c.getColumnIndex(CRASH_REPORT_ID))));

                crashData.add(data);
            } while (c.moveToNext());
        }
        c.close();
        db.close();
        return crashData;
    }

}
