package com.vrs.android.fyreon.fragments;
/**
 * ---------------------------------------------------------------------------------
 * File Name : UserLikesFragment.java
 * Version Information : Version 1.1
 * Date of Creation : 08/04/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : UserLikesFragment
 * Description : This is fragments of user Liks used in profile activity
 * Date of Creation : 08/04/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         08/04/15   Bhadresh      Create full class
 *         -----------------------------------------------------------------------------------
 */

public class UserLikesFragment extends Fragment {
    private static final String LOG_TAG = UserCommentsFragment.class.getSimpleName();
    private static final Logger logger = new Logger(AppConstants.isDebug, LOG_TAG);
    ListView lstLikesList;
    CustomListAdapter adapter;
    List<CommentListModel> list = new ArrayList<CommentListModel>();
    SharedPreferences mSharedPreferences;
    DisplayImageOptions displayOptions;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_user_likes, container, false);
        lstLikesList = (ListView) rootView.findViewById(R.id.fragment_user_likes_listview);
       /* lstLikesList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
                Intent startIntent = new Intent(getActivity(), CommentDetailActivity.class);
                startIntent.putExtra(AppConstants.COMMENT_ID, list.get(position).getComment_id());
                startIntent.putExtra(AppConstants.COMMENT_PARENT_ID, list.get(position).getParent_id());
                startIntent.putExtra(AppConstants.COMMENT_SCREEN_KEY, list.get(position).getScreen_id());
                startIntent.putExtra(AppConstants.COMMENT_SOCIAL_ID, list.get(position).getSocial_id());
                startIntent.putExtra(AppConstants.COMMENT_SOCIAL_TYPE, list.get(position).getSocial_types());
                startIntent.putExtra(AppConstants.COMMENT_CREATED, list.get(position).getTime());
                startIntent.putExtra(AppConstants.COMMENT_CONTENT, list.get(position).getComment());
                startIntent.putStringArrayListExtra(AppConstants.COMMENT_LIKES, list.get(position).getLiked_by());
                startIntent.putExtra(AppConstants.COMMENT_USER_NAME, list.get(position).getName());
                startIntent.putExtra(AppConstants.COMMENT_USER_IMAGE, list.get(position).getIcons());
                startIntent.putExtra(AppConstants.COMMENT_COMMENT_LIKES, list.get(position).getLikes_count());
                startIntent.putExtra(AppConstants.COMMENT_REPLIES, list.get(position).getReplies());
                startIntent.putExtra(AppConstants.WIDGET_CATEGORY, list.get(position).getCategory());
                getActivity().startActivity(startIntent);
            }
        });*/
        mSharedPreferences = getActivity().getSharedPreferences(AppConstants.PREF_NAME, 0);
        String profileId = mSharedPreferences.getString(
                AppConstants.PREF_PROFILE_ID, "");
        loadUserLikes(profileId);
        return rootView;
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : loadUserLikes
     * Description : Fetch user likes list from server
     * Date of Creation : 15/04/15updateUse
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * 15/04/15    Bhadresh       Created full Method
     * -----------------------------------------------------------------------------------
     */
    private void loadUserLikes(String profileId) {
        list.clear();
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("profile_id", profileId);

        OkHttpClientUtil.getInstance().initialize(getActivity());
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_GET_USER_LIKES, jsonParams.toString(), new Callback() {
                @Override
                public void onFailure(Request request, IOException e) {
                    logger.error(LOG_TAG, "Failed to get User likes !");
                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                        response.cacheResponse();

                        final String resBody = response.body().string();

                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(resBody);
                                JsonArray commentsArray = commentsElement.getAsJsonArray();
                                //String imageUrl =;
                                logger.debug(LOG_TAG, "Likes Array Size : " + commentsArray.size());

                                for (int i = 0; i < commentsArray.size(); i++) {
                                    JsonObject commentObject = commentsArray.get(i).getAsJsonObject();
                                    logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                                    String userId = commentObject.get("id").getAsString();
                                    String parentId = commentObject.get("parent_id").toString();
                                    String screenId = commentObject.get("screen_key").getAsString();
                                    String socialId = commentObject.get("social_id").getAsString();
                                    String social_types = commentObject.get("social_type").getAsString();
                                    String createdTime = commentObject.get("created").getAsString();
                                    String content = commentObject.get("content").getAsString();
                                    String likesCount = commentObject.get("likes").getAsString();
                                    String userName = commentObject.get("user_name").getAsString();
                                    String userImage;
                                    if (commentObject.get("user_image").isJsonNull()) {
                                        userImage = "";
                                    } else {
                                        userImage = commentObject.get("user_image").getAsString();
                                    }
                                    String appName = commentObject.get("app_name").getAsString();
                                    String category = commentObject.get("category").getAsString();
                                    JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                                    JsonArray replies_by_users = commentObject.get("replies").getAsJsonArray();
                                    ArrayList<String> liked_users = new ArrayList<String>();
                                    if (liked_by_users.size() > 0) {
                                        for (int j = 0; j < liked_by_users.size(); j++) {
                                            JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                            boolean isLiked = res.get("like").getAsBoolean();
                                            if (isLiked) {
                                                String social_id = res.get("social_id").getAsString();
                                                liked_users.add(social_id);
                                            }
                                        }
                                    }
                                    String replies = null;
                                    if (replies_by_users.size() > 0) {
                                        for (int j = 0; j < replies_by_users.size(); j++) {
                                            replies = String.valueOf(replies_by_users.size());
                                        }
                                    }
                                    logger.debug(LOG_TAG, "Parent ID : " + parentId);
                                    logger.debug(LOG_TAG, "Parent ID : " + parentId);
                                    CommentListModel commentListItem = new CommentListModel
                                            (userId, parentId, socialId, screenId, userName,
                                                    createdTime, content, userImage,
                                                    social_types, likesCount, liked_users,
                                                    appName, replies, category, "", "", false);
                                    //  CommentListModel listItem = new CommentListModel("", "", "", "", userName, createdTime, content, userImage, "", "", null, appName, null);
                                    list.add(commentListItem);
                                }
                                if (list.size() > 0) {
                                    adapter = new CustomListAdapter(getActivity(), list);
                                    lstLikesList.setAdapter(adapter);
                                }
//                                    adapter = new CustomListAdapter(getActivity(),list);
//                                    lstLikesList.setAdapter(adapter);
                            }
                        });
                    } else {
                        logger.error(LOG_TAG, "Unidentified Response Code : " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * ----------------------------------------------------------------------------------
     * Class Name : CustomListAdapter
     * Description : List adapter for user likes
     * Date of Creation : 15/04/15
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * 15/04/15    Bhadresh       Created full class
     * -----------------------------------------------------------------------------------
     */
    public class CustomListAdapter extends BaseAdapter {
        private Activity activity;
        private LayoutInflater inflater;
        private List<CommentListModel> listItems;

        public CustomListAdapter(Activity activity, List<CommentListModel> movieItems) {
            this.activity = activity;
            this.listItems = movieItems;
            displayOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon).showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
        }

        @Override
        public int getCount() {
            return listItems.size();
        }

        @Override
        public Object getItem(int location) {
            return listItems.get(location);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            if (inflater == null)
                inflater = (LayoutInflater) activity
                        .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            if (convertView == null)
                convertView = inflater.inflate(R.layout.list_item_activity_user_profile, null);

            TextView name = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_name);
            TextView comments = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_comments);
            TextView time = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_time);
            TextView appName = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_appname);
            ImageView image = (ImageView) convertView.findViewById(R.id.list_item_activity_user_profile_img_profile);

//            Picasso.with(getActivity()).load(listItems.get(position).getIcons()).into(image);
            ImageLoader.getInstance().displayImage(listItems.get(position).getIcons(), image,
                    displayOptions, new ImageLoadingListener() {
                        @Override
                        public void onLoadingStarted(String imageUri, View view) {

                        }

                        @Override
                        public void onLoadingFailed(String imageUri, View view, FailReason failReason) {

                        }

                        @Override
                        public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {

                        }

                        @Override
                        public void onLoadingCancelled(String imageUri, View view) {

                        }
                    });
            //image.setImageUrl(m.getThumbnailUrl(), imageLoader);

            // title
            name.setText(listItems.get(position).getName());
            comments.setText(listItems.get(position).getComment());
            appName.setText(listItems.get(position).getApp_name());
            time.setText(AppConstants.getTimeTwitter(Long.parseLong(listItems.get(position).getTime())));
            return convertView;
        }
    }
}