package com.vrs.android.fyreon.ui;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AppDetailActivity extends AppCompatActivity {
    private static final String LOG_TAG = UserProfileActivity.class.getSimpleName();
    private static final Logger logger = new Logger(AppConstants.isDebug, LOG_TAG);
    SharedPreferences mSharedPreferences;
    TextView txtApplicationName;
    ImageView imgApplicationIcon;
    TextView txtLikesCount;
    TextView txtCommentsCount;
    Drawable icon = null;
    Toolbar mToolBar;
    ListView lstAppCommentList;
    CustomListAdapter adapter;
    List<CommentListModel> list = new ArrayList<>();
    String appId = "";
    DisplayImageOptions displayOptions;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_app_detail);
        mToolBar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolBar);
        initViews();
        txtApplicationName.setText(getIntent().getStringExtra(AppConstants.COMMENT_APP_NAME));
        String pkg = getApplicationContext().getPackageName();

        try {
            icon = getPackageManager().getApplicationIcon(pkg);
            imgApplicationIcon.setImageDrawable(icon);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        getAppDetail();
    }

    private void initViews() {
        mSharedPreferences = getSharedPreferences(AppConstants.PREF_NAME, 0);
        txtApplicationName = (TextView) findViewById(R.id.activity_app_detail_txt_appname);
        imgApplicationIcon = (ImageView) findViewById(R.id.activity_app_detail_img_app_icon);
        txtLikesCount = (TextView) findViewById(R.id.activity_app_detail_txt_likes_count);
        txtCommentsCount = (TextView) findViewById(R.id.activity_app_detail_txt_comments_count);
        lstAppCommentList = (ListView) findViewById(R.id.activity_app_detail_listview);
        appId = getIntent().getStringExtra("application_id");
        getSupportActionBar().setTitle(getIntent().getStringExtra(AppConstants.COMMENT_APP_NAME));
        getSupportActionBar().setHomeButtonEnabled(true);
    }

    public boolean onOptionsItemSelected(MenuItem item) { // Handle item selection
        int i = item.getItemId();
        if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    private void getAppDetail() {
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("application_id", appId);
        logger.error(LOG_TAG, "Request Json : " + jsonParams.toString());

        OkHttpClientUtil.getInstance().initialize(getApplicationContext());
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_GET_APP_DETAIL, jsonParams.toString(), new Callback() {
                @Override
                public void onFailure(Request request, IOException e) {
                    logger.error(LOG_TAG, "Failed to fetch App detail!");
                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == AppConstants.STATUS_CODE_SUCCESS) {
                        response.cacheResponse();

                        final String resBody = response.body().string();
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(resBody);
                                JsonObject mainObject = commentsElement.getAsJsonObject();
                                String commentCount = mainObject.get("comments_count").getAsString();
                                String likeCount = mainObject.get("likes_count").getAsString();
                                txtCommentsCount.setText(commentCount);
                                txtLikesCount.setText(likeCount);
                                JsonArray commentsArray = mainObject.get("comments").getAsJsonArray();
                                //String imageUrl =;
                                for (int i = 0; i < commentsArray.size(); i++) {
                                    JsonObject commentObject = commentsArray.get(i).getAsJsonObject();
                                    logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                                    String createdTime = commentObject.get("comment_time").getAsString();
                                    String content = commentObject.get("content").getAsString();

                                    String userName = commentObject.get("user_name").getAsString();
                                    String userImage;
                                    if (!commentObject.get("user_image").isJsonNull())
                                        userImage = commentObject.get("user_image").getAsString();
                                    else
                                        userImage = "";
                                    CommentListModel listItem = new CommentListModel("", "", "",
                                            "", userName, createdTime, content, userImage, "",
                                            "", null, "", null, "", "", "", false);
                                    list.add(listItem);
                                }
                                if (list.size() > 0) {
                                    adapter = new CustomListAdapter(AppDetailActivity.this, list);
                                    lstAppCommentList.setAdapter(adapter);
                                }
                            }
                        });
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * ----------------------------------------------------------------------------------
     * Class Name : CustomListAdapter
     * Description : List adapter for user comments
     * Date of Creation : 15/04/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * 15/04/15    Bhadresh       Created full Method
     * -----------------------------------------------------------------------------------
     */
    public class CustomListAdapter extends BaseAdapter {

        private Bitmap userImage;
        private Activity activity;
        private LayoutInflater inflater;
        private List<CommentListModel> listItems;

        public CustomListAdapter(Activity activity, List<CommentListModel> movieItems) {
            this.activity = activity;
            this.listItems = movieItems;
            displayOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon).showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
        }

        @Override
        public int getCount() {
            return listItems.size();
        }

        @Override
        public Object getItem(int location) {
            return listItems.get(location);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            if (inflater == null)
                inflater = (LayoutInflater) activity
                        .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            if (convertView == null)
                convertView = inflater.inflate(R.layout.list_item_activity_user_profile, null);

            TextView name = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_name);
            TextView comments = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_comments);
            TextView time = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_time);
            ImageView image = (ImageView) convertView.findViewById(R.id.list_item_activity_user_profile_img_profile);
//            Picasso.with(getApplicationContext()).load(listItems.get(position).getIcons()).error(R.drawable.default_user_icon).placeholder(R.drawable.default_user_icon).into(image);
            ImageLoader.getInstance().displayImage(listItems.get(position).getIcons(), image,
                    displayOptions);
            //image.setImageUrl(m.getThumbnailUrl(), imageLoader);

            // title
            name.setText(listItems.get(position).getName());
            comments.setText(listItems.get(position).getComment());
            logger.debug(LOG_TAG, "Time Stemp : " + listItems.get(position).getTime());
            time.setText(AppConstants.getTimeTwitter(Long.parseLong(listItems.get(position).getTime())));
            return convertView;
        }
    }

}
