/*
 * Decompiled with CFR 0.152.
 */
package in.wilsonl.minifyhtml;

import in.wilsonl.minifyhtml.Configuration;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class MinifyHtml {
    private MinifyHtml() {
    }

    public static native String minify(String var0, Configuration var1);

    static {
        String nativeLibNameArch;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String nativeLibNameOs = osName.startsWith("windows") ? "windows" : (osName.startsWith("linux") ? "linux" : (osName.startsWith("mac") ? "macos" : null));
        String string = nativeLibNameArch = osArch.equals("amd64") || osArch.equals("x86_64") ? "x86_64" : null;
        if (nativeLibNameOs == null || nativeLibNameArch == null) {
            throw new RuntimeException(String.format("Platform not supported (os.name=%s, os.arch=%s)", osName, osArch));
        }
        String nativeLibFile = String.format("/%s-%s.nativelib", nativeLibNameOs, nativeLibNameArch);
        try (InputStream is = MinifyHtml.class.getResourceAsStream(nativeLibFile);){
            File temp = File.createTempFile("minify-html-java-nativelib", nativeLibFile.substring(1));
            temp.deleteOnExit();
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(temp.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load native library", e);
        }
    }
}

