/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.aggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CardinalityAggregator
extends DruidAggregator {
    private static final String CARDINALITY_AGGREGATOR_TYPE = "cardinality";
    private List<String> fields;
    private Boolean byRow;

    private CardinalityAggregator(@NonNull String name, @NonNull List<String> fields, Boolean byRow) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        this.type = CARDINALITY_AGGREGATOR_TYPE;
        this.name = name;
        this.fields = fields;
        this.byRow = byRow;
    }

    public static CardinalityAggregatorBuilder builder() {
        return new CardinalityAggregatorBuilder();
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Boolean getByRow() {
        return this.byRow;
    }

    public static class CardinalityAggregatorBuilder {
        private String name;
        private List<String> fields;
        private Boolean byRow;

        CardinalityAggregatorBuilder() {
        }

        public CardinalityAggregatorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CardinalityAggregatorBuilder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CardinalityAggregatorBuilder byRow(Boolean byRow) {
            this.byRow = byRow;
            return this;
        }

        public CardinalityAggregator build() {
            return new CardinalityAggregator(this.name, this.fields, this.byRow);
        }

        public String toString() {
            return "CardinalityAggregator.CardinalityAggregatorBuilder(name=" + this.name + ", fields=" + this.fields + ", byRow=" + this.byRow + ")";
        }
    }
}

