/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.filter;

import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.filter.searchQuerySpec.SearchQuerySpec;
import lombok.NonNull;

public class SearchFilter
extends DruidFilter {
    private static String SEARCH_DRUID_FILTER_TYPE = "search";
    private String dimension;
    private SearchQuerySpec query;

    private SearchFilter(@NonNull String dimension, @NonNull SearchQuerySpec searchQuerySpec) {
        if (dimension == null) {
            throw new NullPointerException("dimension");
        }
        if (searchQuerySpec == null) {
            throw new NullPointerException("searchQuerySpec");
        }
        this.type = SEARCH_DRUID_FILTER_TYPE;
        this.dimension = dimension;
        this.query = searchQuerySpec;
    }

    public static SearchFilterBuilder builder() {
        return new SearchFilterBuilder();
    }

    public String getDimension() {
        return this.dimension;
    }

    public SearchQuerySpec getQuery() {
        return this.query;
    }

    public static class SearchFilterBuilder {
        private String dimension;
        private SearchQuerySpec searchQuerySpec;

        SearchFilterBuilder() {
        }

        public SearchFilterBuilder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public SearchFilterBuilder searchQuerySpec(SearchQuerySpec searchQuerySpec) {
            this.searchQuerySpec = searchQuerySpec;
            return this;
        }

        public SearchFilter build() {
            return new SearchFilter(this.dimension, this.searchQuerySpec);
        }

        public String toString() {
            return "SearchFilter.SearchFilterBuilder(dimension=" + this.dimension + ", searchQuerySpec=" + this.searchQuerySpec + ")";
        }
    }
}

