/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.client;

import in.zapr.druid.druidry.client.DruidQueryProtocol;
import org.apache.commons.lang3.StringUtils;

public class DruidConfiguration {
    private static final int DEFAULT_HTTP_PORT = 8082;
    private static final int DEFAULT_HTTPS_PORT = 8282;
    private DruidQueryProtocol protocol;
    private String host;
    private Integer port;
    private String endpoint;
    private Integer concurrentConnectionsRequired;

    private DruidConfiguration(DruidQueryProtocol protocol, String host, Integer port, String endpoint, Integer concurrentConnectionsRequired) {
        if (StringUtils.isEmpty(host)) {
            throw new IllegalArgumentException("Host cannot be null or empty");
        }
        if (port != null && port < 0) {
            throw new IllegalArgumentException("Port cannot be negative");
        }
        if (concurrentConnectionsRequired != null && concurrentConnectionsRequired < 1) {
            throw new IllegalArgumentException("Connections required cannot be less than 1");
        }
        if (protocol == null) {
            protocol = DruidQueryProtocol.HTTP;
        }
        if (port == null) {
            port = this.getDefaultPortOnBasisOfProtocol(protocol);
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.endpoint = endpoint;
        this.concurrentConnectionsRequired = concurrentConnectionsRequired;
    }

    protected String getUrl() {
        String endpoint = this.getEndpoint();
        if (endpoint == null) {
            endpoint = "";
        }
        return String.format("%s://%s:%d/%s", new Object[]{this.getProtocol(), this.getHost(), this.getPort(), endpoint});
    }

    private Integer getDefaultPortOnBasisOfProtocol(DruidQueryProtocol protocol) {
        switch (protocol) {
            case HTTP: {
                return 8082;
            }
            case HTTPS: {
                return 8282;
            }
        }
        throw new IllegalArgumentException("Druid Query Protocol not handled");
    }

    public static DruidConfigurationBuilder builder() {
        return new DruidConfigurationBuilder();
    }

    public DruidQueryProtocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Integer getConcurrentConnectionsRequired() {
        return this.concurrentConnectionsRequired;
    }

    public void setProtocol(DruidQueryProtocol protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setConcurrentConnectionsRequired(Integer concurrentConnectionsRequired) {
        this.concurrentConnectionsRequired = concurrentConnectionsRequired;
    }

    public static class DruidConfigurationBuilder {
        private DruidQueryProtocol protocol;
        private String host;
        private Integer port;
        private String endpoint;
        private Integer concurrentConnectionsRequired;

        DruidConfigurationBuilder() {
        }

        public DruidConfigurationBuilder protocol(DruidQueryProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public DruidConfigurationBuilder host(String host) {
            this.host = host;
            return this;
        }

        public DruidConfigurationBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public DruidConfigurationBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public DruidConfigurationBuilder concurrentConnectionsRequired(Integer concurrentConnectionsRequired) {
            this.concurrentConnectionsRequired = concurrentConnectionsRequired;
            return this;
        }

        public DruidConfiguration build() {
            return new DruidConfiguration(this.protocol, this.host, this.port, this.endpoint, this.concurrentConnectionsRequired);
        }

        public String toString() {
            return "DruidConfiguration.DruidConfigurationBuilder(protocol=" + (Object)((Object)this.protocol) + ", host=" + this.host + ", port=" + this.port + ", endpoint=" + this.endpoint + ", concurrentConnectionsRequired=" + this.concurrentConnectionsRequired + ")";
        }
    }
}

