/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dimension;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import in.zapr.druid.druidry.dimension.DimensionSpec;
import in.zapr.druid.druidry.dimension.enums.OutputType;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExtractionDimension
extends DimensionSpec {
    private static final String EXTRACTION_TYPE = "extraction";
    @JsonProperty(value="extractionFn")
    private ExtractionFunction extractionFunction;

    public ExtractionDimension(@NonNull String dimension, @NonNull String outputName, OutputType outputType, @NonNull ExtractionFunction extractionFunction) {
        if (dimension == null) {
            throw new NullPointerException("dimension");
        }
        if (outputName == null) {
            throw new NullPointerException("outputName");
        }
        if (extractionFunction == null) {
            throw new NullPointerException("extractionFunction");
        }
        this.type = EXTRACTION_TYPE;
        this.dimension = dimension;
        this.outputName = outputName;
        this.outputType = outputType;
        this.extractionFunction = extractionFunction;
    }

    public static ExtractionDimensionBuilder builder() {
        return new ExtractionDimensionBuilder();
    }

    public ExtractionFunction getExtractionFunction() {
        return this.extractionFunction;
    }

    public static class ExtractionDimensionBuilder {
        private String dimension;
        private String outputName;
        private OutputType outputType;
        private ExtractionFunction extractionFunction;

        ExtractionDimensionBuilder() {
        }

        public ExtractionDimensionBuilder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public ExtractionDimensionBuilder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public ExtractionDimensionBuilder outputType(OutputType outputType) {
            this.outputType = outputType;
            return this;
        }

        public ExtractionDimensionBuilder extractionFunction(ExtractionFunction extractionFunction) {
            this.extractionFunction = extractionFunction;
            return this;
        }

        public ExtractionDimension build() {
            return new ExtractionDimension(this.dimension, this.outputName, this.outputType, this.extractionFunction);
        }

        public String toString() {
            return "ExtractionDimension.ExtractionDimensionBuilder(dimension=" + this.dimension + ", outputName=" + this.outputName + ", outputType=" + (Object)((Object)this.outputType) + ", extractionFunction=" + this.extractionFunction + ")";
        }
    }
}

