/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.granularity;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.granularity.Granularity;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PeriodGranularity
extends Granularity {
    private static final String PERIOD_GRANULARITY_TYPE = "period";
    private static final String DEFAULT_TIMEZONE = "UTC";
    private final String type = "period";
    private String period;
    private DateTimeZone timeZone;
    private DateTime origin;

    public String getOrigin() {
        return this.origin == null ? null : this.origin.toDateTimeISO().toString();
    }

    public String getTimeZone() {
        return this.timeZone == null ? DEFAULT_TIMEZONE : this.timeZone.getID();
    }

    PeriodGranularity(String period, DateTimeZone timeZone, DateTime origin) {
        this.period = period;
        this.timeZone = timeZone;
        this.origin = origin;
    }

    public static PeriodGranularityBuilder builder() {
        return new PeriodGranularityBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getPeriod() {
        return this.period;
    }

    public static class PeriodGranularityBuilder {
        private String period;
        private DateTimeZone timeZone;
        private DateTime origin;

        PeriodGranularityBuilder() {
        }

        public PeriodGranularityBuilder period(String period) {
            this.period = period;
            return this;
        }

        public PeriodGranularityBuilder timeZone(DateTimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public PeriodGranularityBuilder origin(DateTime origin) {
            this.origin = origin;
            return this;
        }

        public PeriodGranularity build() {
            return new PeriodGranularity(this.period, this.timeZone, this.origin);
        }

        public String toString() {
            return "PeriodGranularity.PeriodGranularityBuilder(period=" + this.period + ", timeZone=" + this.timeZone + ", origin=" + this.origin + ")";
        }
    }
}

