/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.Context;
import in.zapr.druid.druidry.Interval;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.aggregation.DruidAggregationQuery;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidTimeSeriesQuery
extends DruidAggregationQuery {
    private Boolean descending;

    private DruidTimeSeriesQuery(@NonNull String dataSource, Boolean descending, @NonNull List<Interval> intervals, @NonNull Granularity granularity, DruidFilter filter, List<DruidAggregator> aggregators, List<DruidPostAggregator> postAggregators, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity");
        }
        this.queryType = QueryType.TIMESERIES;
        this.dataSource = dataSource;
        this.descending = descending;
        this.intervals = intervals;
        this.granularity = granularity;
        this.filter = filter;
        this.aggregations = aggregators;
        this.postAggregations = postAggregators;
        this.context = context;
    }

    public static DruidTimeSeriesQueryBuilder builder() {
        return new DruidTimeSeriesQueryBuilder();
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public static class DruidTimeSeriesQueryBuilder {
        private String dataSource;
        private Boolean descending;
        private List<Interval> intervals;
        private Granularity granularity;
        private DruidFilter filter;
        private List<DruidAggregator> aggregators;
        private List<DruidPostAggregator> postAggregators;
        private Context context;

        DruidTimeSeriesQueryBuilder() {
        }

        public DruidTimeSeriesQueryBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DruidTimeSeriesQueryBuilder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public DruidTimeSeriesQueryBuilder intervals(List<Interval> intervals) {
            this.intervals = intervals;
            return this;
        }

        public DruidTimeSeriesQueryBuilder granularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public DruidTimeSeriesQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidTimeSeriesQueryBuilder aggregators(List<DruidAggregator> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public DruidTimeSeriesQueryBuilder postAggregators(List<DruidPostAggregator> postAggregators) {
            this.postAggregators = postAggregators;
            return this;
        }

        public DruidTimeSeriesQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidTimeSeriesQuery build() {
            return new DruidTimeSeriesQuery(this.dataSource, this.descending, this.intervals, this.granularity, this.filter, this.aggregators, this.postAggregators, this.context);
        }

        public String toString() {
            return "DruidTimeSeriesQuery.DruidTimeSeriesQueryBuilder(dataSource=" + this.dataSource + ", descending=" + this.descending + ", intervals=" + this.intervals + ", granularity=" + this.granularity + ", filter=" + this.filter + ", aggregators=" + this.aggregators + ", postAggregators=" + this.postAggregators + ", context=" + this.context + ")";
        }
    }
}

