/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.DateTime;

public class Interval {
    private static final String DRUID_INTERVAL_FORMAT = "%s/%s";
    private DateTime startTime;
    private DateTime endTime;

    public Interval(@NonNull DateTime startTime, @NonNull DateTime endTime) {
        if (startTime == null) {
            throw new NullPointerException("startTime");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime");
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @JsonValue
    private String getIntervalAsString() {
        return String.format(DRUID_INTERVAL_FORMAT, this.startTime.toDateTimeISO(), this.endTime.toDateTimeISO());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this == other) {
            return true;
        }
        return new EqualsBuilder().append((Object)this.startTime, (Object)other.startTime).append((Object)this.endTime, (Object)other.endTime).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.startTime).append((Object)this.endTime).toHashCode();
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }
}

