/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extractionFunctions;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import in.zapr.druid.druidry.granularity.Granularity;
import java.text.SimpleDateFormat;
import java.util.Locale;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TimeFormatExtractionFunction
extends ExtractionFunction {
    private SimpleDateFormat format;
    private Locale locale;
    private Granularity granularity;
    private Boolean asMillis;
    private String timeZone;

    private TimeFormatExtractionFunction(SimpleDateFormat format, Locale locale, Granularity granularity, String timeZone, Boolean asMillis) {
        this.type = "timeFormat";
        this.format = format;
        this.locale = locale;
        this.granularity = granularity;
        this.timeZone = timeZone;
        this.asMillis = asMillis;
    }

    public String getLocale() {
        return this.locale == null ? null : this.locale.toLanguageTag();
    }

    public String getFormat() {
        return this.format == null ? null : this.format.toPattern();
    }

    public static TimeFormatExtractionFunctionBuilder builder() {
        return new TimeFormatExtractionFunctionBuilder();
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public Boolean getAsMillis() {
        return this.asMillis;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public static class TimeFormatExtractionFunctionBuilder {
        private SimpleDateFormat format;
        private Locale locale;
        private Granularity granularity;
        private String timeZone;
        private Boolean asMillis;

        TimeFormatExtractionFunctionBuilder() {
        }

        public TimeFormatExtractionFunctionBuilder format(SimpleDateFormat format) {
            this.format = format;
            return this;
        }

        public TimeFormatExtractionFunctionBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public TimeFormatExtractionFunctionBuilder granularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public TimeFormatExtractionFunctionBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public TimeFormatExtractionFunctionBuilder asMillis(Boolean asMillis) {
            this.asMillis = asMillis;
            return this;
        }

        public TimeFormatExtractionFunction build() {
            return new TimeFormatExtractionFunction(this.format, this.locale, this.granularity, this.timeZone, this.asMillis);
        }

        public String toString() {
            return "TimeFormatExtractionFunction.TimeFormatExtractionFunctionBuilder(format=" + this.format + ", locale=" + this.locale + ", granularity=" + this.granularity + ", timeZone=" + this.timeZone + ", asMillis=" + this.asMillis + ")";
        }
    }
}

