/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dimension;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.dimension.DimensionSpec;
import in.zapr.druid.druidry.dimension.enums.OutputType;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DefaultDimension
extends DimensionSpec {
    private static final String DEFAULT_TYPE = "default";

    public DefaultDimension(@NonNull String dimension, @NonNull String outputName, OutputType outputType) {
        if (dimension == null) {
            throw new NullPointerException("dimension");
        }
        if (outputName == null) {
            throw new NullPointerException("outputName");
        }
        this.type = DEFAULT_TYPE;
        this.dimension = dimension;
        this.outputName = outputName;
        this.outputType = outputType;
    }

    public static DefaultDimensionBuilder builder() {
        return new DefaultDimensionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultDimension)) {
            return false;
        }
        DefaultDimension other = (DefaultDimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DefaultDimension;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public static class DefaultDimensionBuilder {
        private String dimension;
        private String outputName;
        private OutputType outputType;

        DefaultDimensionBuilder() {
        }

        public DefaultDimensionBuilder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public DefaultDimensionBuilder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public DefaultDimensionBuilder outputType(OutputType outputType) {
            this.outputType = outputType;
            return this;
        }

        public DefaultDimension build() {
            return new DefaultDimension(this.dimension, this.outputName, this.outputType);
        }

        public String toString() {
            return "DefaultDimension.DefaultDimensionBuilder(dimension=" + this.dimension + ", outputName=" + this.outputName + ", outputType=" + (Object)((Object)this.outputType) + ")";
        }
    }
}

