/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extensions.datasketches.aggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ThetaSketchAggregator
extends DruidAggregator {
    private static final String THETA_SKETCH_TYPE_AGGREGATOR = "thetaSketch";
    private String fieldName;
    private Boolean isInputThetaSketch;
    private Long size;

    public ThetaSketchAggregator(@NonNull String name, @NonNull String fieldName, Boolean isInputThetaSketch, Long size) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        this.type = THETA_SKETCH_TYPE_AGGREGATOR;
        this.name = name;
        this.fieldName = fieldName;
        this.isInputThetaSketch = isInputThetaSketch;
        this.size = size;
        if (size != null) {
            Preconditions.checkArgument((boolean)LongMath.isPowerOfTwo((long)size), (Object)"size must be a power of 2");
        }
    }

    public static ThetaSketchAggregatorBuilder builder() {
        return new ThetaSketchAggregatorBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Boolean getIsInputThetaSketch() {
        return this.isInputThetaSketch;
    }

    public Long getSize() {
        return this.size;
    }

    public static class ThetaSketchAggregatorBuilder {
        private String name;
        private String fieldName;
        private Boolean isInputThetaSketch;
        private Long size;

        ThetaSketchAggregatorBuilder() {
        }

        public ThetaSketchAggregatorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThetaSketchAggregatorBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public ThetaSketchAggregatorBuilder isInputThetaSketch(Boolean isInputThetaSketch) {
            this.isInputThetaSketch = isInputThetaSketch;
            return this;
        }

        public ThetaSketchAggregatorBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public ThetaSketchAggregator build() {
            return new ThetaSketchAggregator(this.name, this.fieldName, this.isInputThetaSketch, this.size);
        }

        public String toString() {
            return "ThetaSketchAggregator.ThetaSketchAggregatorBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", isInputThetaSketch=" + this.isInputThetaSketch + ", size=" + this.size + ")";
        }
    }
}

