/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extractionFunctions;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegexExtractionFunction
extends ExtractionFunction {
    private String expr;
    private Boolean replaceMissingValue;
    private String replaceMissingValueWith;

    private RegexExtractionFunction(@NonNull String expr, Boolean replaceMissingValue, String replaceMissingValueWith) {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        this.type = "regex";
        this.expr = expr;
        this.replaceMissingValue = replaceMissingValue;
        this.replaceMissingValueWith = replaceMissingValueWith;
    }

    public static RegexExtractionFunctionBuilder builder() {
        return new RegexExtractionFunctionBuilder();
    }

    public String getExpr() {
        return this.expr;
    }

    public Boolean getReplaceMissingValue() {
        return this.replaceMissingValue;
    }

    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    public static class RegexExtractionFunctionBuilder {
        private String expr;
        private Boolean replaceMissingValue;
        private String replaceMissingValueWith;

        RegexExtractionFunctionBuilder() {
        }

        public RegexExtractionFunctionBuilder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public RegexExtractionFunctionBuilder replaceMissingValue(Boolean replaceMissingValue) {
            this.replaceMissingValue = replaceMissingValue;
            return this;
        }

        public RegexExtractionFunctionBuilder replaceMissingValueWith(String replaceMissingValueWith) {
            this.replaceMissingValueWith = replaceMissingValueWith;
            return this;
        }

        public RegexExtractionFunction build() {
            return new RegexExtractionFunction(this.expr, this.replaceMissingValue, this.replaceMissingValueWith);
        }

        public String toString() {
            return "RegexExtractionFunction.RegexExtractionFunctionBuilder(expr=" + this.expr + ", replaceMissingValue=" + this.replaceMissingValue + ", replaceMissingValueWith=" + this.replaceMissingValueWith + ")";
        }
    }
}

