/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.filter;

import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.filter.searchQuerySpec.SearchQuerySpec;
import lombok.NonNull;

public class SearchFilter
extends DruidFilter {
    private static String SEARCH_DRUID_FILTER_TYPE = "search";
    private String dimension;
    private SearchQuerySpec query;

    private SearchFilter(@NonNull String dimension, @NonNull SearchQuerySpec searchQuerySpec) {
        if (dimension == null) {
            throw new NullPointerException("dimension");
        }
        if (searchQuerySpec == null) {
            throw new NullPointerException("searchQuerySpec");
        }
        this.type = SEARCH_DRUID_FILTER_TYPE;
        this.dimension = dimension;
        this.query = searchQuerySpec;
    }

    public static SearchFilterBuilder builder() {
        return new SearchFilterBuilder();
    }

    public String getDimension() {
        return this.dimension;
    }

    public SearchQuerySpec getQuery() {
        return this.query;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchFilter)) {
            return false;
        }
        SearchFilter other = (SearchFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        SearchQuerySpec this$query = this.getQuery();
        SearchQuerySpec other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SearchFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        SearchQuerySpec $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public static class SearchFilterBuilder {
        private String dimension;
        private SearchQuerySpec searchQuerySpec;

        SearchFilterBuilder() {
        }

        public SearchFilterBuilder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public SearchFilterBuilder searchQuerySpec(SearchQuerySpec searchQuerySpec) {
            this.searchQuerySpec = searchQuerySpec;
            return this;
        }

        public SearchFilter build() {
            return new SearchFilter(this.dimension, this.searchQuerySpec);
        }

        public String toString() {
            return "SearchFilter.SearchFilterBuilder(dimension=" + this.dimension + ", searchQuerySpec=" + this.searchQuerySpec + ")";
        }
    }
}

