/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.Context;
import in.zapr.druid.druidry.Interval;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import in.zapr.druid.druidry.dimension.DruidDimension;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.limitSpec.DefaultLimitSpec;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.aggregation.DruidAggregationQuery;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidGroupByQuery
extends DruidAggregationQuery {
    private DefaultLimitSpec limitSpec;
    private String having;
    @NonNull
    private List<DruidDimension> dimensions;

    private DruidGroupByQuery(@NonNull String dataSource, @NonNull List<DruidDimension> dimensions, DefaultLimitSpec limitSpec, @NonNull Granularity granularity, DruidFilter filter, List<DruidAggregator> aggregators, List<DruidPostAggregator> postAggregators, @NonNull List<Interval> intervals, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (dimensions == null) {
            throw new NullPointerException("dimensions");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals");
        }
        this.queryType = QueryType.GROUP_BY;
        this.dataSource = dataSource;
        this.dimensions = dimensions;
        this.limitSpec = limitSpec;
        this.granularity = granularity;
        this.filter = filter;
        this.aggregations = aggregators;
        this.postAggregations = postAggregators;
        this.intervals = intervals;
        this.context = context;
    }

    public static DruidGroupByQueryBuilder builder() {
        return new DruidGroupByQueryBuilder();
    }

    public DefaultLimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    public String getHaving() {
        return this.having;
    }

    @NonNull
    public List<DruidDimension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidGroupByQuery)) {
            return false;
        }
        DruidGroupByQuery other = (DruidGroupByQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultLimitSpec this$limitSpec = this.getLimitSpec();
        DefaultLimitSpec other$limitSpec = other.getLimitSpec();
        if (this$limitSpec == null ? other$limitSpec != null : !((Object)this$limitSpec).equals(other$limitSpec)) {
            return false;
        }
        String this$having = this.getHaving();
        String other$having = other.getHaving();
        if (this$having == null ? other$having != null : !this$having.equals(other$having)) {
            return false;
        }
        List<DruidDimension> this$dimensions = this.getDimensions();
        List<DruidDimension> other$dimensions = other.getDimensions();
        return !(this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidGroupByQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        DefaultLimitSpec $limitSpec = this.getLimitSpec();
        result = result * 59 + ($limitSpec == null ? 43 : ((Object)$limitSpec).hashCode());
        String $having = this.getHaving();
        result = result * 59 + ($having == null ? 43 : $having.hashCode());
        List<DruidDimension> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        return result;
    }

    public static class DruidGroupByQueryBuilder {
        private String dataSource;
        private List<DruidDimension> dimensions;
        private DefaultLimitSpec limitSpec;
        private Granularity granularity;
        private DruidFilter filter;
        private List<DruidAggregator> aggregators;
        private List<DruidPostAggregator> postAggregators;
        private List<Interval> intervals;
        private Context context;

        DruidGroupByQueryBuilder() {
        }

        public DruidGroupByQueryBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DruidGroupByQueryBuilder dimensions(List<DruidDimension> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public DruidGroupByQueryBuilder limitSpec(DefaultLimitSpec limitSpec) {
            this.limitSpec = limitSpec;
            return this;
        }

        public DruidGroupByQueryBuilder granularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public DruidGroupByQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidGroupByQueryBuilder aggregators(List<DruidAggregator> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public DruidGroupByQueryBuilder postAggregators(List<DruidPostAggregator> postAggregators) {
            this.postAggregators = postAggregators;
            return this;
        }

        public DruidGroupByQueryBuilder intervals(List<Interval> intervals) {
            this.intervals = intervals;
            return this;
        }

        public DruidGroupByQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidGroupByQuery build() {
            return new DruidGroupByQuery(this.dataSource, this.dimensions, this.limitSpec, this.granularity, this.filter, this.aggregators, this.postAggregators, this.intervals, this.context);
        }

        public String toString() {
            return "DruidGroupByQuery.DruidGroupByQueryBuilder(dataSource=" + this.dataSource + ", dimensions=" + this.dimensions + ", limitSpec=" + this.limitSpec + ", granularity=" + this.granularity + ", filter=" + this.filter + ", aggregators=" + this.aggregators + ", postAggregators=" + this.postAggregators + ", intervals=" + this.intervals + ", context=" + this.context + ")";
        }
    }
}

