/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import in.zapr.druid.druidry.Context;
import in.zapr.druid.druidry.Interval;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import in.zapr.druid.druidry.dimension.DruidDimension;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.aggregation.DruidAggregationQuery;
import in.zapr.druid.druidry.topNMetric.TopNMetric;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidTopNQuery
extends DruidAggregationQuery {
    private DruidDimension dimension;
    private Integer threshold;
    private TopNMetric metric;

    private DruidTopNQuery(@NonNull String dataSource, @NonNull List<Interval> intervals, @NonNull Granularity granularity, DruidFilter filter, List<DruidAggregator> aggregators, List<DruidPostAggregator> postAggregators, @NonNull DruidDimension dimension, @NonNull Integer threshold, @NonNull TopNMetric topNMetric, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity");
        }
        if (dimension == null) {
            throw new NullPointerException("dimension");
        }
        if (threshold == null) {
            throw new NullPointerException("threshold");
        }
        if (topNMetric == null) {
            throw new NullPointerException("topNMetric");
        }
        this.queryType = QueryType.TOPN;
        this.dataSource = dataSource;
        this.intervals = intervals;
        this.granularity = granularity;
        this.filter = filter;
        this.aggregations = aggregators;
        this.postAggregations = postAggregators;
        this.dimension = dimension;
        this.threshold = threshold;
        this.metric = topNMetric;
        this.context = context;
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0, (Object)"threshold must be greater than 0");
    }

    public static DruidTopNQueryBuilder builder() {
        return new DruidTopNQueryBuilder();
    }

    public DruidDimension getDimension() {
        return this.dimension;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public TopNMetric getMetric() {
        return this.metric;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidTopNQuery)) {
            return false;
        }
        DruidTopNQuery other = (DruidTopNQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DruidDimension this$dimension = this.getDimension();
        DruidDimension other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$threshold = this.getThreshold();
        Integer other$threshold = other.getThreshold();
        if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
            return false;
        }
        TopNMetric this$metric = this.getMetric();
        TopNMetric other$metric = other.getMetric();
        return !(this$metric == null ? other$metric != null : !this$metric.equals(other$metric));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidTopNQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        DruidDimension $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $threshold = this.getThreshold();
        result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
        TopNMetric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        return result;
    }

    public static class DruidTopNQueryBuilder {
        private String dataSource;
        private List<Interval> intervals;
        private Granularity granularity;
        private DruidFilter filter;
        private List<DruidAggregator> aggregators;
        private List<DruidPostAggregator> postAggregators;
        private DruidDimension dimension;
        private Integer threshold;
        private TopNMetric topNMetric;
        private Context context;

        DruidTopNQueryBuilder() {
        }

        public DruidTopNQueryBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DruidTopNQueryBuilder intervals(List<Interval> intervals) {
            this.intervals = intervals;
            return this;
        }

        public DruidTopNQueryBuilder granularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public DruidTopNQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidTopNQueryBuilder aggregators(List<DruidAggregator> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public DruidTopNQueryBuilder postAggregators(List<DruidPostAggregator> postAggregators) {
            this.postAggregators = postAggregators;
            return this;
        }

        public DruidTopNQueryBuilder dimension(DruidDimension dimension) {
            this.dimension = dimension;
            return this;
        }

        public DruidTopNQueryBuilder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        public DruidTopNQueryBuilder topNMetric(TopNMetric topNMetric) {
            this.topNMetric = topNMetric;
            return this;
        }

        public DruidTopNQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidTopNQuery build() {
            return new DruidTopNQuery(this.dataSource, this.intervals, this.granularity, this.filter, this.aggregators, this.postAggregators, this.dimension, this.threshold, this.topNMetric, this.context);
        }

        public String toString() {
            return "DruidTopNQuery.DruidTopNQueryBuilder(dataSource=" + this.dataSource + ", intervals=" + this.intervals + ", granularity=" + this.granularity + ", filter=" + this.filter + ", aggregators=" + this.aggregators + ", postAggregators=" + this.postAggregators + ", dimension=" + this.dimension + ", threshold=" + this.threshold + ", topNMetric=" + this.topNMetric + ", context=" + this.context + ")";
        }
    }
}

