/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.search;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.Context;
import in.zapr.druid.druidry.Interval;
import in.zapr.druid.druidry.SortingOrder;
import in.zapr.druid.druidry.dimension.DruidDimension;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.filter.searchQuerySpec.SearchQuerySpec;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.query.DruidQuery;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.search.SearchSortSpec;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidSearchQuery
extends DruidQuery {
    private Granularity granularity;
    private DruidFilter filter;
    private Integer limit;
    private List<Interval> intervals;
    private List<DruidDimension> searchDimensions;
    private SearchQuerySpec query;
    private SearchSortSpec sort;

    private DruidSearchQuery(@NonNull String dataSource, @NonNull Granularity granularity, DruidFilter filter, Integer limit, @NonNull List<Interval> intervals, List<DruidDimension> searchDimensions, @NonNull SearchQuerySpec query, SortingOrder sort, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals");
        }
        if (query == null) {
            throw new NullPointerException("query");
        }
        this.queryType = QueryType.SEARCH;
        this.dataSource = dataSource;
        this.granularity = granularity;
        this.filter = filter;
        this.limit = limit;
        this.intervals = intervals;
        this.searchDimensions = searchDimensions;
        this.query = query;
        if (sort != null) {
            this.sort = new SearchSortSpec(sort);
        }
        this.context = context;
    }

    public static DruidSearchQueryBuilder builder() {
        return new DruidSearchQueryBuilder();
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public DruidFilter getFilter() {
        return this.filter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public List<DruidDimension> getSearchDimensions() {
        return this.searchDimensions;
    }

    public SearchQuerySpec getQuery() {
        return this.query;
    }

    public SearchSortSpec getSort() {
        return this.sort;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidSearchQuery)) {
            return false;
        }
        DruidSearchQuery other = (DruidSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Granularity this$granularity = this.getGranularity();
        Granularity other$granularity = other.getGranularity();
        if (this$granularity == null ? other$granularity != null : !((Object)this$granularity).equals(other$granularity)) {
            return false;
        }
        DruidFilter this$filter = this.getFilter();
        DruidFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        List<Interval> this$intervals = this.getIntervals();
        List<Interval> other$intervals = other.getIntervals();
        if (this$intervals == null ? other$intervals != null : !((Object)this$intervals).equals(other$intervals)) {
            return false;
        }
        List<DruidDimension> this$searchDimensions = this.getSearchDimensions();
        List<DruidDimension> other$searchDimensions = other.getSearchDimensions();
        if (this$searchDimensions == null ? other$searchDimensions != null : !((Object)this$searchDimensions).equals(other$searchDimensions)) {
            return false;
        }
        SearchQuerySpec this$query = this.getQuery();
        SearchQuerySpec other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        SearchSortSpec this$sort = this.getSort();
        SearchSortSpec other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidSearchQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Granularity $granularity = this.getGranularity();
        result = result * 59 + ($granularity == null ? 43 : ((Object)$granularity).hashCode());
        DruidFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        List<Interval> $intervals = this.getIntervals();
        result = result * 59 + ($intervals == null ? 43 : ((Object)$intervals).hashCode());
        List<DruidDimension> $searchDimensions = this.getSearchDimensions();
        result = result * 59 + ($searchDimensions == null ? 43 : ((Object)$searchDimensions).hashCode());
        SearchQuerySpec $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        SearchSortSpec $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        return result;
    }

    public static class DruidSearchQueryBuilder {
        private String dataSource;
        private Granularity granularity;
        private DruidFilter filter;
        private Integer limit;
        private List<Interval> intervals;
        private List<DruidDimension> searchDimensions;
        private SearchQuerySpec query;
        private SortingOrder sort;
        private Context context;

        DruidSearchQueryBuilder() {
        }

        public DruidSearchQueryBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DruidSearchQueryBuilder granularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public DruidSearchQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidSearchQueryBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public DruidSearchQueryBuilder intervals(List<Interval> intervals) {
            this.intervals = intervals;
            return this;
        }

        public DruidSearchQueryBuilder searchDimensions(List<DruidDimension> searchDimensions) {
            this.searchDimensions = searchDimensions;
            return this;
        }

        public DruidSearchQueryBuilder query(SearchQuerySpec query) {
            this.query = query;
            return this;
        }

        public DruidSearchQueryBuilder sort(SortingOrder sort) {
            this.sort = sort;
            return this;
        }

        public DruidSearchQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidSearchQuery build() {
            return new DruidSearchQuery(this.dataSource, this.granularity, this.filter, this.limit, this.intervals, this.searchDimensions, this.query, this.sort, this.context);
        }

        public String toString() {
            return "DruidSearchQuery.DruidSearchQueryBuilder(dataSource=" + this.dataSource + ", granularity=" + this.granularity + ", filter=" + this.filter + ", limit=" + this.limit + ", intervals=" + this.intervals + ", searchDimensions=" + this.searchDimensions + ", query=" + this.query + ", sort=" + (Object)((Object)this.sort) + ", context=" + this.context + ")";
        }
    }
}

