/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.client;

import in.zapr.druid.druidry.client.DruidClient;
import in.zapr.druid.druidry.client.DruidConfiguration;
import in.zapr.druid.druidry.client.DruidError;
import in.zapr.druid.druidry.client.exception.ConnectionException;
import in.zapr.druid.druidry.client.exception.QueryException;
import in.zapr.druid.druidry.query.DruidQuery;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidJerseyClient
implements DruidClient {
    private static final Logger log = LoggerFactory.getLogger(DruidJerseyClient.class);
    private static final int DEFAULT_CONNECTION_POOL_LIMIT = 5;
    private final String druidUrl;
    private final DruidConfiguration druidConfiguration;
    private ClientConfig jerseyConfig;
    private Client client;
    private WebTarget queryWebTarget;

    public DruidJerseyClient(@NonNull DruidConfiguration druidConfiguration) {
        this(druidConfiguration, null);
        if (druidConfiguration == null) {
            throw new NullPointerException("druidConfiguration is marked non-null but is null");
        }
    }

    public DruidJerseyClient(@NonNull DruidConfiguration druidConfiguration, ClientConfig jerseyConfig) {
        if (druidConfiguration == null) {
            throw new NullPointerException("druidConfiguration is marked non-null but is null");
        }
        this.druidUrl = druidConfiguration.getUrl();
        this.jerseyConfig = jerseyConfig;
        log.debug("Will query to {}", (Object)this.druidUrl);
        this.druidConfiguration = druidConfiguration;
    }

    @Override
    public void connect() throws ConnectionException {
        try {
            if (this.jerseyConfig == null) {
                HttpClientConnectionManager connectionManager = this.createConnectionManager();
                this.jerseyConfig = new ClientConfig();
                this.jerseyConfig.property("jersey.config.apache.client.connectionManager", (Object)connectionManager);
                this.jerseyConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            }
            this.client = ClientBuilder.newClient((Configuration)this.jerseyConfig);
            this.queryWebTarget = this.client.target(this.druidUrl);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public void close() throws ConnectionException {
        try {
            if (this.client == null) {
                return;
            }
            this.client.close();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public String query(DruidQuery druidQuery) throws QueryException {
        String string;
        block10: {
            Response response = this.queryWebTarget.request(new String[]{"application/json"}).post(Entity.entity((Object)druidQuery, (String)"application/json"));
            try {
                if (response.getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    this.handleInternalServerResponse(response);
                }
                string = (String)response.readEntity(String.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (QueryException e) {
                    log.error("Exception while querying {}", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    log.error("Exception while querying {}", (Throwable)e);
                    throw new QueryException(e);
                }
            }
            response.close();
        }
        return string;
    }

    @Override
    public <T> List<T> query(DruidQuery druidQuery, Class<T> className) throws QueryException {
        List list;
        block10: {
            Response response = this.queryWebTarget.request(new String[]{"application/json"}).post(Entity.entity((Object)druidQuery, (String)"application/json"));
            try {
                if (response.getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    this.handleInternalServerResponse(response);
                }
                list = (List)response.readEntity(new GenericType<List<T>>(TypeUtils.parameterize(List.class, (Type[])new Type[]{className})){});
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (QueryException e) {
                    log.error("Exception while querying {}", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    log.error("Exception while querying {}", (Throwable)e);
                    throw new QueryException(e);
                }
            }
            response.close();
        }
        return list;
    }

    private DruidError handleInternalServerResponse(Response response) throws Exception {
        DruidError error = (DruidError)response.readEntity(DruidError.class);
        throw new QueryException(error);
    }

    private HttpClientConnectionManager createConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        int numberOfConnectionsInPool = 5;
        if (this.druidConfiguration.getConcurrentConnectionsRequired() != null) {
            numberOfConnectionsInPool = this.druidConfiguration.getConcurrentConnectionsRequired();
        }
        connectionManager.setDefaultMaxPerRoute(numberOfConnectionsInPool);
        return connectionManager;
    }
}

