/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dataSource;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.dataSource.DataSourceType;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UnionDataSource
extends DataSource {
    @NonNull
    private List<String> dataSources;

    public UnionDataSource(@NonNull List<String> dataSources) {
        if (dataSources == null) {
            throw new NullPointerException("dataSources is marked non-null but is null");
        }
        this.type = DataSourceType.UNION;
        this.dataSources = dataSources;
    }

    public static UnionDataSourceBuilder builder() {
        return new UnionDataSourceBuilder();
    }

    @NonNull
    public List<String> getDataSources() {
        return this.dataSources;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnionDataSource)) {
            return false;
        }
        UnionDataSource other = (UnionDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$dataSources = this.getDataSources();
        List<String> other$dataSources = other.getDataSources();
        return !(this$dataSources == null ? other$dataSources != null : !((Object)this$dataSources).equals(other$dataSources));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnionDataSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $dataSources = this.getDataSources();
        result = result * 59 + ($dataSources == null ? 43 : ((Object)$dataSources).hashCode());
        return result;
    }

    public static class UnionDataSourceBuilder {
        private List<String> dataSources;

        UnionDataSourceBuilder() {
        }

        public UnionDataSourceBuilder dataSources(@NonNull List<String> dataSources) {
            if (dataSources == null) {
                throw new NullPointerException("dataSources is marked non-null but is null");
            }
            this.dataSources = dataSources;
            return this;
        }

        public UnionDataSource build() {
            return new UnionDataSource(this.dataSources);
        }

        public String toString() {
            return "UnionDataSource.UnionDataSourceBuilder(dataSources=" + this.dataSources + ")";
        }
    }
}

