/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dimension;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.dimension.DimensionSpec;
import in.zapr.druid.druidry.dimension.FilteredDimension;
import in.zapr.druid.druidry.dimension.enums.FilteredDimensionType;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegexFilteredDimension
extends FilteredDimension {
    private String pattern;

    public RegexFilteredDimension(@NonNull DimensionSpec dimensionSpec, @NonNull String pattern) {
        if (dimensionSpec == null) {
            throw new NullPointerException("dimensionSpec is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        this.pattern = pattern;
        this.delegate = dimensionSpec;
        this.type = FilteredDimensionType.REGEX_FILTERED;
    }

    public static RegexFilteredDimensionBuilder builder() {
        return new RegexFilteredDimensionBuilder();
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexFilteredDimension)) {
            return false;
        }
        RegexFilteredDimension other = (RegexFilteredDimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RegexFilteredDimension;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }

    public static class RegexFilteredDimensionBuilder {
        private DimensionSpec dimensionSpec;
        private String pattern;

        RegexFilteredDimensionBuilder() {
        }

        public RegexFilteredDimensionBuilder dimensionSpec(@NonNull DimensionSpec dimensionSpec) {
            if (dimensionSpec == null) {
                throw new NullPointerException("dimensionSpec is marked non-null but is null");
            }
            this.dimensionSpec = dimensionSpec;
            return this;
        }

        public RegexFilteredDimensionBuilder pattern(@NonNull String pattern) {
            if (pattern == null) {
                throw new NullPointerException("pattern is marked non-null but is null");
            }
            this.pattern = pattern;
            return this;
        }

        public RegexFilteredDimension build() {
            return new RegexFilteredDimension(this.dimensionSpec, this.pattern);
        }

        public String toString() {
            return "RegexFilteredDimension.RegexFilteredDimensionBuilder(dimensionSpec=" + this.dimensionSpec + ", pattern=" + this.pattern + ")";
        }
    }
}

