/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extensions.datasketches.aggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ThetaSketchAggregator
extends DruidAggregator {
    private static final String THETA_SKETCH_TYPE_AGGREGATOR = "thetaSketch";
    private String fieldName;
    private Boolean isInputThetaSketch;
    private Long size;

    public ThetaSketchAggregator(@NonNull String name, @NonNull String fieldName, Boolean isInputThetaSketch, Long size) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.type = THETA_SKETCH_TYPE_AGGREGATOR;
        this.name = name;
        this.fieldName = fieldName;
        this.isInputThetaSketch = isInputThetaSketch;
        this.size = size;
        if (size != null) {
            Preconditions.checkArgument((boolean)LongMath.isPowerOfTwo((long)size), (Object)"size must be a power of 2");
        }
    }

    public static ThetaSketchAggregatorBuilder builder() {
        return new ThetaSketchAggregatorBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Boolean getIsInputThetaSketch() {
        return this.isInputThetaSketch;
    }

    public Long getSize() {
        return this.size;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThetaSketchAggregator)) {
            return false;
        }
        ThetaSketchAggregator other = (ThetaSketchAggregator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Boolean this$isInputThetaSketch = this.getIsInputThetaSketch();
        Boolean other$isInputThetaSketch = other.getIsInputThetaSketch();
        if (this$isInputThetaSketch == null ? other$isInputThetaSketch != null : !((Object)this$isInputThetaSketch).equals(other$isInputThetaSketch)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        return !(this$size == null ? other$size != null : !((Object)this$size).equals(other$size));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThetaSketchAggregator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Boolean $isInputThetaSketch = this.getIsInputThetaSketch();
        result = result * 59 + ($isInputThetaSketch == null ? 43 : ((Object)$isInputThetaSketch).hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        return result;
    }

    public static class ThetaSketchAggregatorBuilder {
        private String name;
        private String fieldName;
        private Boolean isInputThetaSketch;
        private Long size;

        ThetaSketchAggregatorBuilder() {
        }

        public ThetaSketchAggregatorBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ThetaSketchAggregatorBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public ThetaSketchAggregatorBuilder isInputThetaSketch(Boolean isInputThetaSketch) {
            this.isInputThetaSketch = isInputThetaSketch;
            return this;
        }

        public ThetaSketchAggregatorBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public ThetaSketchAggregator build() {
            return new ThetaSketchAggregator(this.name, this.fieldName, this.isInputThetaSketch, this.size);
        }

        public String toString() {
            return "ThetaSketchAggregator.ThetaSketchAggregatorBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", isInputThetaSketch=" + this.isInputThetaSketch + ", size=" + this.size + ")";
        }
    }
}

