/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extensions.histogram.postAggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QuantilePostAggregator
extends DruidPostAggregator {
    private static final String QUANTILE_POST_AGGREGATOR_TYPE = "quantile";
    private String fieldName;
    private Float probability;

    private QuantilePostAggregator(@NonNull String name, @NonNull String fieldName, @NonNull Float probability) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (probability == null) {
            throw new NullPointerException("probability is marked non-null but is null");
        }
        Preconditions.checkArgument((probability.floatValue() >= 0.0f && probability.floatValue() <= 1.0f ? 1 : 0) != 0, (Object)"Probability should lie between 0 and 1");
        this.type = QUANTILE_POST_AGGREGATOR_TYPE;
        this.name = name;
        this.fieldName = fieldName;
        this.probability = probability;
    }

    public static QuantilePostAggregatorBuilder builder() {
        return new QuantilePostAggregatorBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Float getProbability() {
        return this.probability;
    }

    public static class QuantilePostAggregatorBuilder {
        private String name;
        private String fieldName;
        private Float probability;

        QuantilePostAggregatorBuilder() {
        }

        public QuantilePostAggregatorBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public QuantilePostAggregatorBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public QuantilePostAggregatorBuilder probability(@NonNull Float probability) {
            if (probability == null) {
                throw new NullPointerException("probability is marked non-null but is null");
            }
            this.probability = probability;
            return this;
        }

        public QuantilePostAggregator build() {
            return new QuantilePostAggregator(this.name, this.fieldName, this.probability);
        }

        public String toString() {
            return "QuantilePostAggregator.QuantilePostAggregatorBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", probability=" + this.probability + ")";
        }
    }
}

