/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extractionFunctions;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import java.text.SimpleDateFormat;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TimeParsingExtractionFunction
extends ExtractionFunction {
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat resultFormat;

    private TimeParsingExtractionFunction(@NonNull SimpleDateFormat timeFormat, @NonNull SimpleDateFormat resultFormat) {
        if (timeFormat == null) {
            throw new NullPointerException("timeFormat is marked non-null but is null");
        }
        if (resultFormat == null) {
            throw new NullPointerException("resultFormat is marked non-null but is null");
        }
        this.type = "time";
        this.timeFormat = timeFormat;
        this.resultFormat = resultFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat.toPattern();
    }

    public String getResultFormat() {
        return this.resultFormat.toPattern();
    }

    public static TimeParsingExtractionFunctionBuilder builder() {
        return new TimeParsingExtractionFunctionBuilder();
    }

    public static class TimeParsingExtractionFunctionBuilder {
        private SimpleDateFormat timeFormat;
        private SimpleDateFormat resultFormat;

        TimeParsingExtractionFunctionBuilder() {
        }

        public TimeParsingExtractionFunctionBuilder timeFormat(@NonNull SimpleDateFormat timeFormat) {
            if (timeFormat == null) {
                throw new NullPointerException("timeFormat is marked non-null but is null");
            }
            this.timeFormat = timeFormat;
            return this;
        }

        public TimeParsingExtractionFunctionBuilder resultFormat(@NonNull SimpleDateFormat resultFormat) {
            if (resultFormat == null) {
                throw new NullPointerException("resultFormat is marked non-null but is null");
            }
            this.resultFormat = resultFormat;
            return this;
        }

        public TimeParsingExtractionFunction build() {
            return new TimeParsingExtractionFunction(this.timeFormat, this.resultFormat);
        }

        public String toString() {
            return "TimeParsingExtractionFunction.TimeParsingExtractionFunctionBuilder(timeFormat=" + this.timeFormat + ", resultFormat=" + this.resultFormat + ")";
        }
    }
}

