/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.config;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.NonNull;
import org.joda.time.DateTime;

public class Interval {
    private static final String DRUID_INTERVAL_FORMAT = "%s/%s";
    private DateTime startTime;
    private DateTime endTime;

    public Interval(@NonNull DateTime startTime, @NonNull DateTime endTime) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @JsonValue
    private String getIntervalAsString() {
        return String.format(DRUID_INTERVAL_FORMAT, this.startTime.toDateTimeISO(), this.endTime.toDateTimeISO());
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        DateTime this$endTime = this.getEndTime();
        DateTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Interval;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        DateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        return result;
    }
}

