/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.scan;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.query.DruidQuery;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.config.Context;
import in.zapr.druid.druidry.query.config.Interval;
import in.zapr.druid.druidry.query.scan.ResultFormat;
import in.zapr.druid.druidry.virtualColumn.DruidVirtualColumn;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidScanQuery
extends DruidQuery {
    private List<DruidVirtualColumn> virtualColumns;
    private DruidFilter filter;
    private Integer batchSize;
    private List<Interval> intervals;
    private List<String> columns;
    private ResultFormat resultFormat;
    private Long limit;
    private Boolean legacy;

    private DruidScanQuery(@NonNull DataSource dataSource, List<DruidVirtualColumn> virtualColumns, DruidFilter filter, Integer batchSize, @NonNull List<Interval> intervals, List<String> columns, ResultFormat resultFormat, Long limit, Boolean legacy, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals is marked non-null but is null");
        }
        this.virtualColumns = virtualColumns;
        this.filter = filter;
        this.intervals = intervals;
        this.columns = columns;
        this.resultFormat = resultFormat;
        this.queryType = QueryType.SCAN;
        this.context = context;
        this.dataSource = dataSource;
        this.legacy = legacy;
        this.limit = limit;
        this.batchSize = batchSize;
        if (limit != null) {
            Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"limit specified must be more than 0");
        }
        if (batchSize != null) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize specified must be more than 0");
        }
    }

    public static DruidScanQueryBuilder builder() {
        return new DruidScanQueryBuilder();
    }

    public List<DruidVirtualColumn> getVirtualColumns() {
        return this.virtualColumns;
    }

    public DruidFilter getFilter() {
        return this.filter;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Boolean getLegacy() {
        return this.legacy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidScanQuery)) {
            return false;
        }
        DruidScanQuery other = (DruidScanQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DruidVirtualColumn> this$virtualColumns = this.getVirtualColumns();
        List<DruidVirtualColumn> other$virtualColumns = other.getVirtualColumns();
        if (this$virtualColumns == null ? other$virtualColumns != null : !((Object)this$virtualColumns).equals(other$virtualColumns)) {
            return false;
        }
        DruidFilter this$filter = this.getFilter();
        DruidFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        Integer this$batchSize = this.getBatchSize();
        Integer other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        List<Interval> this$intervals = this.getIntervals();
        List<Interval> other$intervals = other.getIntervals();
        if (this$intervals == null ? other$intervals != null : !((Object)this$intervals).equals(other$intervals)) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        ResultFormat this$resultFormat = this.getResultFormat();
        ResultFormat other$resultFormat = other.getResultFormat();
        if (this$resultFormat == null ? other$resultFormat != null : !((Object)((Object)this$resultFormat)).equals((Object)other$resultFormat)) {
            return false;
        }
        Long this$limit = this.getLimit();
        Long other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$legacy = this.getLegacy();
        Boolean other$legacy = other.getLegacy();
        return !(this$legacy == null ? other$legacy != null : !((Object)this$legacy).equals(other$legacy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidScanQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DruidVirtualColumn> $virtualColumns = this.getVirtualColumns();
        result = result * 59 + ($virtualColumns == null ? 43 : ((Object)$virtualColumns).hashCode());
        DruidFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        Integer $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        List<Interval> $intervals = this.getIntervals();
        result = result * 59 + ($intervals == null ? 43 : ((Object)$intervals).hashCode());
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        ResultFormat $resultFormat = this.getResultFormat();
        result = result * 59 + ($resultFormat == null ? 43 : ((Object)((Object)$resultFormat)).hashCode());
        Long $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $legacy = this.getLegacy();
        result = result * 59 + ($legacy == null ? 43 : ((Object)$legacy).hashCode());
        return result;
    }

    public static class DruidScanQueryBuilder {
        private DataSource dataSource;
        private List<DruidVirtualColumn> virtualColumns;
        private DruidFilter filter;
        private Integer batchSize;
        private List<Interval> intervals;
        private List<String> columns;
        private ResultFormat resultFormat;
        private Long limit;
        private Boolean legacy;
        private Context context;

        DruidScanQueryBuilder() {
        }

        public DruidScanQueryBuilder dataSource(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.dataSource = dataSource;
            return this;
        }

        public DruidScanQueryBuilder virtualColumns(List<DruidVirtualColumn> virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public DruidScanQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidScanQueryBuilder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public DruidScanQueryBuilder intervals(@NonNull List<Interval> intervals) {
            if (intervals == null) {
                throw new NullPointerException("intervals is marked non-null but is null");
            }
            this.intervals = intervals;
            return this;
        }

        public DruidScanQueryBuilder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public DruidScanQueryBuilder resultFormat(ResultFormat resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        public DruidScanQueryBuilder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public DruidScanQueryBuilder legacy(Boolean legacy) {
            this.legacy = legacy;
            return this;
        }

        public DruidScanQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidScanQuery build() {
            return new DruidScanQuery(this.dataSource, this.virtualColumns, this.filter, this.batchSize, this.intervals, this.columns, this.resultFormat, this.limit, this.legacy, this.context);
        }

        public String toString() {
            return "DruidScanQuery.DruidScanQueryBuilder(dataSource=" + this.dataSource + ", virtualColumns=" + this.virtualColumns + ", filter=" + this.filter + ", batchSize=" + this.batchSize + ", intervals=" + this.intervals + ", columns=" + this.columns + ", resultFormat=" + (Object)((Object)this.resultFormat) + ", limit=" + this.limit + ", legacy=" + this.legacy + ", context=" + this.context + ")";
        }
    }
}

