/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.virtualColumn;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.dimension.enums.OutputType;
import in.zapr.druid.druidry.virtualColumn.DruidVirtualColumn;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExpressionVirtualColumn
extends DruidVirtualColumn {
    private static final String EXPRESSION_VIRTUAL_COLUMN = "expression";
    @NonNull
    private String expression;

    public ExpressionVirtualColumn(@NonNull String name, @NonNull String expression, OutputType outputType) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        this.type = EXPRESSION_VIRTUAL_COLUMN;
        this.name = name;
        this.outputType = outputType;
        this.expression = expression;
    }

    public static ExpressionVirtualColumnBuilder builder() {
        return new ExpressionVirtualColumnBuilder();
    }

    @NonNull
    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionVirtualColumn)) {
            return false;
        }
        ExpressionVirtualColumn other = (ExpressionVirtualColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionVirtualColumn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    public static class ExpressionVirtualColumnBuilder {
        private String name;
        private String expression;
        private OutputType outputType;

        ExpressionVirtualColumnBuilder() {
        }

        public ExpressionVirtualColumnBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ExpressionVirtualColumnBuilder expression(@NonNull String expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
            return this;
        }

        public ExpressionVirtualColumnBuilder outputType(OutputType outputType) {
            this.outputType = outputType;
            return this;
        }

        public ExpressionVirtualColumn build() {
            return new ExpressionVirtualColumn(this.name, this.expression, this.outputType);
        }

        public String toString() {
            return "ExpressionVirtualColumn.ExpressionVirtualColumnBuilder(name=" + this.name + ", expression=" + this.expression + ", outputType=" + (Object)((Object)this.outputType) + ")";
        }
    }
}

