/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.event.selection.SingleSelectionListener;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import io.imunity.webconsole.tprofile.ActionParameterComponent;
import io.imunity.webconsole.tprofile.ActionParameterComponentProvider;
import io.imunity.webconsole.tprofile.ExpressionActionParameterComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.types.translation.ActionParameterDefinition;
import pl.edu.icm.unity.types.translation.TranslationAction;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.LayoutEmbeddable;
import pl.edu.icm.unity.webui.common.NotificationPopup;
import pl.edu.icm.unity.webui.common.Styles;

public class ActionEditor
extends LayoutEmbeddable {
    private static final Logger log = Log.getLogger((String)"unity.server.web", ActionEditor.class);
    private MessageSource msg;
    private TypesRegistryBase<? extends TranslationActionFactory<?>> tc;
    private ComboBox<String> actions;
    private Label actionParams;
    private ActionParameterComponentProvider actionComponentProvider;
    private List<ActionParameterComponent> paramComponents = new ArrayList<ActionParameterComponent>();
    private BiConsumer<String, Optional<TranslationAction>> callback;

    public ActionEditor(MessageSource msg, TypesRegistryBase<? extends TranslationActionFactory<?>> tc, TranslationAction toEdit, ActionParameterComponentProvider actionComponentProvider, BiConsumer<String, Optional<TranslationAction>> callback) {
        this.msg = msg;
        this.tc = tc;
        this.actionComponentProvider = actionComponentProvider;
        this.callback = callback;
        this.initUI(toEdit);
    }

    public ActionEditor(MessageSource msg, TypesRegistryBase<? extends TranslationActionFactory<?>> tc, TranslationAction toEdit, ActionParameterComponentProvider actionComponentProvider) {
        this(msg, tc, toEdit, actionComponentProvider, null);
    }

    private void initUI(TranslationAction toEdit) {
        this.actions = new ComboBox(this.msg.getMessage("ActionEditor.ruleAction", new Object[0]));
        ArrayList items = new ArrayList();
        this.tc.getAll().stream().map(af -> af.getActionType().getName()).sorted().forEach(actionName -> items.add(actionName));
        this.actions.setStyleName(Styles.vTiny.toString());
        this.actions.setItems(items);
        this.actions.setEmptySelectionAllowed(false);
        this.actions.setRequiredIndicatorVisible(true);
        this.actions.addSelectionListener((SingleSelectionListener & Serializable)e -> {
            this.setParams((String)this.actions.getValue(), null);
            if (this.callback != null) {
                this.callback.accept(this.getStringRepresentation(), this.getActionIfValid());
            }
        });
        this.actionParams = new Label();
        this.actionParams.setCaption(this.msg.getMessage("ActionEditor.actionParameters", new Object[0]));
        this.addComponents(new Component[]{this.actions, this.actionParams});
        if (toEdit != null) {
            this.setInput(toEdit);
        } else if (!items.isEmpty()) {
            this.actions.setValue((Object)((String)items.iterator().next()));
            this.setParams((String)this.actions.getValue(), null);
        }
    }

    public void setInput(TranslationAction toEdit) {
        this.actions.setValue((Object)toEdit.getName());
        this.setParams(((String)this.actions.getValue()).toString(), toEdit.getParameters());
    }

    private Optional<TranslationAction> getActionIfValid() {
        try {
            return Optional.of(this.getAction());
        }
        catch (FormValidationException e) {
            return Optional.empty();
        }
    }

    private void setParams(String action, String[] values) {
        Runnable paramCallback = () -> {
            if (this.callback != null) {
                this.callback.accept(this.getStringRepresentation(), this.getActionIfValid());
            }
        };
        this.removeComponents(this.paramComponents);
        this.paramComponents.clear();
        TranslationActionFactory<?> factory = this.getActionFactory(action);
        if (factory == null) {
            return;
        }
        this.actions.setDescription(this.msg.getMessage(factory.getActionType().getDescriptionKey(), new Object[0]));
        ActionParameterDefinition[] params = factory.getActionType().getParameters();
        for (int i = 0; i < params.length; ++i) {
            ActionParameterComponent p = this.actionComponentProvider.getParameterComponent(params[i]);
            p.setStyleName(Styles.vTiny.toString());
            p.addValueChangeCallback(paramCallback);
            if (values != null && values.length > i) {
                p.setActionValue(values[i]);
            }
            this.paramComponents.add(p);
            this.addComponent(p);
        }
        this.actionParams.setVisible(!this.paramComponents.isEmpty());
    }

    private String[] getActionParams() throws FormValidationException {
        ArrayList<String> params = new ArrayList<String>();
        boolean errors = false;
        for (ActionParameterComponent tc : this.paramComponents) {
            if (!tc.isValid()) {
                errors = true;
                continue;
            }
            params.add(tc.getActionValue());
        }
        if (errors) {
            throw new FormValidationException();
        }
        String[] wrapper = new String[params.size()];
        return params.toArray(wrapper);
    }

    private TranslationActionFactory<?> getActionFactory(String action) {
        TranslationActionFactory factory = null;
        try {
            factory = (TranslationActionFactory)this.tc.getByName(action);
        }
        catch (Exception e) {
            NotificationPopup.showError((MessageSource)this.msg, (String)this.msg.getMessage("ActionEditor.errorGetActions", new Object[0]), (Exception)e);
        }
        return factory;
    }

    public TranslationAction getAction() throws FormValidationException {
        TranslationActionFactory<?> factory = this.getActionFactory((String)this.actions.getValue());
        try {
            return factory.getInstance(this.getActionParams());
        }
        catch (FormValidationException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug("Got profile's action validation exception", (Throwable)e);
            String error = this.msg.getMessage("ActionEditor.parametersError", new Object[]{e.getMessage()});
            UserError ue = new UserError(error);
            for (ActionParameterComponent tc : this.paramComponents) {
                ((AbstractComponent)tc).setComponentError((ErrorMessage)ue);
            }
            throw new FormValidationException(error);
        }
    }

    public void setReadOnlyStyle(boolean readOnly) {
        this.actions.setReadOnly(readOnly);
        for (ActionParameterComponent param : this.paramComponents) {
            param.setReadOnly(readOnly);
        }
    }

    public void indicateExpressionError(Exception e) {
        for (ActionParameterComponent c : this.paramComponents) {
            if (!(c instanceof ExpressionActionParameterComponent)) continue;
            ExpressionActionParameterComponent extension = (ExpressionActionParameterComponent)c;
            extension.setStyleName(Styles.errorBackground.toString());
            extension.setComponentError((ErrorMessage)new UserError(NotificationPopup.getHumanMessage((Throwable)e)));
            break;
        }
    }

    public void setStyle(String style) {
        this.actions.setStyleName(style);
        for (ActionParameterComponent c : this.paramComponents) {
            c.setStyleName(style);
        }
    }

    public void removeComponentEvaluationStyle() {
        this.actions.removeStyleName(Styles.falseConditionBackground.toString());
        this.actions.removeStyleName(Styles.trueConditionBackground.toString());
        for (ActionParameterComponent c : this.paramComponents) {
            c.removeStyleName(Styles.falseConditionBackground.toString());
            c.removeStyleName(Styles.trueConditionBackground.toString());
            c.removeStyleName(Styles.errorBackground.toString());
            if (!(c instanceof ExpressionActionParameterComponent)) continue;
            ExpressionActionParameterComponent extension = (ExpressionActionParameterComponent)c;
            extension.setComponentError(null);
        }
    }

    public String getStringRepresentation() {
        StringBuilder rep = new StringBuilder();
        rep.append((String)this.actions.getValue());
        rep.append("|");
        for (ActionParameterComponent tc : this.paramComponents) {
            Object caption = tc.getCaption();
            if (caption != null && !((String)caption).endsWith(":")) {
                caption = (String)caption + ":";
            }
            rep.append((String)caption + " " + (tc.getActionValueRepresentation(this.msg) != null && !tc.getActionValue().equals("null") ? tc.getActionValueRepresentation(this.msg) : " "));
            rep.append("|");
        }
        return rep.substring(0, rep.length() - 1);
    }

    public void refresh() {
        this.setParams((String)this.actions.getValue(), (String[])this.paramComponents.stream().map(pc -> pc.getActionValue()).toArray(String[]::new));
        if (this.callback != null) {
            this.callback.accept(this.getStringRepresentation(), this.getActionIfValid());
        }
    }
}

