/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.google.common.base.Supplier;
import com.vaadin.ui.ItemCaptionGenerator;
import io.imunity.webconsole.tprofile.ActionParameterComponent;
import io.imunity.webconsole.tprofile.AttributeActionParameterComponent;
import io.imunity.webconsole.tprofile.BaseEnumActionParameterComponent;
import io.imunity.webconsole.tprofile.BooleanActionParameterComponent;
import io.imunity.webconsole.tprofile.DaysActionParameterComponent;
import io.imunity.webconsole.tprofile.DefaultActionParameterComponent;
import io.imunity.webconsole.tprofile.DynamicGroupParamWithLabel;
import io.imunity.webconsole.tprofile.EnumActionParameterComponent;
import io.imunity.webconsole.tprofile.ExpressionActionParameterComponent;
import io.imunity.webconsole.tprofile.I18nTextActionParameterComponent;
import io.imunity.webconsole.tprofile.IntegerActionParameterComponent;
import io.imunity.webconsole.tprofile.TextAreaActionParameterComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.AttributeTypeManagement;
import pl.edu.icm.unity.engine.api.CredentialRequirementManagement;
import pl.edu.icm.unity.engine.api.GroupsManagement;
import pl.edu.icm.unity.engine.api.MessageTemplateManagement;
import pl.edu.icm.unity.engine.api.RegistrationsManagement;
import pl.edu.icm.unity.engine.api.TranslationProfileManagement;
import pl.edu.icm.unity.engine.api.identity.IdentityTypeSupport;
import pl.edu.icm.unity.engine.api.translation.form.DynamicGroupParam;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.DescribedObjectROImpl;
import pl.edu.icm.unity.types.authn.CredentialRequirements;
import pl.edu.icm.unity.types.basic.AttributeType;
import pl.edu.icm.unity.types.basic.IdentityType;
import pl.edu.icm.unity.types.translation.ActionParameterDefinition;
import pl.edu.icm.unity.types.translation.TranslationProfile;

@PrototypeComponent
public class ActionParameterComponentProvider {
    private MessageSource msg;
    private List<String> groups;
    private Collection<String> credReqs;
    private Collection<String> idTypes;
    private List<AttributeType> atTypes;
    private List<String> inputProfiles;
    private List<String> outputProfiles;
    private List<String> userMessageTemplates;
    private List<String> registrationForm;
    private AttributeTypeManagement attrsMan;
    private IdentityTypeSupport idTypeSupport;
    private CredentialRequirementManagement credReqMan;
    private GroupsManagement groupsMan;
    private TranslationProfileManagement profileMan;
    private MessageTemplateManagement msgTemplateMan;
    private RegistrationsManagement registrationMan;
    private List<Supplier<List<DynamicGroupParamWithLabel>>> dynamicGroupProviders;

    @Autowired
    public ActionParameterComponentProvider(MessageSource msg, AttributeTypeManagement attrsMan, IdentityTypeSupport idTypeSupport, CredentialRequirementManagement credReqMan, GroupsManagement groupsMan, TranslationProfileManagement profileMan, MessageTemplateManagement msgTemplateMan, RegistrationsManagement registrationMan) {
        this.msg = msg;
        this.attrsMan = attrsMan;
        this.idTypeSupport = idTypeSupport;
        this.credReqMan = credReqMan;
        this.groupsMan = groupsMan;
        this.profileMan = profileMan;
        this.msgTemplateMan = msgTemplateMan;
        this.registrationMan = registrationMan;
        this.dynamicGroupProviders = new ArrayList<Supplier<List<DynamicGroupParamWithLabel>>>();
    }

    public void init(Supplier<List<DynamicGroupParamWithLabel>> dynamicGroupProvider) throws EngineException {
        this.init();
        this.dynamicGroupProviders.add(dynamicGroupProvider);
    }

    public void init() throws EngineException {
        this.atTypes = new ArrayList<AttributeType>(this.attrsMan.getAttributeTypes());
        Collections.sort(this.atTypes, (a1, a2) -> a1.getName().compareTo(a2.getName()));
        this.groups = new ArrayList<String>(this.groupsMan.getChildGroups("/"));
        Collections.sort(this.groups);
        Collection crs = this.credReqMan.getCredentialRequirements();
        this.credReqs = new TreeSet<String>();
        for (CredentialRequirements cr : crs) {
            this.credReqs.add(cr.getName());
        }
        Collection idTypesF = this.idTypeSupport.getIdentityTypes();
        this.idTypes = new TreeSet<String>();
        for (IdentityType it : idTypesF) {
            this.idTypes.add(it.getIdentityTypeProvider());
        }
        this.inputProfiles = new ArrayList(this.profileMan.listInputProfiles().keySet());
        Collections.sort(this.inputProfiles);
        this.outputProfiles = new ArrayList(this.profileMan.listOutputProfiles().keySet());
        Collections.sort(this.outputProfiles);
        this.userMessageTemplates = new ArrayList(this.msgTemplateMan.getCompatibleTemplates("UserNotification").keySet());
        Collections.sort(this.userMessageTemplates);
        this.registrationForm = this.registrationMan.getForms().stream().map(DescribedObjectROImpl::getName).collect(Collectors.toList());
    }

    TranslationProfile getInputProfile(String profile) throws EngineException {
        return this.profileMan.getInputProfile(profile);
    }

    TranslationProfile getOutputProfile(String profile) throws EngineException {
        return this.profileMan.getOutputProfile(profile);
    }

    public ActionParameterComponent getParameterComponent(ActionParameterDefinition param) {
        switch (param.getType()) {
            case ENUM: {
                return new EnumActionParameterComponent(param, this.msg);
            }
            case UNITY_ATTRIBUTE: {
                return new AttributeActionParameterComponent(param, this.msg, this.atTypes);
            }
            case UNITY_GROUP: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.groups);
            }
            case UNITY_DYNAMIC_GROUP: {
                return this.getUnityGroupActionParameterComponent(param);
            }
            case UNITY_CRED_REQ: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.credReqs);
            }
            case UNITY_ID_TYPE: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.idTypes);
            }
            case EXPRESSION: {
                return new ExpressionActionParameterComponent(param, this.msg);
            }
            case DAYS: {
                return new DaysActionParameterComponent(param, this.msg);
            }
            case LARGE_TEXT: {
                return new TextAreaActionParameterComponent(param, this.msg);
            }
            case I18N_TEXT: {
                return new I18nTextActionParameterComponent(param, this.msg);
            }
            case BOOLEAN: {
                return new BooleanActionParameterComponent(param, this.msg);
            }
            case INTEGER: {
                return new IntegerActionParameterComponent(param, this.msg);
            }
            case UNITY_INPUT_TRANSLATION_PROFILE: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.inputProfiles);
            }
            case UNITY_OUTPUT_TRANSLATION_PROFILE: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.outputProfiles);
            }
            case USER_MESSAGE_TEMPLATE: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.userMessageTemplates);
            }
            case REGISTRATION_FORM: {
                return new BaseEnumActionParameterComponent(param, this.msg, this.registrationForm);
            }
        }
        return new DefaultActionParameterComponent(param, this.msg);
    }

    private BaseEnumActionParameterComponent getUnityGroupActionParameterComponent(ActionParameterDefinition param) {
        ArrayList<String> groupsWithDynamic = new ArrayList<String>(this.groups);
        HashMap dynamicGroups = new HashMap();
        this.dynamicGroupProviders.forEach(p -> ((List)p.get()).stream().forEach(dg -> dynamicGroups.put(dg.toSelectionRepresentation(), dg.getLabel(this.msg))));
        groupsWithDynamic.addAll(dynamicGroups.keySet());
        BaseEnumActionParameterComponent groupsCombo = new BaseEnumActionParameterComponent(param, this.msg, groupsWithDynamic);
        groupsCombo.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> DynamicGroupParam.isDynamicGroup((String)i) ? (String)dynamicGroups.get(i) : i);
        return groupsCombo;
    }
}

