/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.ComboBox;
import io.imunity.webconsole.tprofile.ActionParameterComponent;
import io.imunity.webconsole.tprofile.StringValueBean;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.types.translation.ActionParameterDefinition;

public class BaseEnumActionParameterComponent
extends ComboBox<String>
implements ActionParameterComponent {
    private List<String> values;
    private Binder<StringValueBean> binder;

    public BaseEnumActionParameterComponent(ActionParameterDefinition desc, MessageSource msg, Collection<?> vals) {
        this.values = vals.stream().map(v -> v.toString()).collect(Collectors.toList());
        this.setItems(this.values);
        String def = this.values.isEmpty() ? null : this.values.iterator().next().toString();
        this.initCommon(desc, msg, def, desc.isMandatory());
    }

    public BaseEnumActionParameterComponent(ActionParameterDefinition desc, MessageSource msg, Object[] vals) {
        this.values = Arrays.stream(vals).map(v -> v.toString()).collect(Collectors.toList());
        this.setItems(this.values);
        String def = this.values.isEmpty() ? null : this.values.iterator().next().toString();
        this.initCommon(desc, msg, def, desc.isMandatory());
    }

    protected final void initCommon(ActionParameterDefinition desc, MessageSource msg, String def, boolean mandatory) {
        this.setEmptySelectionAllowed(!mandatory);
        this.binder = new Binder(StringValueBean.class);
        if (mandatory) {
            this.binder.forField((HasValue)this).asRequired(msg.getMessage("fieldRequired", new Object[0])).withValidator((SerializablePredicate & Serializable)v -> this.values.contains(v), msg.getMessage("TranslationProfileEditor.outdatedValue", new Object[]{desc.getName()})).bind("value");
        } else {
            this.binder.forField((HasValue)this).withValidator((SerializablePredicate & Serializable)v -> v != null ? this.values.contains(v) : true, msg.getMessage("TranslationProfileEditor.outdatedValue", new Object[]{desc.getName()})).bind("value");
        }
        this.binder.setBean((Object)new StringValueBean(def));
        this.setDescription(msg.getMessage(desc.getDescriptionKey(), new Object[0]));
        this.setCaption(desc.getName() + ":");
    }

    @Override
    public String getActionValue() {
        return ((StringValueBean)this.binder.getBean()).getValue();
    }

    @Override
    public String getActionValueRepresentation(MessageSource msg) {
        String value = ((StringValueBean)this.binder.getBean()).getValue();
        return value == null ? null : this.getItemCaptionGenerator().apply((Object)((StringValueBean)this.binder.getBean()).getValue());
    }

    @Override
    public void setActionValue(String value) {
        this.binder.setBean((Object)new StringValueBean(value));
        this.binder.validate();
    }

    @Override
    public void addValueChangeCallback(Runnable callback) {
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> callback.run());
    }

    @Override
    public boolean isValid() {
        this.binder.validate();
        return this.binder.isValid();
    }
}

