/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.dnd.DropTargetExtension;
import com.vaadin.ui.dnd.event.DropListener;
import io.imunity.webconsole.tprofile.ActionParameterComponent;
import io.imunity.webconsole.tprofile.DragDropBean;
import io.imunity.webconsole.tprofile.StringValueBean;
import java.io.Serializable;
import java.util.Optional;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.mvel.MVELExpressionContext;
import pl.edu.icm.unity.types.translation.ActionParameterDefinition;
import pl.edu.icm.unity.webui.common.mvel.MVELExpressionField;

public class ExpressionActionParameterComponent
extends MVELExpressionField
implements ActionParameterComponent {
    private Binder<StringValueBean> binder = new Binder(StringValueBean.class);

    public ExpressionActionParameterComponent(ActionParameterDefinition param, MessageSource msg) {
        super(msg, param.getName() + ":", msg.getMessage(param.getDescriptionKey(), new Object[0]), (MVELExpressionContext)param.getDetails().get());
        this.configureBinding(this.binder, "value", param.isMandatory());
        this.binder.setBean((Object)new StringValueBean());
        this.addBlurListener((FieldEvents.BlurListener & Serializable)event -> this.markAsDirtyRecursive());
        this.addDropHandler();
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
    }

    private void addDropHandler() {
        DropTargetExtension dropTarget = new DropTargetExtension((AbstractComponent)this);
        dropTarget.setDropEffect(DropEffect.MOVE);
        dropTarget.addDropListener((DropListener & Serializable)event -> {
            Optional dragData = event.getDragData();
            if (dragData.isPresent() && dragData.get() instanceof DragDropBean) {
                DragDropBean bean = (DragDropBean)dragData.get();
                this.setValue(this.getValue() + bean.getExpression());
            }
        });
    }

    @Override
    public String getActionValue() {
        return ((StringValueBean)this.binder.getBean()).getValue();
    }

    @Override
    public void setActionValue(String value) {
        this.binder.setBean((Object)new StringValueBean(value));
    }

    @Override
    public boolean isValid() {
        this.binder.validate();
        return this.binder.isValid();
    }

    @Override
    public void addValueChangeCallback(Runnable callback) {
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> callback.run());
    }
}

