/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.server.SerializableFunction;
import io.imunity.webconsole.tprofile.ActionParameterComponent;
import io.imunity.webconsole.tprofile.StringValueBean;
import java.io.Serializable;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.types.I18nString;
import pl.edu.icm.unity.types.translation.ActionParameterDefinition;
import pl.edu.icm.unity.webui.common.i18n.I18nTextField;

public class I18nTextActionParameterComponent
extends I18nTextField
implements ActionParameterComponent {
    private Binder<StringValueBean> binder;

    public I18nTextActionParameterComponent(ActionParameterDefinition desc, MessageSource msg) {
        super(msg, desc.getName() + ":");
        this.setDescription(msg.getMessage(desc.getDescriptionKey(), new Object[0]));
        this.binder = new Binder(StringValueBean.class);
        if (desc.isMandatory()) {
            this.binder.forField((HasValue)this).asRequired(msg.getMessage("fieldRequired", new Object[0])).withConverter((SerializableFunction & Serializable)v -> this.getString((I18nString)v), (SerializableFunction & Serializable)v -> this.getI18nValue((String)v)).bind("value");
        } else {
            this.binder.forField((HasValue)this).withConverter((SerializableFunction & Serializable)v -> this.getString((I18nString)v), (SerializableFunction & Serializable)v -> this.getI18nValue((String)v)).bind("value");
        }
        this.binder.setBean((Object)new StringValueBean());
    }

    @Override
    public String getActionValue() {
        return ((StringValueBean)this.binder.getBean()).getValue();
    }

    @Override
    public void setActionValue(String value) {
        this.binder.setBean((Object)new StringValueBean(value));
    }

    private I18nString getI18nValue(String value) {
        try {
            if (value != null) {
                return (I18nString)Constants.MAPPER.readValue(value, I18nString.class);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't deserialize I18nString from JSON", e);
        }
    }

    private String getString(I18nString value) {
        try {
            return Constants.MAPPER.writeValueAsString((Object)value.toJson());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Can't serialize I18nString to JSON", e);
        }
    }

    @Override
    public void addValueChangeCallback(Runnable callback) {
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> callback.run());
    }

    @Override
    public boolean isValid() {
        this.binder.validate();
        return this.binder.isValid();
    }

    @Override
    public String getActionValueRepresentation(MessageSource msg) {
        I18nString i18nValue = this.getI18nValue(this.getActionValue());
        if (i18nValue != null) {
            return i18nValue.getDefaultLocaleValue(msg);
        }
        return null;
    }
}

